<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\TestPackage;
use App\Models\TestPackageGroup;
use App\Models\TestPackageGroupNote;
use App\Models\TestPackageNote;

class TestPackagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks
        \DB::statement('SET FOREIGN_KEY_CHECKS=0');
        TestPackage::truncate();
        TestPackageGroup::truncate();
        TestPackageGroupNote::truncate();
        TestPackageNote::truncate();
        // Enable foreign key checks
        \DB::statement('SET FOREIGN_KEY_CHECKS=1');

        \DB::statement("INSERT INTO `test_packages` (`id`, `department_id`, `sample_type_id`, `name`, `short_name`, `code`, `remarks`, `pre_booking_required`, `report_delivery_tat`, `is_page_break`, `priority`, `show_in_report`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
            (1, 11, 20, 'CBC (COMPLETE BLOOD COUNT)', 'CBC', 'CBC_(COMPLETE_BLOOD_COUNT)', NULL, 0, NULL, 0, 1, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (2, 11, 20, 'TLC (WBC)', 'TLC (WBC)', 'TLC_(WBC)', NULL, 0, NULL, 0, 2, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (3, 11, 20, 'DC', 'DC', 'DC', NULL, 0, NULL, 0, 3, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (4, 11, 20, 'RED BLOOD CELL COUNT', 'RBC', 'RED_BLOOD_CELL_COUNT', NULL, 0, NULL, 0, 4, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (5, 11, 20, 'HEMOGLOBIN (Hb%)', 'Hb%', 'HEMOGLOBIN_(HB%)', NULL, 0, NULL, 0, 5, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (6, 11, 20, 'ERYTHROCYTE SEDIMENTATION RATE (ESR)', 'ESR', 'ERYTHROCYTE_SEDIMENTATION_RATE_(ESR)', NULL, 0, NULL, 0, 6, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (7, 11, 20, 'PLATELET COUNT', 'PC', 'PLATELET_COUNT', NULL, 0, NULL, 0, 7, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (8, 11, 20, 'BLEEDING TIME', 'BT', 'BLEEDING_TIME', NULL, 0, NULL, 0, 8, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (9, 11, 20, 'CLOTTING TIME', 'CT', 'CLOTTING_TIME', NULL, 0, NULL, 0, 9, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (10, 11, 20, 'BAND CELL', 'BC', 'BAND_CELL', NULL, 0, NULL, 0, 10, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (11, 11, 0, 'TOXIC GRANULAR', 'TOXIC', 'TOXIC_GRANULAR', NULL, 0, NULL, 0, 11, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (12, 11, 20, 'ABSOLUTE EOSINOPHILS COUNT', 'AEC', 'ABSOLUTE_EOSINOPHILS_COUNT', NULL, 0, NULL, 0, 12, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (13, 11, 2, 'ABSOLUTE NEUTROPHIL COUNT', 'ANC', 'ABSOLUTE_NEUTROPHIL_COUNT', NULL, 0, NULL, 0, 13, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (14, 11, 0, 'HEMATOCRIT', 'HEMATOCRIT', 'HEMATOCRIT', NULL, 0, NULL, 0, 14, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (15, 5, 0, 'PUS CST', 'PUS CST', 'PUS_CST', NULL, 0, NULL, 0, 15, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (16, 11, 2, 'RETICULOCYTE COUNT', 'RC', 'RETICULOCYTE_COUNT', NULL, 0, NULL, 0, 16, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (17, 31, 15, 'SR. ALKALINE PHOSPHATASE', 'SR. ALKALINE', 'SR._ALKALINE_PHOSPHATASE', NULL, 0, NULL, 0, 17, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (18, 31, 0, 'BILIRUBIN', 'BLRBN', 'BILIRUBIN', NULL, 0, NULL, 0, 15, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (19, 31, 15, 'AST (SGOT)', 'AST', 'AST_(SGOT)', NULL, 0, NULL, 0, 19, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (20, 31, 15, 'ALT (SGPT)', 'ALT', 'ALT_(SGPT)', NULL, 0, NULL, 0, 20, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (21, 31, 15, 'TOTAL PROTEIN', 'PROTEIN ', 'TOTAL_PROTEIN', NULL, 0, NULL, 0, 21, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (22, 31, 15, 'NEW BORN BILLIRUBIN', 'BILLIRUBIN', 'NEW_BORN_BILLIRUBIN', NULL, 0, NULL, 0, 22, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (23, 31, 15, 'ALBUMIN', 'ALB', 'ALBUMIN', NULL, 0, NULL, 0, 23, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (24, 31, 15, 'BLOOD UREA', 'BU', 'BLOOD_UREA', NULL, 0, NULL, 0, 24, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (25, 31, 15, 'SERUM CREATININE', 'CRTN', 'SERUM_CREATININE', NULL, 0, NULL, 0, 25, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (26, 31, 15, 'URIC ACID', 'URIC ACID', 'URIC_ACID', NULL, 0, NULL, 0, 26, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (27, 31, 15, 'CPK-MB', 'CPK-MB', 'CPK-MB', NULL, 0, NULL, 0, 27, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (28, 31, 15, 'CPK (CREATINE KINASE)', 'CPK', 'CPK_(CREATINE_KINASE)', NULL, 0, NULL, 0, 28, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (29, 31, 15, 'SODIUM NA+', 'NA+', 'SODIUM_NA+', NULL, 0, NULL, 0, 29, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (30, 31, 15, 'POTASSIUM', 'K', 'POTASSIUM', NULL, 0, NULL, 0, 30, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (31, 31, 15, 'CHLORIDE', 'CLRD', 'CHLORIDE', NULL, 0, NULL, 0, 31, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (32, 31, 15, 'MAGNESIUM', 'Mg', 'MAGNESIUM', NULL, 0, NULL, 0, 32, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (33, 31, 2, 'PHOSPHORUS', 'PHOSPHORUS', 'PHOSPHORUS', NULL, 0, NULL, 0, 33, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (34, 31, 15, 'CALCIUM', 'Ca', 'CALCIUM', NULL, 0, NULL, 0, 34, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (35, 31, 15, 'AMYLASE', 'AMLS', 'AMYLASE', NULL, 0, NULL, 0, 35, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (36, 31, 15, 'LIPASE', 'LIPASE', 'LIPASE', NULL, 0, NULL, 0, 36, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (37, 31, 9, 'RANDOM BIOOD SUGAR (RBS)', 'RBS', 'RANDOM_BIOOD_SUGAR_(RBS)', NULL, 0, NULL, 0, 37, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (38, 31, 9, 'FASTING BLOOD SUGAR (FBS)', 'Fbs', 'FASTING_BLOOD_SUGAR_(FBS)', NULL, 0, NULL, 0, 38, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (39, 31, 9, 'POST PRANDIAL BLOOD SUGAR (PPBS)', 'PPBS', 'POST_PRANDIAL_BLOOD_SUGAR_(PPBS)', NULL, 0, NULL, 0, 39, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (40, 31, 15, 'LIPID PROFILE', 'LP', 'LIPID_PROFILE', NULL, 0, NULL, 0, 40, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (41, 31, 15, 'KIDNEY FUNCTION TEST(KFT)', 'KFT', 'KIDNEY_FUNCTION_TEST(KFT)', NULL, 0, NULL, 0, 41, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (42, 31, 2, 'TOTAL IGE', 'TOTAL IGE', 'TOTAL_IGE', NULL, 0, NULL, 0, 42, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (43, 31, 15, 'CHOLESTEROL', 'CHOLESTEROL', 'CHOLESTEROL', NULL, 0, NULL, 0, 43, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (44, 31, 15, 'TRIGLYCERIDES', 'TRIGLYCERIDES', 'TRIGLYCERIDES', NULL, 0, NULL, 0, 44, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (45, 31, 15, 'SODIUM & POTASIUM', 'Na & K', 'SODIUM_&_POTASIUM', NULL, 0, NULL, 0, 45, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (46, 31, 15, 'PHOSPHATE', 'PHOSPHATE', 'PHOSPHATE', NULL, 0, NULL, 0, 46, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (47, 31, 15, 'GLOBULIN', 'GLOBULIN', 'GLOBULIN', NULL, 0, NULL, 0, 47, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (48, 31, 15, 'GGT', 'GGT', 'GGT', NULL, 0, NULL, 0, 48, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (49, 8, 2, 'TROP-I', 'TROP-I', 'TROP-I', NULL, 0, NULL, 0, 49, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (50, 31, 15, 'DIRECT-LDL CHOLESTEROL', 'LDL CHLTRL', 'DIRECT-LDL_CHOLESTEROL', NULL, 0, NULL, 0, 50, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (51, 11, 20, 'BLOOD GROUP (ABO-RH)', 'ABO-RH', 'BLOOD_GROUP_(ABO-RH)', NULL, 0, NULL, 0, 51, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (52, 1, 19, 'URINE ROUTINE EXAMINATION (R/E)', 'Urine re', 'URINE_ROUTINE_EXAMINATION_(R/E)', NULL, 0, NULL, 0, 52, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (53, 5, 0, 'STOOL CST', 'STOOL CST', 'STOOL_CST', NULL, 0, NULL, 0, 53, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (54, 6, 0, 'DRUG OF ABUSE (DOA) 6.1 PANEL', 'DOA', 'DRUG_OF_ABUSE_(DOA)_6.1_PANEL', NULL, 0, NULL, 0, 54, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (55, 7, 15, 'ELECTROLYTE TEST', 'ET', 'ELECTROLYTE_TEST', NULL, 0, NULL, 0, 55, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (56, 8, 20, 'TROPONIN – T', 'TROPONIN – T', 'TROPONIN_–_T', NULL, 0, NULL, 0, 56, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (57, 9, 16, 'SPUTUM AFB', 'SPUTUM AFB', 'SPUTUM_AFB', NULL, 0, NULL, 0, 57, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (58, 12, 19, 'MICROALBUMINURIA, URINE', 'Mic-LBU-URINE', 'MICROALBUMINURIA,_URINE', NULL, 0, NULL, 0, 58, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (59, 13, 0, 'NAIL CLIPING FOR FUNGAL ELEMENTS BY KOH WET MOUNT', 'NAIL CLIPPING', 'NAIL_CLIPING_FOR_FUNGAL_ELEMENTS_BY_KOH_WET_MOUNT', NULL, 0, NULL, 0, 59, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (60, 14, 2, 'Oral Glucose Tolerance Test (OGTT)', 'OGTT', 'ORAL_GLUCOSE_TOLERANCE_TEST_(OGTT)', NULL, 0, NULL, 0, 60, 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (61, 15, 20, 'PERIPHERAL BLOOD SMEAR', 'PBS', 'PERIPHERAL_BLOOD_SMEAR', NULL, 0, NULL, 0, 61, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (62, 16, 15, 'RENAL FUNCTION TEST (RFT)', 'RFT', 'RENAL_FUNCTION_TEST_(RFT)', NULL, 0, NULL, 0, 62, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (63, 18, 15, 'SEROLOGY PROFILE', 'SP', 'SEROLOGY_PROFILE', NULL, 0, NULL, 0, 63, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (64, 18, 15, 'HEPATITIS B SURFACE ANTIGEN', 'HBsAg', 'HEPATITIS_B_SURFACE_ANTIGEN', NULL, 0, NULL, 0, 64, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (65, 18, 15, 'HUMAN IMMUNODEFICIENCY VIRUS', 'HIV I & II ', 'HUMAN_IMMUNODEFICIENCY_VIRUS', NULL, 0, NULL, 0, 65, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (66, 18, 15, 'HEPATITIS C ANTIBODY TEST', 'ANTI HCV', 'HEPATITIS_C_ANTIBODY_TEST', NULL, 0, NULL, 0, 66, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (67, 18, 0, 'HEV(METHOD BY ICT)', 'HEV', 'HEV(METHOD_BY_ICT)', NULL, 0, NULL, 0, 67, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (68, 18, 15, 'VENEREAL DISEASE RESEARCH L..', 'VDRL', 'VENEREAL_DISEASE_RESEARCH_L..', NULL, 0, NULL, 0, 68, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (69, 18, 15, 'TYPHIDOT TEST', 'TYPHIDOT', 'TYPHIDOT_TEST', NULL, 0, NULL, 0, 69, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (70, 5, 0, 'SEMENT CST', 'SEMENT CST', 'SEMENT_CST', NULL, 0, NULL, 0, 70, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (71, 18, 2, 'DENGUE NS1 ANTIGEN', 'DENGUE', 'DENGUE_NS1_ANTIGEN', NULL, 0, NULL, 0, 71, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (72, 18, 15, 'ASO', 'ASO', 'ASO', NULL, 0, NULL, 0, 72, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (73, 31, 15, 'CALCIUM - Ionized', '', 'CALCIUM_-_IONIZED', NULL, 0, NULL, 0, 73, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (74, 18, 15, 'C-REACTIVE PROTEIN (CRP)', 'CRP', 'C-REACTIVE_PROTEIN_(CRP)', NULL, 0, NULL, 0, 74, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (75, 18, 0, 'MANTOUX TEST', 'MANTOUX', 'MANTOUX_TEST', NULL, 0, NULL, 0, 75, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (76, 18, 15, 'HAV Igm', 'HAV', 'HAV_IGM', NULL, 0, NULL, 0, 76, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (77, 18, 15, 'HEV Igm', 'HEV', 'HEV_IGM', NULL, 0, NULL, 0, 77, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (78, 18, 0, 'Scrub Typhus IgM & IgG', 'IgM & IgG', 'SCRUB_TYPHUS_IGM_&_IGG', NULL, 0, NULL, 0, 78, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (79, 19, 0, 'SKIN SCRAPING FOR FUNGAL ELEMENTS BY KOH WET MOUNT', 'SKIN SCRAPING', 'SKIN_SCRAPING_FOR_FUNGAL_ELEMENTS_BY_KOH_WET_MOUNT', NULL, 0, NULL, 0, 79, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (80, 20, 0, 'SPUTUM GRAMSTAIN', 'SPUTUM GRAMSTAIN', 'SPUTUM_GRAMSTAIN', NULL, 0, NULL, 0, 80, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (81, 21, 0, 'SPUTUM ROUTINE EXAMINATION', 'SRE', 'SPUTUM_ROUTINE_EXAMINATION', NULL, 0, NULL, 0, 81, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (82, 22, 17, 'STOOL RE', 'STOOL RE', 'STOOL_RE', NULL, 0, NULL, 0, 82, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (83, 22, 17, 'STOOL REDUCING SUGAR', 'SRS', 'STOOL_REDUCING_SUGAR', NULL, 0, NULL, 0, 83, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (84, 22, 17, 'STOOL OBT', 'STOOL OBT', 'STOOL_OBT', NULL, 0, NULL, 0, 84, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (85, 23, 0, 'URINALYSIS', 'URINALYSIS', 'URINALYSIS', NULL, 0, NULL, 0, 85, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (86, 23, 19, 'URINE SUGAR', 'UA', 'URINE_SUGAR', NULL, 0, NULL, 0, 86, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (87, 23, 19, 'URINE FOR PROTEIN', 'URINE FOR PROTEIN', 'URINE_FOR_PROTEIN', NULL, 0, NULL, 0, 87, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (88, 23, 19, 'URINE BS/BP', 'URINE BS/BP', 'URINE_BS/BP', NULL, 0, NULL, 0, 88, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (89, 31, 15, 'Lactate dehydrogenase (LDH)', '', 'LACTATE_DEHYDROGENASE_(LDH)', NULL, 0, NULL, 0, 89, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (90, 5, 0, 'SPUTUM CST', 'SPUTUM CST', 'SPUTUM_CST', NULL, 0, NULL, 0, 90, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (91, 24, 0, 'SPECIFIC GRAVITY', 'SPECIFIC GRAVITY', 'SPECIFIC_GRAVITY', NULL, 0, NULL, 0, 91, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (92, 24, 0, 'URETHRAL DISCHARGE', 'URETHRAL DISCHARGE', 'URETHRAL_DISCHARGE', NULL, 0, NULL, 0, 92, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (93, 25, 19, 'URINE BENCE JONES PROTEIN', 'UBJ-Protine', 'URINE_BENCE_JONES_PROTEIN', NULL, 0, NULL, 0, 93, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (94, 26, 19, 'Urine For Pregnancy Test', 'Pregnancy Test', 'URINE_FOR_PREGNANCY_TEST', NULL, 0, NULL, 0, 94, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (95, 0, 0, 'STN-LATERAL VIEW', 'STN', 'STN-LATERAL_VIEW', NULL, 0, NULL, 0, 95, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (96, 2, 15, 'TSH (THYROIDE STIMULATING HORMONE)', 'TSH', 'TSH_(THYROIDE_STIMULATING_HORMONE)', NULL, 0, NULL, 0, 96, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (97, 31, 15, 'THYROID PROFILE (T3 T4 TSH)', 'T3 T4 TSH', 'THYROID_PROFILE_(T3_T4_TSH)', NULL, 0, NULL, 0, 97, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (98, 37, 3, 'FLUID EXAMINATION', 'FE', 'FLUID_EXAMINATION', NULL, 0, NULL, 0, 98, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (99, 2, 15, 'FT3 FT4', 'FT3 FT4', 'FT3_FT4', NULL, 0, NULL, 0, 99, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (100, 5, 0, 'THROAT SWAB', 'THROAT SWAB', 'THROAT_SWAB', NULL, 0, NULL, 0, 100, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (101, 5, 0, 'SPUTUM RE', 'SPUTUM RE', 'SPUTUM_RE', NULL, 0, NULL, 0, 101, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (102, 5, 0, 'SPUTUM MELIGNANT CELL', 'SMC', 'SPUTUM_MELIGNANT_CELL', NULL, 0, NULL, 0, 102, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (103, 5, 0, 'AURAL SWAB CST', 'ASC', 'AURAL_SWAB_CST', NULL, 0, NULL, 0, 103, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (104, 5, 0, 'KOH FOR SKIN CST', 'KOH-SKIN', 'KOH_FOR_SKIN_CST', NULL, 0, NULL, 0, 104, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (105, 5, 0, 'CST', 'CST', 'CST', NULL, 0, NULL, 0, 105, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (106, 36, 19, 'URINE CULTURE SENSITIVITY', '', 'URINE_CULTURE_SENSITIVITY', NULL, 0, NULL, 0, 106, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (107, 18, 20, 'MALARIA ANTIGEN (MPDA)', 'MP KIT', 'MALARIA_ANTIGEN_(MPDA)', NULL, 0, NULL, 0, 107, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (108, 11, 20, 'BLOOD SMEAR FOR MP', 'BS-MP', 'BLOOD_SMEAR_FOR_MP', NULL, 0, NULL, 0, 108, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (109, 5, 0, 'PUS CST-CULTURE AEROBIC & SUSCEPTIBILITY', 'PUS CST', 'PUS_CST-CULTURE_AEROBIC_&_SUSCEPTIBILITY', NULL, 0, NULL, 0, 109, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (110, 33, 14, 'SEMEN ANALYSIS', '', 'SEMEN_ANALYSIS', NULL, 0, NULL, 0, 110, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (111, 11, 20, 'Blood Routine Examination', 'BRE', 'BLOOD_ROUTINE_EXAMINATION', NULL, 0, NULL, 0, 111, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (112, 31, 15, 'LIVER FUNCTION TEST (LFT)', 'LFT', 'LIVER_FUNCTION_TEST_(LFT)', NULL, 0, NULL, 0, 112, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (113, 36, 0, 'CULTURE & SENSITIVITY', 'CS', 'CULTURE_&_SENSITIVITY', NULL, 0, NULL, 0, 113, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (114, 24, 19, 'URINE RE/ME', '', 'URINE_RE/ME', NULL, 0, NULL, 0, 114, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (115, 52, 9, 'ACTIVATED PARTIAL THROMBOPLASTIN TIME (APTT)', 'APT', 'ACTIVATED_PARTIAL_THROMBOPLASTIN_TIME_(APTT)', NULL, 0, NULL, 0, 115, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (116, 1, 19, 'URINE MICROALBUMIN / CREATININE RATIO (ACR)', 'ACR', 'URINE_MICROALBUMIN_/_CREATININE_RATIO_(ACR)', NULL, 0, NULL, 0, 116, 1, 1, '2024-04-20 04:40:05', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
            (117, 22, 17, 'STOOL OPC', 'STOOL OPC', 'STOOL_OPC', NULL, 0, NULL, 0, 117, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (118, 35, 20, 'HPLC (Hb Electrophoresis)', 'HPLC', 'HPLC_(HB_ELECTROPHORESIS)', NULL, 0, NULL, 0, 118, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (119, 31, 20, 'HbA1c', 'HBA1C', 'HBA1C', NULL, 0, NULL, 0, 119, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (120, 2, 15, 'T4 TSH', 'T4 TSH', 'T4_TSH', NULL, 0, NULL, 0, 120, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (121, 18, 15, 'WIDAL TEST', 'WIDAL TEST', 'WIDAL_TEST', NULL, 0, NULL, 0, 121, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (122, 44, 19, 'HCG (PREGNANCY TEST)', '', 'HCG_(PREGNANCY_TEST)', NULL, 0, NULL, 0, 122, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (123, 18, 15, 'ASO(SLIDE)', 'ASO', 'ASO(SLIDE)', NULL, 0, NULL, 0, 123, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (124, 38, 20, 'Prothrombin Time and International Normalized Ratio (PT/INR) Studies', 'PTINR', 'PROTHROMBIN_TIME_AND_INTERNATIONAL_NORMALIZED_RATIO_(PT/INR)_STUDIES', NULL, 0, NULL, 0, 124, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (125, 31, 1, 'FLUID EXAMINATION, ROUTINE, BODY FLUIDS', 'ROUTINE TEST', 'FLUID_EXAMINATION,_ROUTINE,_BODY_FLUIDS', NULL, 0, NULL, 0, 125, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (126, 39, 1, 'SERUM ASCITES ALBUMIN GRADIENT (SAAG)', 'SAAG', 'SERUM_ASCITES_ALBUMIN_GRADIENT_(SAAG)', NULL, 0, NULL, 0, 126, 1, 1, '2024-04-20 04:40:05', '2024-04-25 10:01:13', '2024-04-25 10:01:13'),
            (127, 40, 1, 'ADENOSINE DEAMINASE (AD)', 'AD', 'ADENOSINE_DEAMINASE_(AD)', NULL, 0, NULL, 0, 127, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (128, 41, 1, 'OVARIAN CANCER MARKER, SERUM (CA 125)', 'OCN-SERUM', 'OVARIAN_CANCER_MARKER,_SERUM_(CA_125)', NULL, 0, NULL, 0, 128, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (129, 42, 0, 'CYTOPATHOLOGY REPORT', 'CR', 'CYTOPATHOLOGY_REPORT', NULL, 0, NULL, 0, 129, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (130, 8, 20, 'Anti-ds DNA Antibody', '', 'ANTI-DS_DNA_ANTIBODY', NULL, 0, NULL, 0, 130, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (131, 31, 19, 'Vitamin D Hydroxy', '', 'VITAMIN_D_HYDROXY', NULL, 0, NULL, 0, 131, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (132, 11, 20, 'Packed Cell Volume (PCV)', '', 'PACKED_CELL_VOLUME_(PCV)', NULL, 0, NULL, 0, 132, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (133, 31, 20, 'Luteinizing Hormone (LH)', '', 'LUTEINIZING_HORMONE_(LH)', NULL, 0, NULL, 0, 133, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (134, 36, 20, 'Packed Cell Volume (PVC)', '', 'PACKED_CELL_VOLUME_(PVC)', NULL, 0, NULL, 0, 134, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (135, 31, 20, 'High-Density Lipoprotein (HDL)', '', 'HIGH-DENSITY_LIPOPROTEIN_(HDL)', NULL, 0, NULL, 0, 135, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (136, 31, 20, 'Very low density lipoprotein (VLDL)', '', 'VERY_LOW_DENSITY_LIPOPROTEIN_(VLDL)', NULL, 0, NULL, 0, 136, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (137, 18, 15, 'RHEUMATOID ARTHRITIS FACTOR', 'RA FACTOR', 'RHEUMATOID_ARTHRITIS_FACTOR', NULL, 0, NULL, 0, 137, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (138, 31, 0, 'BS (PP) WITH 50 GRAM GLUCOSE', '', 'BS_(PP)_WITH_50_GRAM_GLUCOSE', NULL, 0, NULL, 0, 138, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (139, 45, 19, 'Urine For Ketone Bodies Test', '', 'URINE_FOR_KETONE_BODIES_TEST', NULL, 0, NULL, 0, 139, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (140, 23, 19, 'Urine Bilesalt and Pigment', '', 'URINE_BILESALT_AND_PIGMENT', NULL, 0, NULL, 0, 140, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (141, 23, 19, 'URINE-UROBILINOGEN', '', 'URINE-UROBILINOGEN', NULL, 0, NULL, 0, 141, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (142, 8, 20, 'CARDIAC TROPONIN-I', '', 'CARDIAC_TROPONIN-I', NULL, 0, NULL, 0, 142, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (143, 18, 20, 'MALARIA ANTIGEN (RAPID)', '', 'MALARIA_ANTIGEN_(RAPID)', NULL, 0, NULL, 0, 143, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (144, 31, 15, 'SERUM CPK (TOTAL)', '', 'SERUM_CPK_(TOTAL)', NULL, 0, NULL, 0, 144, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (145, 31, 20, 'BS (PP) WITH 75 GRAM GLUCOSE', '', 'BS_(PP)_WITH_75_GRAM_GLUCOSE', NULL, 0, NULL, 0, 145, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (146, 2, 20, 'FT3', '', 'FT3', NULL, 0, NULL, 0, 146, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (147, 2, 20, 'FT4', '', 'FT4', NULL, 0, NULL, 0, 147, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (148, 36, 0, 'EYELASH SWAB', '', 'EYELASH_SWAB', NULL, 0, NULL, 0, 148, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (149, 31, 15, 'VITAMIN B12', '', 'VITAMIN_B12', NULL, 0, NULL, 0, 149, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (150, 4, 15, 'AMH', '', 'AMH', NULL, 0, NULL, 0, 150, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (151, 4, 15, 'Prolactin', '', 'PROLACTIN', NULL, 0, NULL, 0, 151, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (152, 18, 15, 'H PYLORI', '', 'H_PYLORI', NULL, 0, NULL, 0, 152, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (153, 46, 0, 'USG', '', 'USG', NULL, 0, NULL, 0, 153, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (154, 31, 20, 'HPLC', '', 'HPLC', NULL, 0, NULL, 0, 154, 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (155, 31, 15, 'QUADRUPLE MARKAR', '', 'QUADRUPLE_MARKAR', NULL, 0, NULL, 0, 155, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (156, 49, 20, 'Allergy profile', '', 'ALLERGY_PROFILE', NULL, 0, NULL, 0, 156, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (157, 44, 19, 'URINE ALBUMIN', '', 'URINE_ALBUMIN', NULL, 0, NULL, 0, 157, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (158, 37, 1, 'ACIDIC FLUID', '', 'ACIDIC_FLUID', NULL, 0, NULL, 0, 158, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (159, 31, 15, 'KFT', '', 'KFT', NULL, 0, NULL, 0, 159, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (160, 11, 5, 'SICKLING TEST', '', 'SICKLING_TEST', NULL, 0, NULL, 0, 160, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (161, 51, 5, 'SCRENING TEST', '', 'SCRENING_TEST', NULL, 0, NULL, 0, 161, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (162, 51, 5, 'SICKLING,SCRENING TEST', 'SICKLING', 'SICKLING,SCRENING_TEST', NULL, 0, NULL, 0, 162, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (163, 31, 5, 'SICKLING', '', 'SICKLING', NULL, 0, NULL, 0, 163, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (164, 23, 19, 'URINE ACETONE', '', 'URINE_ACETONE', NULL, 0, NULL, 0, 164, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (165, 18, 15, 'HAV IGM RAPID', '', 'HAV_IGM_RAPID', NULL, 0, NULL, 0, 165, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (166, 18, 15, 'HEV IGM RAPID', '', 'HEV_IGM_RAPID', NULL, 0, NULL, 0, 166, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (167, 11, 15, 'IMMUNOGLOBULIN IgE', 'IGE', 'IMMUNOGLOBULIN_IGE', NULL, 0, NULL, 0, 167, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (168, 31, 20, 'Vitamin D3', 'Vitamin D3', 'VITAMIN_D3', NULL, 0, NULL, 0, 168, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (169, 4, 9, 'D-DIMER', '', 'D-DIMER', NULL, 0, NULL, 0, 169, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (170, 18, 14, 'DENGUE IgG, IgM ANTIGEN', 'IGG, IGM', 'DENGUE_IGG,_IGM_ANTIGEN', NULL, 0, NULL, 0, 170, 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (171, 31, 2, 'CPK ( CREATINE KINASE )', NULL, NULL, NULL, 0, '1', 0, 171, 1, 1, '2024-04-22 07:43:33', '2024-04-22 07:43:33', NULL),
            (172, 31, 1, 'DIRECT -LDL CHOLESTEROL', 'DIRECT -LDL CHOLESTEROL', NULL, NULL, 0, '1', 0, 172, 1, 1, '2024-04-22 09:20:48', '2024-04-22 09:20:48', NULL),
            (173, 2, 2, 'PUS CST- CULTURE AEROBIC & SUSCEPTIBILITY', 'PUS CST- CULTURE AEROBIC & SUSCEPTIBILITY', NULL, NULL, 0, '1', 0, 173, 1, 1, '2024-04-23 10:16:40', '2024-04-23 10:16:40', NULL),
            (174, 31, 1, 'SERUM AMYLASE', 'SERUM AMYLASE', NULL, NULL, 0, '1', 0, 174, 1, 1, '2024-04-23 10:52:43', '2024-04-23 10:52:43', NULL),
            (175, 31, 2, 'SERUM UREA', 'SERUM UREA', NULL, NULL, 0, '1', 0, 175, 1, 1, '2024-04-23 11:00:18', '2024-04-23 11:00:18', NULL),
            (176, 48, 2, 'URINE- UROBILINOGEN', 'URINE- UROBILINOGEN', NULL, NULL, 0, '1', 0, 176, 1, 1, '2024-04-24 06:48:22', '2024-04-24 06:48:22', NULL),
            (177, 2, 1, 'C- REACTIVE PROTIEN (CRP)', 'C- REACTIVE PROTIEN (CRP)', NULL, NULL, 0, '1', 0, 177, 1, 1, '2024-05-02 08:25:24', '2024-05-02 08:25:24', NULL),
            (178, 38, 2, 'SERUM ASCITES ALBUMIN GRADIENT (SAAG)', NULL, NULL, NULL, 0, '1', 0, 178, 1, 1, '2024-05-03 09:32:36', '2024-05-03 09:32:36', NULL),
            (179, 25, 2, 'URINE BENCE JONES PROTIEN', NULL, NULL, NULL, 0, '1', 0, 179, 1, 1, '2024-05-03 11:35:27', '2024-05-03 11:35:27', NULL),
            (180, 1, 2, 'URINE MICROALBUMIN / CREATININE RATIO (ACR', NULL, NULL, NULL, 0, '1', 0, 180, 1, 1, '2024-05-03 11:46:25', '2024-05-03 11:46:25', NULL),
            (181, 18, 2, 'IMPRESSION', 'IMPRESSION', NULL, NULL, 0, '1', 0, 181, 1, 1, '2024-05-04 08:18:35', '2024-05-04 08:18:35', NULL),
            (182, 31, 2, 'CHLORIDE (Cl-)', NULL, NULL, NULL, 0, '1', 0, 182, 1, 1, '2024-05-04 08:40:51', '2024-05-04 08:40:51', NULL);
        ");

        \DB::statement("INSERT INTO `test_package_groups` (`id`, `test_package_id`, `group_name`, `priority`, `show_in_report`, `page_break`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
            (1, 1, 'CBC (COMPLETE BLOOD COUNT)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (2, 2, 'TLC (WBC)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (3, 3, 'DC', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (4, 4, 'RED BLOOD CELL COUNT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (5, 5, 'HEMOGLOBIN (Hb%)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (6, 6, 'ERYTHROCYTE SEDIMENTATION RATE (ESR)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (7, 7, 'PLATELET COUNT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (8, 8, 'BLEEDING TIME', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (9, 9, 'CLOTTING TIME', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (10, 10, 'BAND CELL', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (11, 11, 'TOXIC GRANULAR', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (12, 12, 'ABSOLUTE EOSINOPHILS COUNT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (13, 13, 'ABSOLUTE NEUTROPHIL COUNT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (14, 14, 'HEMATOCRIT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (15, 15, 'PUS CST', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (16, 16, 'RETICULOCYTE COUNT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (17, 17, 'SR. ALKALINE PHOSPHATASE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (18, 18, 'BILIRUBIN', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (19, 19, 'AST (SGOT)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (20, 20, 'ALT (SGPT)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (21, 21, 'TOTAL PROTEIN', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (22, 22, 'NEW BORN BILLIRUBIN', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (23, 23, 'ALBUMIN', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (24, 24, 'BLOOD UREA', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (25, 25, 'SERUM CREATININE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (26, 26, 'URIC ACID', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (27, 27, 'CPK-MB', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (28, 28, 'CPK (CREATINE KINASE)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (29, 29, 'SODIUM NA+', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (30, 30, 'POTASSIUM', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (31, 31, 'CHLORIDE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (32, 32, 'MAGNESIUM', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (33, 33, 'PHOSPHORUS', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (34, 34, 'CALCIUM', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (35, 35, 'AMYLASE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (36, 36, 'LIPASE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (37, 37, 'RANDOM BIOOD SUGAR (RBS)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (38, 38, 'FASTING BLOOD SUGAR (FBS)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (39, 39, 'POST PRANDIAL BLOOD SUGAR (PPBS)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (40, 40, 'LIPID PROFILE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (41, 41, 'KIDNEY FUNCTION TEST(KFT)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (42, 42, 'TOTAL IGE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (43, 43, 'CHOLESTEROL', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (44, 44, 'TRIGLYCERIDES', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (45, 45, 'SODIUM & POTASIUM', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (46, 46, 'PHOSPHATE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (47, 47, 'GLOBULIN', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (48, 48, 'GGT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (49, 49, 'TROP-I', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (50, 50, 'DIRECT-LDL CHOLESTEROL', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (51, 51, 'BLOOD GROUP (ABO-RH)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (52, 52, 'URINE ROUTINE EXAMINATION (R/E)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (53, 53, 'STOOL CST', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (54, 54, 'DRUG OF ABUSE (DOA) 6.1 PANEL', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (55, 55, 'ELECTROLYTE TEST', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (56, 56, 'TROPONIN – T', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (57, 57, 'SPUTUM AFB', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (58, 58, 'MICROALBUMINURIA, URINE', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (59, 59, 'NAIL CLIPING FOR FUNGAL ELEMENTS BY KOH WET MOUNT', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (60, 60, 'Oral Glucose Tolerance Test (OGTT)', 1, 0, 0, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04', NULL),
            (61, 61, 'PERIPHERAL BLOOD SMEAR', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (62, 62, 'RENAL FUNCTION TEST (RFT)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (63, 63, 'SEROLOGY PROFILE', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (64, 64, 'HEPATITIS B SURFACE ANTIGEN', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (65, 65, 'HUMAN IMMUNODEFICIENCY VIRUS', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (66, 66, 'HEPATITIS C ANTIBODY TEST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (67, 67, 'HEV(METHOD BY ICT)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (68, 68, 'VENEREAL DISEASE RESEARCH L..', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (69, 69, 'TYPHIDOT TEST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (70, 70, 'SEMENT CST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (71, 71, 'DENGUE NS1 ANTIGEN', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (72, 72, 'ASO', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (73, 73, 'CALCIUM - Ionized', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (74, 74, 'C-REACTIVE PROTEIN (CRP)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (75, 75, 'MANTOUX TEST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (76, 76, 'HAV Igm', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (77, 77, 'HEV Igm', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (78, 78, 'Scrub Typhus IgM & IgG', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (79, 79, 'SKIN SCRAPING FOR FUNGAL ELEMENTS BY KOH WET MOUNT', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (80, 80, 'SPUTUM GRAMSTAIN', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (81, 81, 'SPUTUM ROUTINE EXAMINATION', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (82, 82, 'STOOL RE', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (83, 83, 'STOOL REDUCING SUGAR', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (84, 84, 'STOOL OBT', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (85, 85, 'URINALYSIS', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (86, 86, 'URINE SUGAR', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (87, 87, 'URINE FOR PROTEIN', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (88, 88, 'URINE BS/BP', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (89, 89, 'Lactate dehydrogenase (LDH)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (90, 90, 'SPUTUM CST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (91, 91, 'SPECIFIC GRAVITY', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (92, 92, 'URETHRAL DISCHARGE', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (93, 93, 'URINE BENCE JONES PROTEIN', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (94, 94, 'Urine For Pregnancy Test', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (95, 95, 'STN-LATERAL VIEW', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (96, 96, 'TSH (THYROIDE STIMULATING HORMONE)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (97, 97, 'THYROID PROFILE (T3 T4 TSH)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (98, 98, 'FLUID EXAMINATION', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (99, 99, 'FT3 FT4', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (100, 100, 'THROAT SWAB', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (101, 101, 'SPUTUM RE', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (102, 102, 'SPUTUM MELIGNANT CELL', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (103, 103, 'AURAL SWAB CST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (104, 104, 'KOH FOR SKIN CST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (105, 105, 'CST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (106, 106, 'URINE CULTURE SENSITIVITY', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (107, 107, 'MALARIA ANTIGEN (MPDA)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (108, 108, 'BLOOD SMEAR FOR MP', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (109, 109, 'PUS CST-CULTURE AEROBIC & SUSCEPTIBILITY', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (110, 110, 'SEMEN ANALYSIS', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (111, 111, 'Blood Routine Examination', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (112, 112, 'LIVER FUNCTION TEST (LFT)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (113, 113, 'CULTURE & SENSITIVITY', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (114, 114, 'URINE RE/ME', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (115, 115, 'ACTIVATED PARTIAL THROMBOPLASTIN TIME (APTT)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (116, 116, 'URINE MICROALBUMIN / CREATININE RATIO (ACR)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
            (117, 117, 'STOOL OPC', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (118, 118, 'HPLC (Hb Electrophoresis)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (119, 119, 'HbA1c', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (120, 120, 'T4 TSH', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (121, 121, 'WIDAL TEST', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (122, 122, 'HCG (PREGNANCY TEST)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (123, 123, 'ASO(SLIDE)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (124, 124, 'Prothrombin Time and International Normalized Ratio (PT/INR) Studies', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (125, 125, 'FLUID EXAMINATION, ROUTINE, BODY FLUIDS', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (126, 126, 'SERUM ASCITES ALBUMIN GRADIENT (SAAG)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-25 10:01:13', '2024-04-25 10:01:13'),
            (127, 127, 'ADENOSINE DEAMINASE (AD)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (128, 128, 'OVARIAN CANCER MARKER, SERUM (CA 125)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (129, 129, 'CYTOPATHOLOGY REPORT', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (130, 130, 'Anti-ds DNA Antibody', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (131, 131, 'Vitamin D Hydroxy', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (132, 132, 'Packed Cell Volume (PCV)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (133, 133, 'Luteinizing Hormone (LH)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (134, 134, 'Packed Cell Volume (PVC)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (135, 135, 'High-Density Lipoprotein (HDL)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (136, 136, 'Very low density lipoprotein (VLDL)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (137, 137, 'RHEUMATOID ARTHRITIS FACTOR', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (138, 138, 'BS (PP) WITH 50 GRAM GLUCOSE', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (139, 139, 'Urine For Ketone Bodies Test', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (140, 140, 'Urine Bilesalt and Pigment', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (141, 141, 'URINE-UROBILINOGEN', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (142, 142, 'CARDIAC TROPONIN-I', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (143, 143, 'MALARIA ANTIGEN (RAPID)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (144, 144, 'SERUM CPK (TOTAL)', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (145, 145, 'BS (PP) WITH 75 GRAM GLUCOSE', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (146, 146, 'FT3', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (147, 147, 'FT4', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (148, 148, 'EYELASH SWAB', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (149, 149, 'VITAMIN B12', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (150, 150, 'AMH', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (151, 151, 'Prolactin', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (152, 152, 'H PYLORI', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (153, 153, 'USG', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (154, 154, 'HPLC', 1, 0, 0, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05', NULL),
            (155, 155, 'QUADRUPLE MARKAR', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (156, 156, 'Allergy profile', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (157, 157, 'URINE ALBUMIN', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (158, 158, 'ACIDIC FLUID', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (159, 159, 'KFT', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (160, 160, 'SICKLING TEST', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (161, 161, 'SCRENING TEST', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (162, 162, 'SICKLING,SCRENING TEST', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (163, 163, 'SICKLING', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (164, 164, 'URINE ACETONE', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (165, 165, 'HAV IGM RAPID', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (166, 166, 'HEV IGM RAPID', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (167, 167, 'IMMUNOGLOBULIN IgE', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (168, 168, 'Vitamin D3', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (169, 169, 'D-DIMER', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (170, 170, 'DENGUE IgG, IgM ANTIGEN', 1, 0, 0, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (171, 171, 'CPK ( CREATINE KINASE )', 1, 0, 0, 1, '2024-04-22 07:43:33', '2024-04-22 07:43:33', NULL),
            (172, 172, 'DIRECT -LDL CHOLESTEROL', 1, 0, 0, 1, '2024-04-22 09:20:48', '2024-04-22 09:20:48', NULL),
            (173, 173, 'PUS CST- CULTURE AEROBIC & SUSCEPTIBILITY', 1, 0, 0, 1, '2024-04-23 10:16:40', '2024-04-23 10:16:40', NULL),
            (174, 174, 'SERUM AMYLASE', 1, 0, 0, 1, '2024-04-23 10:52:43', '2024-04-23 10:52:43', NULL),
            (175, 175, 'SERUM UREA', 1, 0, 0, 1, '2024-04-23 11:00:18', '2024-04-23 11:00:18', NULL),
            (176, 176, 'URINE- UROBILINOGEN', 1, 0, 0, 1, '2024-04-24 06:48:22', '2024-04-24 06:48:22', NULL),
            (177, 177, 'C- REACTIVE PROTIEN (CRP)', 1, 0, 0, 1, '2024-05-02 08:25:24', '2024-05-02 08:25:24', NULL),
            (178, 178, 'SERUM ASCITES ALBUMIN GRADIENT (SAAG)', 1, 0, 0, 1, '2024-05-03 09:32:36', '2024-05-03 09:32:36', NULL),
            (179, 179, 'URINE BENCE JONES PROTIEN', 1, 0, 0, 1, '2024-05-03 11:35:27', '2024-05-03 11:35:27', NULL),
            (180, 180, 'URINE MICROALBUMIN / CREATININE RATIO (ACR', 1, 0, 0, 1, '2024-05-03 11:46:25', '2024-05-03 11:46:25', NULL),
            (181, 181, 'IMPRESSION', 1, 0, 0, 1, '2024-05-04 08:18:35', '2024-05-04 08:18:35', NULL),
            (182, 182, 'CHLORIDE (Cl-)', 1, 0, 0, 1, '2024-05-04 08:40:51', '2024-05-04 08:40:51', NULL);
        ");

        \DB::statement("INSERT INTO `test_package_group_notes` (`id`, `test_package_id`, `test_package_group_id`, `group_note`, `priority`, `position`, `status`, `is_default`, `created_at`, `updated_at`) VALUES
            (1, 1, 1, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (2, 2, 2, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (3, 3, 3, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (4, 4, 4, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (5, 5, 5, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (6, 6, 6, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (7, 7, 7, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (8, 8, 8, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (9, 9, 9, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (10, 10, 10, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (11, 11, 11, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (12, 12, 12, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (13, 13, 13, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (14, 14, 14, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (15, 15, 15, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (16, 16, 16, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (17, 17, 17, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (18, 18, 18, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (19, 19, 19, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (20, 20, 20, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (21, 21, 21, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (22, 22, 22, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (23, 23, 23, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (24, 24, 24, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (25, 25, 25, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (26, 26, 26, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (27, 27, 27, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (28, 28, 28, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (29, 29, 29, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (30, 30, 30, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (31, 31, 31, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (32, 32, 32, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (33, 33, 33, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (34, 34, 34, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (35, 35, 35, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (36, 36, 36, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (37, 37, 37, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (38, 38, 38, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (39, 39, 39, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (40, 40, 40, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (41, 41, 41, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (42, 42, 42, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (43, 43, 43, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (44, 44, 44, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (45, 45, 45, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (46, 46, 46, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (47, 47, 47, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (48, 48, 48, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (49, 49, 49, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (50, 50, 50, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (51, 51, 51, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (52, 52, 52, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (53, 53, 53, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (54, 54, 54, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (55, 55, 55, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (56, 56, 56, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (57, 57, 57, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (58, 58, 58, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (59, 59, 59, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (60, 60, 60, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (61, 61, 61, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (62, 62, 62, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (63, 63, 63, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (64, 64, 64, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (65, 65, 65, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (66, 66, 66, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (67, 67, 67, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (68, 68, 68, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (69, 69, 69, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (70, 70, 70, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (71, 71, 71, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (72, 72, 72, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (73, 73, 73, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (74, 74, 74, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (75, 75, 75, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (76, 76, 76, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (77, 77, 77, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (78, 78, 78, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (79, 79, 79, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (80, 80, 80, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (81, 81, 81, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (82, 82, 82, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (83, 83, 83, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (84, 84, 84, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (85, 85, 85, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (86, 86, 86, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (87, 87, 87, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (88, 88, 88, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (89, 89, 89, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (90, 90, 90, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (91, 91, 91, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (92, 92, 92, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (93, 93, 93, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (94, 94, 94, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (95, 95, 95, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (96, 96, 96, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (97, 97, 97, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (98, 98, 98, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (99, 99, 99, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (100, 100, 100, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (101, 101, 101, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (102, 102, 102, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (103, 103, 103, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (104, 104, 104, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (105, 105, 105, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (106, 106, 106, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (107, 107, 107, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (108, 108, 108, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (109, 109, 109, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (110, 110, 110, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (111, 111, 111, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (112, 112, 112, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (113, 113, 113, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (114, 114, 114, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (115, 115, 115, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (117, 117, 117, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (118, 118, 118, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (119, 119, 119, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (120, 120, 120, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (121, 121, 121, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (122, 122, 122, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (123, 123, 123, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (124, 124, 124, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (125, 125, 125, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (127, 127, 127, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (128, 128, 128, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (129, 129, 129, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (130, 130, 130, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (131, 131, 131, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (132, 132, 132, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (133, 133, 133, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (134, 134, 134, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (135, 135, 135, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (136, 136, 136, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (137, 137, 137, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (138, 138, 138, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (139, 139, 139, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (140, 140, 140, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (141, 141, 141, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (142, 142, 142, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (143, 143, 143, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (144, 144, 144, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (145, 145, 145, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (146, 146, 146, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (147, 147, 147, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (148, 148, 148, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (149, 149, 149, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (150, 150, 150, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (151, 151, 151, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (152, 152, 152, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (153, 153, 153, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (154, 154, 154, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (155, 155, 155, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (156, 156, 156, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (157, 157, 157, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (158, 158, 158, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (159, 159, 159, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (160, 160, 160, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (161, 161, 161, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (162, 162, 162, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (163, 163, 163, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (164, 164, 164, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (165, 165, 165, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (166, 166, 166, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (167, 167, 167, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (168, 168, 168, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (169, 169, 169, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (170, 170, 170, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (171, 171, 171, NULL, NULL, '1', 1, 1, '2024-04-22 07:43:33', '2024-04-22 07:43:33'),
            (172, 172, 172, NULL, NULL, '1', 1, 1, '2024-04-22 09:20:48', '2024-04-22 09:20:48'),
            (173, 173, 173, NULL, NULL, '1', 1, 1, '2024-04-23 10:16:40', '2024-04-23 10:16:40'),
            (174, 174, 174, NULL, NULL, '1', 1, 1, '2024-04-23 10:52:43', '2024-04-23 10:52:43'),
            (175, 175, 175, NULL, NULL, '1', 1, 1, '2024-04-23 11:00:18', '2024-04-23 11:00:18'),
            (176, 176, 176, NULL, NULL, '1', 1, 1, '2024-04-24 06:48:22', '2024-04-24 06:48:22'),
            (177, 177, 177, NULL, NULL, '1', 1, 1, '2024-05-02 08:25:24', '2024-05-02 08:25:24'),
            (178, 178, 178, NULL, NULL, '1', 1, 1, '2024-05-03 09:32:36', '2024-05-03 09:32:36'),
            (179, 179, 179, NULL, NULL, '1', 1, 1, '2024-05-03 11:35:27', '2024-05-03 11:35:27'),
            (180, 180, 180, NULL, NULL, '1', 1, 1, '2024-05-03 11:46:25', '2024-05-03 11:46:25'),
            (181, 181, 181, NULL, NULL, '1', 1, 1, '2024-05-04 08:18:35', '2024-05-04 08:18:35'),
            (182, 182, 182, NULL, NULL, '1', 1, 1, '2024-05-04 08:40:51', '2024-05-04 08:40:51'),
            (183, 183, 183, NULL, NULL, '1', 1, 1, '2024-05-06 06:25:14', '2024-05-06 06:25:14');
        ");

        
        \DB::statement("INSERT INTO `test_package_notes` (`id`, `test_package_id`, `package_note`, `priority`, `position`, `status`, `is_default`, `created_at`, `updated_at`) VALUES
            (1, 1, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (2, 2, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (3, 3, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (4, 4, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (5, 5, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (6, 6, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (7, 7, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (8, 8, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (9, 9, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (10, 10, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (11, 11, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (12, 12, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (13, 13, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (14, 14, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (15, 15, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (16, 16, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (17, 17, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (18, 18, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (19, 19, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (20, 20, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (21, 21, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (22, 22, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (23, 23, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (24, 24, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (25, 25, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (26, 26, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (27, 27, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (28, 28, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (29, 29, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (30, 30, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (31, 31, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (32, 32, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (33, 33, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (34, 34, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (35, 35, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (36, 36, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (37, 37, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (38, 38, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (39, 39, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (40, 40, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (41, 41, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (42, 42, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (43, 43, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (44, 44, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (45, 45, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (46, 46, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (47, 47, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (48, 48, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (49, 49, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (50, 50, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (51, 51, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (52, 52, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (53, 53, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (54, 54, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (55, 55, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (56, 56, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (57, 57, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (58, 58, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (59, 59, '', 1, '1', 1, 1, '2024-04-20 04:40:04', '2024-04-20 04:40:04'),
            (60, 60, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (61, 61, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (62, 62, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (63, 63, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (64, 64, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (65, 65, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (66, 66, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (67, 67, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (68, 68, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (69, 69, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (70, 70, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (71, 71, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (72, 72, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (73, 73, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (74, 74, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (75, 75, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (76, 76, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (77, 77, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (78, 78, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (79, 79, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (80, 80, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (81, 81, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (82, 82, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (83, 83, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (84, 84, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (85, 85, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (86, 86, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (87, 87, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (88, 88, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (89, 89, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (90, 90, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (91, 91, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (92, 92, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (93, 93, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (94, 94, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (95, 95, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (96, 96, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (97, 97, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (98, 98, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (99, 99, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (100, 100, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (101, 101, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (102, 102, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (103, 103, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (104, 104, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (105, 105, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (106, 106, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (107, 107, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (108, 108, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (109, 109, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (110, 110, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (111, 111, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (112, 112, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (113, 113, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (114, 114, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (115, 115, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (117, 117, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (118, 118, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (119, 119, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (120, 120, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (121, 121, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (122, 122, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (123, 123, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (124, 124, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (125, 125, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (127, 127, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (128, 128, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (129, 129, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (130, 130, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (131, 131, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (132, 132, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (133, 133, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (134, 134, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (135, 135, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (136, 136, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (137, 137, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (138, 138, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (139, 139, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (140, 140, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (141, 141, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (142, 142, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (143, 143, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (144, 144, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (145, 145, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (146, 146, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (147, 147, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (148, 148, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (149, 149, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (150, 150, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (151, 151, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (152, 152, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (153, 153, '', 1, '1', 1, 1, '2024-04-20 04:40:05', '2024-04-20 04:40:05'),
            (154, 154, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (155, 155, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (156, 156, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (157, 157, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (158, 158, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (159, 159, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (160, 160, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (161, 161, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (162, 162, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (163, 163, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (164, 164, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (165, 165, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (166, 166, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (167, 167, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (168, 168, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (169, 169, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (170, 170, '', 1, '1', 1, 1, '2024-04-20 04:40:06', '2024-04-20 04:40:06'),
            (171, 171, NULL, NULL, '1', 1, 1, '2024-04-22 07:43:33', '2024-04-22 07:43:33'),
            (172, 172, NULL, NULL, '1', 1, 1, '2024-04-22 09:20:48', '2024-04-22 09:20:48'),
            (173, 173, NULL, NULL, '1', 1, 1, '2024-04-23 10:16:40', '2024-04-23 10:16:40'),
            (174, 174, NULL, NULL, '1', 1, 1, '2024-04-23 10:52:43', '2024-04-23 10:52:43'),
            (175, 175, NULL, NULL, '1', 1, 1, '2024-04-23 11:00:18', '2024-04-23 11:00:18'),
            (176, 176, NULL, NULL, '1', 1, 1, '2024-04-24 06:48:22', '2024-04-24 06:48:22'),
            (177, 177, NULL, NULL, '1', 1, 1, '2024-05-02 08:25:24', '2024-05-02 08:25:24'),
            (178, 178, NULL, NULL, '1', 1, 1, '2024-05-03 09:32:36', '2024-05-03 09:32:36'),
            (179, 179, NULL, NULL, '1', 1, 1, '2024-05-03 11:35:27', '2024-05-03 11:35:27'),
            (180, 180, NULL, NULL, '1', 1, 1, '2024-05-03 11:46:25', '2024-05-03 11:46:25'),
            (181, 181, NULL, NULL, '1', 1, 1, '2024-05-04 08:18:35', '2024-05-04 08:18:35'),
            (182, 182, NULL, NULL, '1', 1, 1, '2024-05-04 08:40:51', '2024-05-04 08:40:51'),
            (183, 183, NULL, NULL, '1', 1, 1, '2024-05-06 06:25:14', '2024-05-06 06:25:14');
        ");
    }
}
