<?php

namespace Database\Seeders;

use App\Models\TimeFormat;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TimeFormatTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $timeFormat = [
            [
                'time_format_name'       => 'H:i:s',
                'time_format_details'    => 'HH:MM:SS (24-hour format)',
                'is_default'             => 0,
            ],
            [
                'time_format_name'       => 'h:i:s A',
                'time_format_details'    => 'hh:MM:SS AM/PM',
                'is_default'             => 0,
            ],
            [
                'time_format_name'       => 'g:i A',
                'time_format_details'    => 'h:MM AM/PM',
                'is_default'             => 1,
            ],
            [
                'time_format_name'       => 'h:i A',
                'time_format_details'    => 'hh:MM AM/PM',
                'is_default'             => 0,
            ],
            [
                'time_format_name'       => 'H:i',
                'time_format_details'    => 'hh:MM (24-hour format)',
                'is_default'             => 0,
            ],
            [
                'time_format_name'       => 'g:i',
                'time_format_details'    => 'h:MM (12-hour format)',
                'is_default'             => 0,
            ]
        ];

        foreach($timeFormat as $key => $value) {
            TimeFormat::firstOrCreate($value);
        }

    }
}
