<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\UserType;

class UserTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            [
                'name'             => 'User',
                'code'             => 'user',
                'status'           => '1',
            ],
            [
                'name'             => 'Admin',
                'code'             => 'admin',
                'status'           => '1',
            ],
        ];

        foreach ($data as $value) {
            UserType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
