<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\VehicleDocumentType;

class VehicleDocumentTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            [
                'name'               => 'POLLUTION',
                'code'               => 'POLLUTION',
                'validity_in_months' => 12,
                'status'             => 1,
                
            ],
            [
                'name'               => 'INSURANCE',
                'code'               => 'INSURANCE',
                'validity_in_months' => 12,
                'status'             => 1,
                
            ],
            [
                'name'               => 'NATIONAL PERMIT',
                'code'               => 'NATIONAL_PERMIT',
                'validity_in_months' => 12,
                'status'             => 1,
                
            ],
            [
                'name'               => 'REGISTRATION CERTIFICATE',
                'code'               => 'RC',
                'validity_in_months' => 12,
                'status'             => 1,
                
            ]
        ];

        foreach ($data as $value) {
            VehicleDocumentType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
