<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\VoucherSeries;
use App\Models\VoucherType;
use App\Models\VoucherMaster;

class VoucherMasterAndTypeAndSeriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the VoucherSeries table
         */
        // if (\App::environment('local')) {
        //     VoucherSeries::truncate();
        //     VoucherType::truncate();
        //     VoucherMaster::truncate();
        // }

         /*************************Sales Order  *******************/
         $master =
         [
             'voucher_name'     => 'Sales Order',
             'voucher_code'     => 'SALES_ORDER',
             'serial_no_format' => '0',
             'decimal_length'   => '2',
             'status'           => '1',
         ];
         $voucher_master = VoucherMaster::firstOrCreate($master);
         $type = [
             'voucher_master_id' => $voucher_master->id,
             'name'              => 'OPD Booking',
             'code'              => 'OPD_BOOKING',
             'priority'          => ('18'),
             'status'            => '1',
             'voucher_title'     => 'OPD BOOKING',
         ];

         $voucher_type = VoucherType::firstOrCreate($type);

         $series = [
             'voucher_type_id'   => $voucher_type->id,
             'voucher_master_id' => $voucher_master->id,
             'series_name'       => 'OPD BOOKING',
             'length'            => '5',
             'start_from'        => '0',
             'prefix'            => strtoupper('OPD'),
             'postfix'           => '',
             'separator'         => '/',
             'frequency'         => 'Start From Zero (0) Every Year',
         ];
         $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id,'voucher_type_id'=>$voucher_type->id])->first();
         if(empty($seriesCheck))
         {
            $voucher_series = VoucherSeries::firstOrCreate($series);
         }
         


          /*************************Purchase Order  *******************/
          $master =
          [
              'voucher_name'     => 'Purchase Order',
              'voucher_code'     => 'PURCHASE_ORDER',
              'serial_no_format' => '0',
              'decimal_length'   => '2',
              'status'           => '1',
          ];
          $voucher_master = VoucherMaster::firstOrCreate($master);

         /*************************Projects  *******************/
         $master =
         [
             'voucher_name'     => 'Projects',
             'voucher_code'     => 'PROJECTS',
             'serial_no_format' => '0',
             'decimal_length'   => '2',
             'status'           => '1',
         ];
         $voucher_master = VoucherMaster::firstOrCreate($master);
         $type = [
             'voucher_master_id' => $voucher_master->id,
             'name'              => 'PROJECTS',
             'code'              => 'PROJECTS',
             'priority'          => ('18'),
             'status'            => '1',
             'voucher_title'     => 'PROJECT',
         ];

         $voucher_type = VoucherType::firstOrCreate($type);

         $series = [
             'voucher_type_id'   => null,
             'voucher_master_id' => $voucher_master->id,
             'series_name'       => 'PROJECTS',
             'length'            => '5',
             'start_from'        => '0',
             'prefix'            => strtoupper('PRO'),
             'postfix'           => '',
             'separator'         => '/',
             'frequency'         => 'Start From Zero (0) Every Year',
         ];

         $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
         if(empty($seriesCheck)){
            $voucher_series = VoucherSeries::firstOrCreate($series);
         }
       

         

        # Sales voucher master and voucher types
        $master = [
            'voucher_name'     => 'Sales',
            'voucher_code'     => 'SALES',
            'serial_no_format' => '0',
            'decimal_length'   => '2',
            'status'           => '1',
        ];

        $voucher_master = VoucherMaster::firstOrCreate($master);

        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'Pathology',
            'code'              => 'PATHOLOGY',
            'priority'          => '1',
            'status'            => '1',
            'is_default'        => '1',
            'voucher_title'     => 'Tax Invoice And Bill of Supply',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => null,
            'series_name'       => 'Pathology',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'LAB',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];

        $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        {
         $voucher_series = VoucherSeries::firstOrCreate($series);
        }

        $series = [
            'voucher_type_id'   => null,
            'voucher_master_id' => $voucher_master->id,
            'series_name'       => 'Pathology',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'LAB',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];

        // $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
        // if(empty($seriesCheck))
        // {
            $voucher_series = VoucherSeries::firstOrCreate($series);
        // }
        

        $series = [
            'voucher_type_id'   => null,
            'voucher_master_id' => $voucher_master->id,
            'series_name'       => 'IPD',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'IPD',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];
        // $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
        // if(empty($seriesCheck))
        // {
            $voucher_series = VoucherSeries::firstOrCreate($series);
        // }

        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'IPD Admission',
            'code'              => 'IPD_ADMISSION',
            'priority'          => '2',
            'status'            => '1',
            'is_default'        => '0',
            'voucher_title'     => 'IPD Admission',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => null,
            'series_name'       => 'IPD',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'IPD',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];

        // $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
        // if(empty($seriesCheck))
        // {
            $voucher_series = VoucherSeries::firstOrCreate($series);
        // }

        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'IPD Invoice',
            'code'              => 'IPD_INVOICE',
            'priority'          => '3',
            'status'            => '1',
            'is_default'        => '0',
            'voucher_title'     => 'IPD Invoice And Bill of Supply',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => null,
            'series_name'       => 'IPI',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'IPI',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];

        $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        {
            $voucher_series = VoucherSeries::firstOrCreate($series);
        }

        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'OPD',
            'code'              => 'OPD',
            'priority'          => '4',
            'status'            => '1',
            'is_default'        => '0',
            'voucher_title'     => 'OPD Invoice And Bill of Supply',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => null,
            'series_name'       => 'OPD',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'OPD',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];

        $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        {
        $voucher_series = VoucherSeries::firstOrCreate($series);
        }

        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'Sales',
            'code'              => 'SALES',
            'priority'          => '5',
            'status'            => '1',
            'is_default'        => '0',
            'voucher_title'     => 'Sales',
        ];
        $voucher_type = VoucherType::where(['code'=>'SALES'])->first();
        if(empty($voucher_type))
        {
            $voucher_type = VoucherType::firstOrCreate($type);
        }
       

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => null,
            'series_name'       => 'Sales',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'INV',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];

        $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        {
        $voucher_series = VoucherSeries::firstOrCreate($series);
        }

        $series = [
            'voucher_type_id'   => null,
            'voucher_master_id' => $voucher_master->id,
            'series_name'       => 'Sales',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'INV',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];

        $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
        if(empty($seriesCheck))
        {
         $voucher_series = VoucherSeries::firstOrCreate($series);
        }


        # rest of voucher master and voucher types
        $master = [
            [
                'voucher_name'     => 'Contra Voucher',
                'voucher_code'     => 'CONTRA',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'CV'
            ],
            [
                'voucher_name'     => 'Receipt Voucher',
                'voucher_code'     => 'RECEIPT',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'MR'
            ],
            [
                'voucher_name'     => 'Journal Voucher',
                'voucher_code'     => 'JOURNAL',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'JV'
            ],
            [
                'voucher_name'     => 'Credit Note Voucher',
                'voucher_code'     => 'CREDIT_NOTE',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'CN'
            ],
            [
                'voucher_name'     => 'Purchase Voucher',
                'voucher_code'     => 'PURCHASE',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'PIV'
            ],
            [
                'voucher_name'     => 'Debit Note Voucher',
                'voucher_code'     => 'DEBIT_NOTE',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'DN'
            ],
            [
                'voucher_name'     => 'Payment Voucher',
                'voucher_code'     => 'PAYMENT',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'PS'
            ],
            [
                'voucher_name'     => 'Inventory Vouchers',
                'voucher_code'     => 'INVENTORY',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'IN'
            ],
            [
                'voucher_name'     => 'Delivery Note',
                'voucher_code'     => 'DELIVERY_NOTE',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'DNV'
            ],
            [
                'voucher_name'     => 'Physical Stock',
                'voucher_code'     => 'PHYSICAL_STOCK',
                'serial_no_format' => '0',
                'decimal_length'   => '2',
                'status'           => '1',
                'prefix'           => 'PS'
            ],
        ];

        foreach($master as $key => $value) {

            $master = [
                'voucher_name'     => $value['voucher_name'],
                'voucher_code'     => $value['voucher_code'],
                'serial_no_format' => $value['serial_no_format'],
                'status'           => $value['status'],
                'decimal_length'   => $value['decimal_length'],
                'tax_calculation'  => 'EXCLUSIVE',
            ];
            $voucher_master = VoucherMaster::firstOrCreate($master);

            $type = [
                'voucher_master_id' => $voucher_master->id,
                'name'              => $value['voucher_name'],
                'code'              => $value['voucher_code'],
                'priority'          => ($key + 4),
                'status'            => '1',
                'voucher_title'     => /*($value['voucher_code'] == 'PAYMENT' ? $value['voucher_code'] . ' INVOICE' :*/ $value['voucher_code'] . ' VOUCHER'/*)*/,
            ];

            $voucher_type = VoucherType::firstOrCreate($type);

            $series = [
                'voucher_type_id'   => $voucher_type->id,
                'voucher_master_id' => null,
                'series_name'       => $value['voucher_name'],
                'length'            => '5',
                'start_from'        => '0',
                'prefix'            => $value['prefix'],
                'postfix'           => '',
                'separator'         => '/',
                'frequency'         => 'Start From Zero (0) Every Year',
            ];

            $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
            if(empty($seriesCheck))
            {
            $voucher_series = VoucherSeries::firstOrCreate($series);
            }

            $series = [
                'voucher_type_id'   => null,
                'voucher_master_id' => $voucher_master->id,
                'series_name'       => $value['voucher_name'],
                'length'            => '5',
                'start_from'        => '0',
                'prefix'            => $value['prefix'],
                'postfix'           => '',
                'separator'         => '/',
                'frequency'         => 'Start From Zero (0) Every Year',
            ];
            $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
            if(empty($seriesCheck))
            {
            $voucher_series = VoucherSeries::firstOrCreate($series);
            }
        }


        /*************************Book Issue  *******************/
        $voucher_master = VoucherMaster::where('voucher_code','INVENTORY')->first();

        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'Material issue',
            'code'              => 'MATERAIL_ISSUE',
            'status'            => '1',
            'voucher_title'     =>  'MATERAIL_ISSUE',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => null,
            'voucher_master_id' => $voucher_type->id,
            'series_name'       => 'Material issue',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'MI',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];
        $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        {
        $voucher_series = VoucherSeries::firstOrCreate($series);
        }


        $voucher_master = VoucherMaster::where('voucher_code','INVENTORY')->first();

        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'Material Return',
            'code'              => 'MATERAIL_RETURN',
            'status'            => '1',
            'voucher_title'     =>'MATERAIL_RETURN',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => null,
            'voucher_master_id' => $voucher_type->id,
            'series_name'       => 'Material Return',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => 'MRT',
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];
        $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        {
        $voucher_series = VoucherSeries::firstOrCreate($series);
        }


         /*************************Book ISBN  *******************/
        $master=
        [
            'voucher_name'     => 'Book',
            'voucher_code'     => 'BOOK',
            'serial_no_format' => '0',
            'decimal_length'   => '2',
            'status'           => '1',
        ];
        $voucher_master = VoucherMaster::firstOrCreate($master);
        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'ISBN',
            'code'              => 'ISBN',
            'priority'          => ($key + 4),
            'status'            => '1',
            'voucher_title'     => 'ISBN',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => $voucher_master->id,
            'series_name'       => 'ISBN',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => strtoupper('ISBN'),
            'postfix'           => '',
            'separator'         => '/',
            'frequency'         => 'Follow Last Year',
        ];

        $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id,'voucher_type_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        {
        $voucher_series = VoucherSeries::firstOrCreate($series);
        }

        /*************************Sale Invoice Batch  *******************/
         $master =
         [
             'voucher_name'     => 'Sale Invoice Batch',
             'voucher_code'     => 'SALES_INVOICE_BATCH',
             'serial_no_format' => '0',
             'decimal_length'   => '2',
             'status'           => '1',
         ];
         $voucher_master = VoucherMaster::firstOrCreate($master);
         $type = [
             'voucher_master_id' => $voucher_master->id,
             'name'              => 'Sale Invoice Batch',
             'code'              => 'SALES_INVOICE_BATCH',
             'priority'          => ('19'),
             'status'            => '1',
             'voucher_title'     => 'PROJECT',
         ];

         $voucher_type = VoucherType::firstOrCreate($type);

         $series = [
             'voucher_type_id'   => null,
             'voucher_master_id' => $voucher_master->id,
             'series_name'       => 'Sale Invoice Batch',
             'length'            => '5',
             'start_from'        => '0',
             'prefix'            => strtoupper('SLN'),
             'postfix'           => '',
             'separator'         => '/',
             'frequency'         => 'Start From Zero (0) Every Year',
         ];

         $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
         if(empty($seriesCheck))
         {
         $voucher_series = VoucherSeries::firstOrCreate($series);
         }


        /*************************Transaction Master  *******************/
          $master =
          [
              'voucher_name'     => 'Transaction',
              'voucher_code'     => 'TRANSACTION',
              'serial_no_format' => 'TR',
              'decimal_length'   => '2',
              'status'           => '1',
          ];
          $voucher_master = VoucherMaster::firstOrCreate($master);
          $type = [
              'voucher_master_id' => $voucher_master->id,
              'name'              => 'Transactions',
              'code'              => 'TRANSACTIONS',
              'priority'          => ('20'),
              'status'            => '1',
              'voucher_title'     => 'ALL TRANSACTIONS',
          ];

          $voucher_type = VoucherType::firstOrCreate($type);

          $series = [
              'voucher_type_id'   => null,
              'voucher_master_id' => $voucher_master->id,
              'series_name'       => 'Transaction',
              'length'            => '5',
              'start_from'        => '0',
              'prefix'            => strtoupper('TRN'),
              'postfix'           => '',
              'separator'         => '',
              'frequency'         => 'Start From Zero (0) Every Year',
          ];
          $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
          if(empty($seriesCheck))
          {  
            $voucher_series = VoucherSeries::firstOrCreate($series);
          }

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => null,
            'series_name'       => 'Transaction',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => strtoupper('TRN'),
            'postfix'           => '',
            'separator'         => '',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];
        $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        { 
            $voucher_series = VoucherSeries::firstOrCreate($series);
        }

         /*************************Sale Return Master  *******************/
         $master =
         [
             'voucher_name'     => 'Sale Return',
             'voucher_code'     => 'SALE_RETURN',
             'serial_no_format' => 'SRT',
             'decimal_length'   => '2',
             'status'           => '1',
         ];
         $voucher_master = VoucherMaster::firstOrCreate($master);
         $type = [
             'voucher_master_id' => $voucher_master->id,
             'name'              => 'Sale Return',
             'code'              => 'SALE_RETURN',
             'priority'          => ('20'),
             'status'            => '1',
             'voucher_title'     => 'SALE RETURN',
         ];

         $voucher_type = VoucherType::firstOrCreate($type);

         $series = [
             'voucher_type_id'   => null,
             'voucher_master_id' => $voucher_master->id,
             'series_name'       => 'Sale Return',
             'length'            => '5',
             'start_from'        => '0',
             'prefix'            => strtoupper('SRT'),
             'postfix'           => '',
             'separator'         => '',
             'frequency'         => 'Start From Zero (0) Every Year',
         ];
         $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
         if(empty($seriesCheck))
         { 
            $voucher_series = VoucherSeries::firstOrCreate($series);
         }

       $series = [
           'voucher_type_id'   => $voucher_type->id,
           'voucher_master_id' => null,
           'series_name'       => 'Sale Return',
           'length'            => '5',
           'start_from'        => '0',
           'prefix'            => strtoupper('SRT'),
           'postfix'           => '',
           'separator'         => '',
           'frequency'         => 'Start From Zero (0) Every Year',
       ];
       $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
         if(empty($seriesCheck))
         { 
       $voucher_series = VoucherSeries::firstOrCreate($series);
         }


        /*************************Purchase Return Master  *******************/
         $master =
         [
             'voucher_name'     => 'Purchase Return',
             'voucher_code'     => 'Purchase_RETURN',
             'serial_no_format' => 'PRT',
             'decimal_length'   => '2',
             'status'           => '1',
         ];
         $voucher_master = VoucherMaster::firstOrCreate($master);
         $type = [
             'voucher_master_id' => $voucher_master->id,
             'name'              => 'Purchase Return',
             'code'              => 'PURCHASE_RETURN',
             'priority'          => ('20'),
             'status'            => '1',
             'voucher_title'     => 'PURCHASE RETURN',
         ];

         $voucher_type = VoucherType::firstOrCreate($type);

         $series = [
             'voucher_type_id'   => null,
             'voucher_master_id' => $voucher_master->id,
             'series_name'       => 'Purchase Return',
             'length'            => '5',
             'start_from'        => '0',
             'prefix'            => strtoupper('PRT'),
             'postfix'           => '',
             'separator'         => '',
             'frequency'         => 'Start From Zero (0) Every Year',
         ];
         $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
         if(empty($seriesCheck))
         { 
         $voucher_series = VoucherSeries::firstOrCreate($series);
         }

       $series = [
           'voucher_type_id'   => $voucher_type->id,
           'voucher_master_id' => null,
           'series_name'       => 'Purchase Return',
           'length'            => '5',
           'start_from'        => '0',
           'prefix'            => strtoupper('PRT'),
           'postfix'           => '',
           'separator'         => '',
           'frequency'         => 'Start From Zero (0) Every Year',
       ];
       $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
       if(empty($seriesCheck))
       { 
       $voucher_series = VoucherSeries::firstOrCreate($series);
       }


       
        /*************************Stock In Master  *******************/
        $master =
        [
            'voucher_name'     => 'Stock In',
            'voucher_code'     => 'STOCK_IN',
            'serial_no_format' => '0',
            'decimal_length'   => '2',
            'status'           => '1',
        ];
        $voucher_master = VoucherMaster::firstOrCreate($master);
        $type = [
            'voucher_master_id' => $voucher_master->id,
            'name'              => 'Stock In',
            'code'              => 'STOCK_IN',
            'priority'          => ('20'),
            'status'            => '1',
            'voucher_title'     => 'STOCK IN',
        ];

        $voucher_type = VoucherType::firstOrCreate($type);

        $series = [
            'voucher_type_id'   => null,
            'voucher_master_id' => $voucher_master->id,
            'series_name'       => 'Stock In',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => strtoupper('STI'),
            'postfix'           => '',
            'separator'         => '',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];
        $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
        if(empty($seriesCheck))
        { 
        $voucher_series = VoucherSeries::firstOrCreate($series);
        }

      $series = [
          'voucher_type_id'   => $voucher_type->id,
          'voucher_master_id' => null,
          'series_name'       => 'Stock In',
          'length'            => '5',
          'start_from'        => '0',
          'prefix'            => strtoupper('STI'),
          'postfix'           => '',
          'separator'         => '',
          'frequency'         => 'Start From Zero (0) Every Year',
      ];
      $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
      if(empty($seriesCheck))
      { 
      $voucher_series = VoucherSeries::firstOrCreate($series);
      }


       /*************************Stock OUT Master  *******************/
       $master =
       [
           'voucher_name'     => 'Stock Out',
           'voucher_code'     => 'STOCK_OUT',
           'serial_no_format' => '0',
           'decimal_length'   => '2',
           'status'           => '1',
       ];
       $voucher_master = VoucherMaster::firstOrCreate($master);
       $type = [
           'voucher_master_id' => $voucher_master->id,
           'name'              => 'Stock Out',
           'code'              => 'STOCK_OUT',
           'priority'          => ('20'),
           'status'            => '1',
           'voucher_title'     => 'STOCK OUT',
       ];

       $voucher_type = VoucherType::firstOrCreate($type);

       $series = [
           'voucher_type_id'   => null,
           'voucher_master_id' => $voucher_master->id,
           'series_name'       => 'Stock OUT',
           'length'            => '5',
           'start_from'        => '0',
           'prefix'            => strtoupper('STO'),
           'postfix'           => '',
           'separator'         => '',
           'frequency'         => 'Start From Zero (0) Every Year',
       ];
       $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
       if(empty($seriesCheck))
       { 
       $voucher_series = VoucherSeries::firstOrCreate($series);
       }

     $series = [
         'voucher_type_id'   => $voucher_type->id,
         'voucher_master_id' => null,
         'series_name'       => 'Stock Out',
         'length'            => '5',
         'start_from'        => '0',
         'prefix'            => strtoupper('STO'),
         'postfix'           => '',
         'separator'         => '',
         'frequency'         => 'Start From Zero (0) Every Year',
     ];
     $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
     if(empty($seriesCheck))
     { 
     $voucher_series = VoucherSeries::firstOrCreate($series);
     }

    /************ Course Voucher Master***************/

      $master =
      [
          'voucher_name'     => 'Course Voucher',
          'voucher_code'     => 'COURSE_VOUCHER',
          'serial_no_format' => '0',
          'decimal_length'   => '2',
          'status'           => '1',
      ];
      $voucher_master = VoucherMaster::firstOrCreate($master);
      $type = [
          'voucher_master_id' => $voucher_master->id,
          'name'              => 'Course Voucher',
          'code'              => 'COURSE_VOUCHER',
          'priority'          => ('20'),
          'status'            => '1',
          'voucher_title'     => 'Course Voucher',
      ];

      $voucher_type = VoucherType::firstOrCreate($type);

      $series = [
          'voucher_type_id'   => null,
          'voucher_master_id' => $voucher_master->id,
          'series_name'       => 'Course Voucher',
          'length'            => '5',
          'start_from'        => '0',
          'prefix'            => strtoupper('CRV'),
          'postfix'           => '',
          'separator'         => '',
          'frequency'         => 'Start From Zero (0) Every Year',
      ];
      $seriesCheck = VoucherSeries::where(['voucher_master_id'=>$voucher_master->id])->first();
      if(empty($seriesCheck))
      { 
      $voucher_series = VoucherSeries::firstOrCreate($series);
      }

        $series = [
            'voucher_type_id'   => $voucher_type->id,
            'voucher_master_id' => null,
            'series_name'       => 'Course Voucher',
            'length'            => '5',
            'start_from'        => '0',
            'prefix'            => strtoupper('CRV'),
            'postfix'           => '',
            'separator'         => '',
            'frequency'         => 'Start From Zero (0) Every Year',
        ];
        $seriesCheck = VoucherSeries::where(['voucher_type_id'=>$voucher_type->id])->first();
        if(empty($seriesCheck))
        { 
            VoucherSeries::firstOrCreate($series);
        }
    }
}
