<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\VoucherTrackStatus;

class VoucherTrackStatusesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the VoucherSeries table
         */
        // if (\App::environment('local')) {
        //     VoucherTrackStatus::truncate();
        // }

        $statuses = [
            [
				'module_code'       => 'SALES',
				'voucher_code'      => 'SALES',
				'voucher_type_code' => 'PATHOLOGY',
				'status_name'       => 'Sample Collected',
				'status_code'       => 'SAMPLE_COLLECTED',
				'detail'            => '',
				'priority'          => '1'
            ], [
				'module_code'       => 'SALES',
				'voucher_code'      => 'SALES',
				'voucher_type_code' => 'PATHOLOGY',
				'status_name'       => 'Result Updated',
				'status_code'       => 'RESULT_UPDATED',
				'detail'            => '',
				'priority'          => '2'
            ], [
				'module_code'       => 'SALES',
				'voucher_code'      => 'SALES',
				'voucher_type_code' => 'PATHOLOGY',
				'status_name'       => 'Result Recheck',
				'status_code'       => 'RESULT_RECHECK',
				'detail'            => '',
				'priority'          => '3'
            ], [
				'module_code'       => 'SALES',
				'voucher_code'      => 'SALES',
				'voucher_type_code' => 'PATHOLOGY',
				'status_name'       => 'Result Reviewed',
				'status_code'       => 'RESULT_REVIEWED',
				'detail'            => '',
				'priority'          => '4'
            ]
        ]; 

        foreach ($statuses as $value) {
            $existingRecord = VoucherTrackStatus::where('status_code', $value['status_code'])->exists();

            if (!$existingRecord) {
                VoucherTrackStatus::create($value);
            }
        }
    }
}
