function calculate_cbc()
{
	// ======================== CALCULATION RCB =======================
	var CBC_HEMOGLOBIN = $('.CBC-HEMOGLOBIN').val();
	var CBC_RBC = $('.CBC-RBC').val();
	var CBC_PCV = $('.CBC-PCV').val();
	var CBC_NEUTROPHILS = $('.CBC-NEUTROPHILS').val();
	var CBC_LYMPHOCYTES = $('.CBC-LYMPHOCYTES').val();
	var CBC_EOSINOPHILS = $('.CBC-EOSINOPHILS').val();
	var CBC_MONOCYTES = $('.CBC-MONOCYTES').val();
	var CBC_PLATELET_COUNT = $('.CBC-PLATELET-COUNT').val();
	var CBC_MPV = $('.CBC-MPV').val();
	var CBC_LEUKOCYTE_COUNT = $('.CBC-LEUKOCYTE-COUNT').val();
	var CBC_BASOPHILS = $('.CBC-BASOPHILS').val();

	CBC_HEMOGLOBIN = ($.isNumeric(CBC_HEMOGLOBIN) == false) ? extractNumbers(CBC_HEMOGLOBIN) : CBC_HEMOGLOBIN;
	CBC_RBC = ($.isNumeric(CBC_RBC) == false) ? extractNumbers(CBC_RBC) : CBC_RBC;
	CBC_PCV = ($.isNumeric(CBC_PCV) == false) ? extractNumbers(CBC_PCV) : CBC_PCV;
	CBC_MPV = ($.isNumeric(CBC_MPV) == false) ? extractNumbers(CBC_MPV) : CBC_MPV;
	CBC_NEUTROPHILS = ($.isNumeric(CBC_NEUTROPHILS) == false) ? extractNumbers(CBC_NEUTROPHILS) : CBC_NEUTROPHILS;
	CBC_LYMPHOCYTES = ($.isNumeric(CBC_LYMPHOCYTES) == false) ? extractNumbers(CBC_LYMPHOCYTES) : CBC_LYMPHOCYTES;
	CBC_EOSINOPHILS = ($.isNumeric(CBC_EOSINOPHILS) == false) ? extractNumbers(CBC_EOSINOPHILS) : CBC_EOSINOPHILS;
	CBC_MONOCYTES = ($.isNumeric(CBC_MONOCYTES) == false) ? extractNumbers(CBC_MONOCYTES) : CBC_MONOCYTES;
	CBC_PLATELET_COUNT = ($.isNumeric(CBC_PLATELET_COUNT) == false) ? extractNumbers(CBC_PLATELET_COUNT) : CBC_PLATELET_COUNT;
	CBC_LEUKOCYTE_COUNT = ($.isNumeric(CBC_LEUKOCYTE_COUNT) == false) ? extractNumbers(CBC_LEUKOCYTE_COUNT) : CBC_LEUKOCYTE_COUNT;
	CBC_BASOPHILS = ($.isNumeric(CBC_BASOPHILS) == false) ? extractNumbers(CBC_BASOPHILS) : CBC_BASOPHILS;

	// ======================== CALCULATION MCV =======================
	var CBC_MCV = (CBC_PCV * 10) / (CBC_RBC);
	CBC_MCV = ($.isNumeric(CBC_MCV) == false || CBC_MCV == 0) ? '' : CBC_MCV.toFixed(2);

	var CBC_MCH = (CBC_HEMOGLOBIN * 10) / (CBC_RBC);
	CBC_MCH = ($.isNumeric(CBC_MCH) == false || CBC_MCH == 0) ? '' : CBC_MCH.toFixed(2);

	var CBC_MCHC = (CBC_HEMOGLOBIN * 100) / (CBC_PCV);
	CBC_MCHC = ($.isNumeric(CBC_MCHC) == false || CBC_MCHC == 0) ? '' : CBC_MCHC.toFixed(2);

	$('.CBC-MCV').val(CBC_MCV).change();
	$('.CBC-MCH').val(CBC_MCH).change();
	$('.CBC-MCHC').val(CBC_MCHC).change();

// ======================== CALCULATION BASOPHILS =======================
	var VALUE_BASOPHILS = (+CBC_NEUTROPHILS) + (+CBC_LYMPHOCYTES) + (+CBC_MONOCYTES) + (+CBC_EOSINOPHILS);
	if (VALUE_BASOPHILS > 100) {
		CBC_BASOPHILS = VALUE_BASOPHILS - 100;
		$('.CBC-BASOPHILS').val('-' + CBC_BASOPHILS.toFixed(2)).change();
	}else{
		CBC_BASOPHILS = 100 - VALUE_BASOPHILS;
		$('.CBC-BASOPHILS').val(CBC_BASOPHILS.toFixed(2)).change();
	}

	// ======================== CALCULATION PCT =======================
	var CBC_PCT = (CBC_PLATELET_COUNT * CBC_MPV)/10000;
	$('.CBC-PCT').val(CBC_PCT.toFixed(2)).change();

	// ======================== CALCULATION Absolute Basophils count =======================
	var CBC_BASOPHILS_COUNT = (CBC_BASOPHILS / CBC_LEUKOCYTE_COUNT)*100;
	$('.CBC-BASOPHILS-COUNT').val(CBC_BASOPHILS_COUNT.toFixed(2)).change();

	// ======================== CALCULATION Absolute Neutrophil count =======================
	var CBC_BASOPHILS_COUNT = (CBC_BASOPHILS / CBC_LEUKOCYTE_COUNT)*100;
	$('.CBC-BASOPHILS-COUNT').val(CBC_BASOPHILS_COUNT.toFixed(2)).change();

	// ======================== CALCULATION Absolute Neutrophil count =======================
	var CBC_NEUTROPHIL_COUNT = (CBC_LEUKOCYTE_COUNT * CBC_NEUTROPHILS + CBC_BASOPHILS) / 100;
	$('.CBC-NEUTROPHIL-COUNT').val(CBC_NEUTROPHIL_COUNT.toFixed(2)).change();

	// ======================== CALCULATION Absoulte Lymphocyte Count =======================
	var CBC_LYMPHOCYTE_COUNT = (CBC_LEUKOCYTE_COUNT * CBC_LYMPHOCYTES + CBC_BASOPHILS)/100;
	$('.CBC-LYMPHOCYTE-COUNT').val(CBC_LYMPHOCYTE_COUNT.toFixed(2)).change();

	// ======================== CALCULATION Absoulate Esonophils count =======================
	var CBC_ESONOPHILS_COUNT = (CBC_LEUKOCYTE_COUNT * CBC_EOSINOPHILS)/100;
	$('.CBC-ESONOPHILS-COUNT').val(CBC_ESONOPHILS_COUNT.toFixed(2)).change();

	// ======================== CALCULATION Absolte Monocyte count =======================
	var CBC_MONOCYTE_COUNT = (CBC_LEUKOCYTE_COUNT * CBC_MONOCYTES) / 100;
	$('.CBC-MONOCYTE-COUNT').val(CBC_MONOCYTE_COUNT.toFixed(2)).change();
}
function calculate_HBA1C_val()
{
	var HBA1C_HEAMOGLOBIN = $('.HBA1C-HEAMOGLOBIN').val();

	HBA1C_HEAMOGLOBIN = ($.isNumeric(HBA1C_HEAMOGLOBIN) == false) ? 0 : HBA1C_HEAMOGLOBIN;

	var HBA1C_ABG = (28.7 * HBA1C_HEAMOGLOBIN) - 46.7;

	$('.HBA1C-ABG').val(HBA1C_ABG.toFixed(2)).change();
}

function calculate_inr_val()
{
	var INR_PROTHROMBIN = $('.INR-PROTHROMBIN').val();
	var INR_NORMAL = $('.INR-NORMAL').val();

	INR_PROTHROMBIN = ($.isNumeric(INR_PROTHROMBIN) == false) ? 1 : INR_PROTHROMBIN;
	INR_NORMAL = ($.isNumeric(INR_NORMAL) == false) ? 1 : INR_NORMAL;

	var INR_TEST_COUNT = (INR_PROTHROMBIN) / (INR_NORMAL);

	$('.INR-TEST-COUNT').val(INR_TEST_COUNT.toFixed(2)).change();
	$('.INR-VALUE').val(INR_TEST_COUNT.toFixed(2)).change();
}

function calculate_lipidprofile()
{
	var LIPID_SCHOLESTEROL = $('.LIPID-SCHOLESTEROL').val();
	var LIPID_TRIGLYCERIDES = $('.LIPID-TRIGLYCERIDES').val();
	var LIPID_HDLCHOLESTEROL = $('.LIPID-HDLCHOLESTEROL').val();
//--------------------------------------------------------------
	var LIPID_VLDL = (LIPID_TRIGLYCERIDES / 5);
	LIPID_VLDL = ($.isNumeric(LIPID_VLDL) == false || LIPID_VLDL == 0) ? '' : LIPID_VLDL.toFixed(2);
	$('.LIPID-VLDL').val(LIPID_VLDL).change();

	var LIPID_DIRECTLDLCHOLESTEROL=(LIPID_SCHOLESTEROL-LIPID_HDLCHOLESTEROL)-(LIPID_TRIGLYCERIDES/5);
	LIPID_DIRECTLDLCHOLESTEROL = ($.isNumeric(LIPID_DIRECTLDLCHOLESTEROL) == false || LIPID_DIRECTLDLCHOLESTEROL == 0) ? '' : LIPID_DIRECTLDLCHOLESTEROL.toFixed(2);
	$('.LIPID-DIRECTLDLCHOLESTEROL').val(LIPID_DIRECTLDLCHOLESTEROL).change();
//---------------------------------------------------------------
	var LIPID_CHOLHDLRATIO=(LIPID_SCHOLESTEROL/LIPID_HDLCHOLESTEROL);

	LIPID_CHOLHDLRATIO = ($.isNumeric(LIPID_CHOLHDLRATIO) == false || LIPID_CHOLHDLRATIO == 0) ? '' : LIPID_CHOLHDLRATIO.toFixed(2);

	$('.LIPID-CHOLHDLRATIO').val(LIPID_CHOLHDLRATIO).change();
//----------------------------------------------------------
	var LIPID_LDLHDLRATIO=(LIPID_DIRECTLDLCHOLESTEROL/LIPID_HDLCHOLESTEROL);
	LIPID_LDLHDLRATIO = ($.isNumeric(LIPID_LDLHDLRATIO) == false || LIPID_LDLHDLRATIO == 0) ? '' : LIPID_LDLHDLRATIO.toFixed(2);
	$('.LIPID-LDLHDLRATIO').val(LIPID_LDLHDLRATIO).change();
//----------------------------------------------------------
	var LIPID_TOTALLIPID=(+LIPID_SCHOLESTEROL)+(+LIPID_TRIGLYCERIDES)+(+LIPID_HDLCHOLESTEROL)+(+LIPID_VLDL)+(+LIPID_DIRECTLDLCHOLESTEROL)+(+LIPID_CHOLHDLRATIO)+(+LIPID_LDLHDLRATIO)+200;

	LIPID_TOTALLIPID = ($.isNumeric(LIPID_TOTALLIPID) == false || LIPID_TOTALLIPID == 0) ? '' : LIPID_TOTALLIPID.toFixed(2);
	$('.LIPID-TOTALLIPID').val(LIPID_TOTALLIPID).change();
//----------------------------------------------------------
	}
function calculate_blood_urea()
{
		var BLOOD_UREA = $('.BLOOD-UREA').val();
		var UREA_NITROGEN=(BLOOD_UREA/2.1428);
		UREA_NITROGEN = ($.isNumeric(UREA_NITROGEN) == false || UREA_NITROGEN == 0) ? '' : UREA_NITROGEN.toFixed(2);
	$('.UREA-NITROGEN').val(UREA_NITROGEN).change();

}


function calculate_bilirubin_total()
{

	var BILIRUBIN_TOTAL = $('.BILIRUBIN-TOTAL').val();
	var BILIRUBIN_DIRECT = $('.BILIRUBIN-DIRECT').val();
	var BILIRUBIN_INDIRECT=(+BILIRUBIN_TOTAL)-(+BILIRUBIN_DIRECT);
	BILIRUBIN_INDIRECT = ($.isNumeric(BILIRUBIN_INDIRECT) == false || BILIRUBIN_INDIRECT == 0) ? '' : BILIRUBIN_INDIRECT.toFixed(2);
	$('.BILIRUBIN-INDIRECT').val(BILIRUBIN_INDIRECT).change();

}

function calculate_urea_bun()
{

	var BLOOD_UREA = $('.BLOOD-UREA').val();
	var UREA_BUN=(+BLOOD_UREA)*(.467);
	UREA_BUN = ($.isNumeric(UREA_BUN) == false || UREA_BUN == 0) ? '' : UREA_BUN.toFixed(2);
	$('.UREA-BUN').val(UREA_BUN).change();

}

function calculate_lft()
{

	var TOTAL_PROTEIN  = $('.TOTAL-PROTEIN').val();
	var TOTAL_BILIRUBIN  = $('.TOTAL-BILIRUBIN').val();
	var CONJUGATED_BILIRUBIN= $('.CONJUGATED-BILIRUBIN').val();
	var lft_ALBUMIN  = $('.ALBUMIN').val();

	var UNCONJUGATED_BILIRUBIN= (+TOTAL_BILIRUBIN)-(+CONJUGATED_BILIRUBIN);
		UNCONJUGATED_BILIRUBIN = ($.isNumeric(UNCONJUGATED_BILIRUBIN) == false || UNCONJUGATED_BILIRUBIN == 0) ? '' : UNCONJUGATED_BILIRUBIN.toFixed(2);
	$('.UNCONJUGATED-BILIRUBIN').val(UNCONJUGATED_BILIRUBIN).change();


	var GLOBULIN=(+TOTAL_PROTEIN)-(+lft_ALBUMIN);
	GLOBULIN = ($.isNumeric(GLOBULIN) == false || GLOBULIN == 0) ? '' : GLOBULIN.toFixed(2);
	$('.GLOBULIN').val(GLOBULIN).change();
	var AG_RATIO=(+lft_ALBUMIN)/(+GLOBULIN);
	AG_RATIO = ($.isNumeric(AG_RATIO) == false || AG_RATIO == 0) ? '' : AG_RATIO.toFixed(2);
	$('.AG-RATIO').val(AG_RATIO).change();

}

function calculate_kft()
{

	var KFT_UREA  = $('.KFT-UREA').val();

	var KFT_UREABUN=(+KFT_UREA)*(+0.467);
	KFT_UREABUN = ($.isNumeric(KFT_UREABUN) == false || KFT_UREABUN == 0) ? '' : KFT_UREABUN.toFixed(2);
	$('.KFT-UREABUN').val(KFT_UREABUN).change();

}
function calculate_ptime()
{

	var PTIME_PATIENT  = $('.PTIMEPATIENT').val();
	var PTIME_CONTROL  = $('.PTIMECONTROL').val();

	var P_TIMERATIO=(+PTIME_PATIENT)/(PTIME_CONTROL);
	var P_TIMEINR=(+PTIME_CONTROL)/(PTIME_PATIENT);
	var P_TIMEISI=(+P_TIMERATIO);

	P_TIMERATIO = ($.isNumeric(P_TIMERATIO) == false || P_TIMERATIO == 0) ? '' : P_TIMERATIO.toFixed(2);
	$('.PTIMERATIO').val(P_TIMERATIO).change();

	P_TIMEINR = ($.isNumeric(P_TIMEINR) == false || P_TIMEINR == 0) ? '' : P_TIMEINR.toFixed(2);
	$('.PTIMEINR').val(P_TIMEINR).change();

	P_TIMEISI = ($.isNumeric(P_TIMEISI) == false || P_TIMEISI == 0) ? '' : P_TIMEISI.toFixed(2);
	$('.PTIMEISI').val(P_TIMEISI).change();

}

function extractNumbers(input) {
    var numbersOnly = input.replace(/\D/g, ''); // \D matches any non-digit character
    return numbersOnly;
}