@extends('layouts.app')
@section('title', 'Abdm Api Calls Import')
@section('pages')
    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }

        .card {
            margin-bottom: 0rem;
        }

        .form-control {
            height: 33px !important;
        }
    </style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> Abdm Api Calls Import</div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="79"
                            data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                    <li class="breadcrumb-item" aria-current="page">Abdm Api Calls Import</li>
                    <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Abdm Api Calls Import</li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <!-- main -->
    <div class="card style_table shadow-none radius-5 min-height">

        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">
                <div class="col-lg-6 col-md-6"> <!-- Adjust the column widths as needed -->
                    <h5 class="mb-0">Upload Abdm Api Calls<small> From Excel File</small></h5>
                </div>
                <div class="col-lg-6 col-md-6 text-end"> <!-- Adjust the column widths as needed -->
                    <div class="btn-group">
                        <a href="{{route('vehicle-register.index')}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                    </div>
                    <div class="btn-group">
                        <a href="{{ asset('uploads/upload-formats/Abdm_Api_Calls_Sample.xlsx') }}" style="float: right" class="btn btn-success">Download Sample File</a>
                    </div>
                </div>
            </div>
        </div>

        <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>
    <!-- end main -->

    <div class="row auto">
        <div class="col-xl-12 mx-auto">
            <div class=" shadow-none radius-5 min-height">
                <div class="">
                    <div class="">
                        <form class="row g-3 auto-width form" action="{{ route('abdm-api-calls-import.store') }}"
                            enctype="multipart/form-data" method="POST">
                            @csrf
                            @method('post')

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body g-3 row">

                                        <hr class="mb-0">
                                        <div class="col-md-3"></div>

                                        <div class="col-md-6">
                                            <img src="{!! asset('admin/images/upload.png') !!}" style="margin-left: 157px;" width="150" height="150" class="my-3 mt-5">
                                            <br>
                                        </div>
                                        <div class="col-md-3"></div>
                                        <div class="col-md-3"></div>
                                        <div class="col-md-6">
                                            <label for="users">Upload Excel File <span
                                                    class="text-danger"><b>*</b></span>
                                            </label>
                                            <input type="file" name="excel" class="form-control exl_file" id="exl_file">
                                            <span class="text-danger error_import_excel" style="display:none;">This field is required.</span>
                                        </div>
                                        <div class="col-md-3"></div>
                                    </div>
                                    <div class="col-12 d-flex justify-content-center mb-3">
                                        <a style="width: 40%;" class="btn btn-primary import_button"> <i class="bi bi-upload "></i> Upload File </a>
                                    </div>
                                    <div class="col-12 justify-content-center mb-3">
                                        <div style="" class="accordion-item">
                                            <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                                                Guidelines For Abdm Api Calls:
                                              </button>
                                            </h2>
                                            <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                                              <div class="accordion-body">
                                                <strong>Note:</strong><br> <p>Duplicate records will not be saved.<br>If a record already exists, only that record will be skipped.</p>
                                                <strong>1. Request Name (required):</strong><br> <p>Enter the Request Name</p>
                                                <strong>2. Production Base Url   (required):</strong><br> <p>Enter the Production Base Url.</p>
                                                <strong>3. Sandbox Base Url (required):</strong><br> <p>Enter the  Sandbox Base Url.</p>
                                                <strong>4. Sub Url (required):</strong><br> <p>Enter the Sub Url.</p>
                                                <strong>5. Request Type (required):</strong><br> <p>Enter the  Request Type.</p>
                                              </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection

@section('js')

<script>
    $(document).ready(function() {
        $(document).on('click', '.import_button', function(e) {
            e.preventDefault();

            // Store the original button text and icon
            var originalButtonText = $('.import_button').html();
            var originalIconClass = $('.import_button i').attr('class');

            if ($('.exl_file').val() == '') {
                toastr.error("Excel file field is required.");
                return;
            }

            var file = $('.exl_file').val();
            var error = 0;
            var ext = file.match(/\.(.+)$/)[1];

            if (ext != 'xls' && ext != 'xlsx') {
                toastr.error('File must be type of xls & xlsx.');
                $('.exl_file').val('');
                error = 1;
            }

            const size = $(".exl_file")[0].files[0].size;

            if (size > 5e+6) {
                toastr.error('File must be less than 5 MB');
                $('.exl_file').val('');
                error = 1;
            }

            // Show loading icon or change button state
            updateButtonState('Please Wait We Are Uploading Your Data...', 'fa fa-spinner fa-spin');

            var formData = new FormData();
            formData.append('file', $('.exl_file')[0].files[0]);

            if (error == 0) {
                $.ajax({
                    url: "{{ route('abdm-api-calls-import.store')}}",
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (data) {
                        // Update button state back to normal
                        updateButtonState(originalButtonText, originalIconClass);

                        if (data.success === true) {
                            $('[name="excel"]').val('');
                            $('.btn-close').click();
                            toastr.success(data.message);

                            // Redirect to the products-import.create route
                            window.location.href = "{{ route('abdm-api-calls-import.create') }}";
                        } else {
                            $('[name="excel"]').val('');
                            toastr.error(data.message);
                        }
                    },
                    error: function () {
                        // Update button state back to normal in case of an error
                        updateButtonState(originalButtonText, originalIconClass);
                    },
                    complete: function () {
                        // You can add any code that needs to be executed after the AJAX request completes here
                    }
                });
            }
            error = 1;
        });

        // Function to update button state dynamically
        function updateButtonState(text, iconClass) {
            $('.import_button').html(text);
        }
    });
</script>



@endsection
