<form class="row g-3 auto-width address" action="{{ route('account-addresses.update', $address->id)}}" method="post" enctype='multipart/form-data'>
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    @method('patch')
    <div class="col-md-12">
        <label class="form-label">Address Type <span class="text-danger"><b>*</b></span></label>
        <select class="single-select form-control" id="address_type_id" name="address_type_id" required>
            @foreach($address_types as $list)
            <option value="{{ $list->id}}" {!! ($list->is_default === '1' ? 'selected' : '') !!}>{{$list->name}}</option>
            @endforeach
        </select>
        <span class="text-danger error_address_type_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="address_line1" class="form-label">Address line 1 <span class="text-danger"><b>*</b></span></label>
        <textarea class="form-textarea" name="address_line1" rows="1">{!! $address->address_line1 !!}</textarea>
        <span class="text-danger error_address_line1" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="address_line2" class="form-label">Address line 2</label>
        <textarea class="form-textarea" name="address_line2" rows="1">{!! $address->address_line2 !!}</textarea>
    </div>
    <div class="col-md-4">
        <label class="form-label">Country <span class="text-danger"><b>*</b></span></label>
        <select class="single-select form-control" id="country" name="country_id" onchange="changecountry()" required>
            <option value=" "> Select Country</option>

            @foreach($country as $list)
                <option value="{{ $list->id}}" {!! $address->country_id == $list->id ? 'selected' : '' !!}>{{$list->name}}</option>
            @endforeach
        </select>
        <span class="text-danger error_country_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label class="form-label">State/Province <span class="text-danger"><b>*</b></span></label>
        <input type="hidden" value="@if(isset($address->state_id)){{$address->state_id}}@endif" id="stateid">
        <select class="single-select form-control" name="state_id" id="states">
        </select>
        <span class="text-danger error_state_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-4">
        <label class="form-label">City <span class="text-danger"><b>*</b></span></label>
        <input type="hidden" value="@if(isset($address->city_id)){{$address->city_id}}@endif" id="cityid">
        <select class="single-select form-control" name="city_id" id="cities">
        </select>
        <span class="text-danger error_city_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="district_name" class="form-label">District name</label>
        <input type="text" name="district_name" class="form-control" value="{!! $address->district_name !!}">
        <span class="text-danger error_district_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="taluka_name" class="form-label">Taluka name</label>
        <input type="text" name="taluka_name" class="form-control" value="{!! $address->taluka_name !!}">
        <span class="text-danger error_taluka_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="post_code" class="form-label">PIN/ZIP Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" name="post_code" class="form-control" value="{!! $address->post_code !!}">
        <span class="text-danger error_post_code" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="number" name="priority" class="form-control" value="{!! $address->priority !!}">
        <span class="text-danger error_priority" style="display: none;">This field is required.</span>
    </div>
</form>