@extends('layouts.app')
@section('title','Addresses')
@section('pages')
<link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Addresses</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                
                <li class="breadcrumb-item active" aria-current="page"> Address Details</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body g-3">
                            <div class="table-responsive">
                                <div class="d-flex justify-content-between">
                                    <h5 class="mb-0">Address Details</h5>
                                </div>
                                <hr class="mb-2">
                                <table class="table table-bordered align-middle">
                                  <tr>
                                      <td>Address line 1</td>
                                      <td>{{$account_address->address_line1}}</td>
                                  </tr>
                                  <tr>
                                      <td>Address line 2 </td>
                                      <td>{{$account_address->address_line2}}</td>
                                  </tr>
                                  <tr>
                                      <td>District name</td>
                                      <td>{{$account_address->district_name}}</td>
                                  </tr>
                                  <tr>
                                      <td>Taluka name</td>
                                      <td>{{$account_address->taluka_name}}</td>
                                  </tr>
                                  <tr>
                                      <td>Post code</td>
                                      <td>{{$account_address->post_code}}</td>
                                  </tr>
                                  <tr>
                                      <td>Country</td>
                                      <td>{{$account_address->country}}</td>
                                  </tr>
                                  <tr>
                                      <td>State/Province</td>
                                      <td>{{$account_address->state}}</td>
                                  </tr>
                                  <tr>
                                      <td>City</td>
                                      <td>{{$account_address->city}}</td>
                                  </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection