<form class="row g-3 auto-width attachment edit" action="{{ route('account-attachments.update', $attachment->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <label for="title" class="form-label">Title <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="title" name="title" aria-describedby="inputGroupPrepend" required value="{{$attachment->title}}">
        <span class="text-danger error_title" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="file" class="form-label">Attachment</label>
        <input type="file" class="form-control" id="file" name="file" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_file" style="display: none;">This field is required.</span>
    </div>
    @if(file_exists(public_path('uploads/account-attachments/'.$attachment->file_name)))
    <div class="col-md-6 d-flex align-items-end">
        <a class="btn btn-info" href="{!! asset('uploads/account-attachments/'.$attachment->file_name) !!}" download="true">Previous Attachment</a>
    </div>
    @endif
    <div class="col-md-12">
        <label for="details" class="form-label">Details </label>
        <textarea class="form-textarea" rows="1" name="details">{{$attachment->details}}</textarea>
        <span class="text-danger error_details" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="expiry_date" class="form-label">Expiry date</label>
        <input type="text" class="form-control datepicker" id="expiry_date" name="expiry_date" aria-describedby="inputGroupPrepend" required value="{{ date('d-m-Y', strtotime($attachment->expiry_date)) }}">
        <span class="text-danger error_expiry_date" style="display: none;">This field is required.</span>
    </div>
</form>