 @php $auth_format = \Session::get('company_data')['date_format'] ?? ''; @endphp
 <div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0">Account Attachments</h5>
        @if(in_array('account-attachments-create', $authRolePermissions))
        <button type="button" class="btn btn-primary" id="createAttachment"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Title</th>
                <th>Valid Upto</th>
                <th>Attachment</th>
                <th class="thbutton">Status</th>
                @if(in_array('account-attachments-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('account-attachments-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{1 + $key}}</td>
                        <td style="white-space: initial;"><strong>{!! $list->title !!}</strong><br>{!! $list->details !!}</td>
                        <td>{{ date($auth_format, strtotime($list->expiry_date)) }}</td>
                        <td>
                            @if($list->file_url != '')
                                <a class="btn btn-info" href="{{ route('bucket_file_download', ['filename' => $list->file_url]) }}">Download</a>

                            @endif
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeAccountStatus attachments" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('account-attachments.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('account-attachments-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $list->id }}" class="btn btn-warning editAttachment" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('account-attachments-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('account-attachments.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData attachments" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="7" >No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
</div>

