<form class="row g-3 auto-width attachment" action="{{ route('account-attachments.update', $attachment->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-6">
        <label for="file" class="form-label">Attachment <span class="text-danger"><b>*</b></span></label>
        <input type="file" class="form-control" id="file" name="file" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_file" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6 d-flex align-items-end">
        @if(file_exists(public_path('uploads/account-attachments/'.$attachment->file_name)))
            <a class="btn btn-info" href="{!! asset('uploads/account-attachments/'.$attachment->file_name) !!}" download="true">Previous Attachment</a>
        @endif
    </div>
    <div class="col-md-6">
        <label for="title" class="form-label">Title <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="title" name="title" aria-describedby="inputGroupPrepend" required value="{{$attachment->title}}">
        <span class="text-danger error_title" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="details" class="form-label">Details </label>
        <textarea class="form-textarea" rows="1" name="details">{{$attachment->details}}</textarea>
        <span class="text-danger error_details" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="activation_date" class="form-label">Activation date</label>
        <input type="date" class="form-control" id="activation_date" name="activation_date" aria-describedby="inputGroupPrepend" required value="{{$attachment->activation_date}}">
        <span class="text-danger error_activation_date" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="renewal_date" class="form-label">Renewal date</label>
        <input type="date" class="form-control" id="renewal_date" name="renewal_date" aria-describedby="inputGroupPrepend" required value="{{$attachment->renewal_date}}">
        <span class="text-danger error_renewal_date" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="expiry_date" class="form-label">Expiry date</label>
        <input type="date" class="form-control" id="expiry_date" name="expiry_date" aria-describedby="inputGroupPrepend" required value="{{$attachment->expiry_date}}">
        <span class="text-danger error_expiry_date" style="display: none;">This field is required.</span>
    </div>
</form>