<form class="row g-3 auto-width license" action="{{ route('account-licenses.store')}}" method="post" enctype='multipart/form-data'>
    @csrf
    <div class="col-md-12">
        <div>
            <label for="license_type_id" class="form-label">License type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="license_type_id">
                @foreach($types as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_license_types" type="button"> + </button>
            </div>
        </div> 
    </div>
    <span class="text-danger error_license_type_id" style="display: none;">This field is required.</span>
    <input type="hidden" name="account_id" data-id="{!! $id !!}">
    <div class="col-md-12">
        <label for="license_number" class="form-label">License/Document Number <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="license_number" name="license_number" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_license_number" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="valid_from" class="form-label">Valid from </span></label>
        <input type="text" class="form-control" id="valid_from" name="valid_from" autocomplete="off">
        <span class="text-danger error_valid_from" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="valid_upto" class="form-label">Valid upto </span></label>
        <input type="text" class="form-control" id="valid_upto" name="valid_upto" autocomplete="off">
        <span class="text-danger error_valid_upto" style="display: none;">This field is required.</span>
    </div>
</form>