<form class="row g-3 auto-width license" action="{{ route('account-licenses.update', $license->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <div>
            <label for="license_type_id" class="form-label">License type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="license_type_id">
                @foreach($types as $list)
                <option value="{{ $list->id }}" {{$license->license_type_id == $list->id ? 'selected' : ''}}>{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_license_type_id" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="license_number" class="form-label">License number <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="license_number" name="license_number" aria-describedby="inputGroupPrepend" required value="{{$license->license_number}}">
        <span class="text-danger error_license_number" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="valid_from" class="form-label">Valid from </label>
        <input type="text" class="form-control datepicker" id="valid_from" name="valid_from" value="{{$license->valid_from}}">
        <span class="text-danger error_valid_from" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="valid_upto" class="form-label">Valid upto </label>
        <input type="text" class="form-control datepicker" id="valid_upto" name="valid_upto" value="{{$license->valid_upto}}">
        <span class="text-danger error_valid_upto" style="display: none;">This field is required.</span>
    </div>
</form>
