 <div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0">Account Licenses <i class="bi bi-info-circle-fill text-info show-help-support" data-id="25" data-bs-toggle="modal" data-bs-target="#commonModal"></i></h5>
        @if(in_array('license-create', $authRolePermissions))
            <button type="button" class="btn btn-primary" id="createLicenses"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>License Type</th>
                <th>License No</th>
                <th>Validity Period</th>
                <th class="thbutton">Status</th>
                @if(in_array('license-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('license-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{1 + $key}}</td>
                        <td>
                            <strong>{!! $list->license_type !!}</strong><br>
                        </td>
                        <td>

                            {!! $list->license_number !!}
                        </td>
                        <td>
                            {{ formatedDate($list->valid_from) }} - {{ formatedDate($list->valid_upto) }}
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeAccountStatus licenses" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('account-licenses.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('license-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $list->id }}" class="btn btn-warning editLicenses" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('license-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('account-licenses.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData licenses" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="6" >No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
</div>

