 <div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0">Account Payments</h5>
        @if(in_array('account-payment-create', $authRolePermissions))
        <button type="button" class="btn btn-primary" id="createPayment"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Payment Mode</th>
                <th class="thbutton">Priority</th>
                <th class="thbutton">Default</th>
                <th class="thbutton">Status</th>
                @if(in_array('account-payment-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('account-payment-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{1 + $key}}</td>
                        <td>{!! $list->mode !!}</td>
                        <td class="text-center">{!! $list->priority !!}</td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeAccountStatus payments" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('account-payments.changedefault')}}" data-id="{{$list->id}}" data-status="{{$list->is_default=='0' ? '1' : '0'}}" {{ $list->is_default=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeAccountStatus payments" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('account-payments.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('account-payment-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $list->id }}" class="btn btn-warning editPayment" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('account-payment-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('account-payments.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData payments" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="7" >No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
</div>

