@extends('layouts.app')
@section('title','All Transactions')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>
<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> All Transactions
      </div>
      <div class="col-md-6">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb justify-content-md-end mb-0">
            <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="40" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
            <li class="breadcrumb-item" aria-current="page">Accounts</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> All Transactions</li>
          </ol>
        </nav>
      </div>
    </div>
    <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
      <div class="card-header py-3">
        @include('layouts.partials.nav-menu')
        <div class="row gx-2">
          <div class="col-lg-3 col-md-3 col-8">
              <div class="position-relative">
                  <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                  <input class="form-control ps-5" type="search" id="search" placeholder="Search" autofocus>
              </div>
          </div>

          <!-- <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
          </div> -->

          <div class="col-lg-2 col-md-2 col-4 dataTables_length">
            <div class="position-relative">
                <div class="position-absolute translate-middle-y search-icon px-3"><i class="bi bi-calendar2-check-fill"></i></div>
                <input type="text" class="form-control datepicker ps-5" id="start_date" autocomplete="off" placeholder="Start From Date">
            </div>
          </div>

          <div class="col-lg-2 col-md-2 col-4 dataTables_length">
            <div class="position-relative">
                <div class="position-absolute translate-middle-y search-icon px-3"><i class="bi bi-calendar2-check-fill"></i></div>
                <input type="text" class="form-control datepicker ps-5" id="end_date" autocomplete="off" placeholder="End From Date">
            </div>
          </div>

          <div class="col-lg-2 col-md-2 col-4 dataTables_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select" id="voucher_type" aria-controls="example">
              <option value="">- Voucher Type -</option>
              @foreach($voucher_types as $key => $value)
                <option value="{!! $value->code !!}">{!! $value->name !!}</option>
              @endforeach
            </select>
          </div>

          <div class="col-lg-3 col-md-3">
            <div class="ms-auto float-end">
              <div class="btn-group">
              <ul class="navbar-nav align-items-center">
                  <li class="nav-item dropdown dropdown-small me-0">
                      <a class="dropdown-toggle dropdown-toggle-nocaret btn btn-secondary" href="#"
                          data-bs-toggle="dropdown">
                          <div class="">
                             <i class="bi bi-receipt"></i> Statement
                          </div>
                      </a>
                      <ul class="dropdown-menu dropdown-menu-end bg-secondary text-white px-0">
                          <li>
                              <a href="{{ route('transaction-statement') }}" class="py-2 dropdown-item text-white hover-dark"><i class="bi bi-receipt"></i>All Transactions Statement  </a>
                          </li>
                          <li>
                              <a href="{!! route('cash-flow-statement.index') !!}" class="py-2 dropdown-item text-white hover-dark"><i class="bi bi-receipt"></i> Cash Flow Statement</a>
                          </li>
                          <li>
                              <a href="{!! route('consolidate-statement.index') !!}" class="py-2 dropdown-item text-white hover-dark"><i class="bi bi-receipt"></i> Consolidate Statement</a>
                          </li>
                      </ul>
                  </li>
              </ul>
            </div>

            </div>
          </div>
        </div>
      </div>

    <div class="card-body" id="tables">

      @include('account-transactions.table')

      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>
@endsection

@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
  <script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }


    $(document).ready(function(){
      $( function() {
          $('.datepicker').datepicker({
            format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
            autoclose: true,
        })
        .on('changeDate', function (ev) {
            $(this).datepicker('hide');

            var page  = $('[name="hidden_page"]').val();
            var query = $('#search').val()?$('#search').val():'';
            var sort_type = $('#hidden_sort_type').val();
            var column_name = $('.sorting').val()?$('.sorting').val():'';
            fetch_data(page,sort_type,column_name, query)
        })

      });

      function fetch_data(page, sort_type, sort_by, query){
        var start_date   = $('#start_date').val();
        var end_date     = $('#end_date').val();
        var voucher_type = $('#voucher_type').val();

        $.ajax({
          url:"?page="+page+"&query="+query+"&start_date="+start_date+"&end_date="+end_date+"&voucher_type="+voucher_type+"&sort_by="+sort_by,
          success:function(data){
            $('#tables').html('');
            $('#tables').html(data);
            $(document).ready(function(){$.switcher();});
          }
        })
      }

       /******** searching ********/
    $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();

        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
        fetch_data(page, sort_type, column_name, query);
    }, 700));


      $('body').on('change', '#voucher_type', function(){
        var query = $('#search').val();
        var page = 1;

        if (query.length < 2 && query.length != 0) {
          return;
        }
        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        fetch_data(page, sort_type, column_name, query);
      });
      $('body').on('change', '.sorting', function(){

        var column_name = $(this).val();
        console.log('perpage',column_name);
        var order_type = $(this).data('sorting_type');
        var reverse_order = '';
        var page = 1?1:(this).attr('href').split('page=')[1];
        var query = $('#search').val()?$('#search').val():'';
        fetch_data(page, reverse_order, column_name, query);
        });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page  = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type = $('#hidden_sort_type').val();
        var query = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');

        fetch_data(page, sort_type, column_name, query);
      });
    });
  </script>
@endsection
