<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Transactions No.</th>
                <th>Transactions Date</th>
                <th>Voucher No</th>
                <th>Voucher Type</th>
                <th>Receipt No</th>
                <th>Account Name</th>
                <th style="text-align: right;">Debit Amount</th>
                <th style="text-align: right;">Credit Amount</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{!! $data->firstItem() + $key !!}</td> 
                        <td>
                            {!! $list->transactions_no ?? '' !!}
                        </td>
                        <td>
                            {!! formatedDate($list->transaction_date)  !!}, 
                            {!! formatedTime($list->created_at) !!}
                        </td>
                        <td>
                            
                            @if($list->module_code === 'CONTRA')
                                {!! $list->contraVoucher->voucher_no ?? '' !!}
                            @elseif($list->module_code === 'PAYMENT_VOUCHER')
                                {!! $list->paymentVoucher->receipt_no ?? '' !!}
                            @elseif($list->module_code === 'JOURNAL_VOUCHER')
                                {!! $list->journalVoucher->voucher_no ?? '' !!}
                            @elseif($list->module_code === 'Receipt_VOUCHER')
                                {!! $list->receiptVoucher->receipt_no ?? '' !!}
                            @elseif($list->module_code === 'PATHOLOGY_LAB_BILLING' || $list->module_code === 'Pathology' || $list->module_code === 'PATHOLOGY')
                                @if($list->voucher_type=='RECEIPT')
                                    {!! $list->receiptVoucher->salesVoucher->voucher_type_invoice_no ?? '' !!}
                                @else
                                    {!! $list->pathologyVoucher->voucher_type_invoice_no ?? '' !!}
                                @endif
                            @elseif($list->module_code === 'OPD_BOOKING')
                                @if($list->voucher_type=='RECEIPT')
                                    {!! $list->receiptVoucher->opdBooking->booking_no ?? '' !!}  
                                @else
                                    {!! $list->OpdVoucher->booking_no ?? '' !!}
                                @endif
                                
                            @elseif($list->module_code === 'IPD_ADMISSION' || $list->module_code === 'IPD_INVOICE')
                                @if($list->voucher_type=='RECEIPT')
                                    {!! $list->receiptVoucher->salesVoucher->voucher_type_invoice_no ?? '' !!}  
                                @else
                                   {!! $list->IPDAdmissionVoucher->voucher_type_invoice_no ?? '' !!}
                                @endif

                                
                            @elseif($list->module_code === 'SALES')
                                @if($list->voucher_type=='RECEIPT')
                                    {!! $list->receiptVoucher->salesVoucher->voucher_type_invoice_no ?? '' !!}
                                @else
                                    {!! $list->SalesVoucher->voucher_type_invoice_no ?? '' !!}
                                @endif
                            @elseif($list->module_code === 'PURCHASE')
                            @if($list->voucher_type=='PAYMENT')
                                {!! $list->paymentVoucher->PurchaseVoucher->voucher_type_invoice_no ?? '' !!}
                            @else
                                {!! $list->PurchaseVoucher->voucher_type_invoice_no ?? '' !!}
                            @endif
                            
                            @endif
                        </td>
                        
                        <td>
                            {!! $list->VoucherType->name ?? '' !!}<br>
                        </td>
                        <td>
                            @if($list->voucher_type=='RECEIPT' && $list->voucher_id!='' && isset($list->receiptVoucher->id))
                            <a href="{{route('receipt-voucher.show',$list->receiptVoucher->id)}}"><strong>{!! $list->receiptVoucher->receipt_no??'' !!}</strong></a>
                            @endif
                        </td>
                       
                        @if($list->transaction_type=='DEBIT')
                        <td>{!! $list->Account->name ?? '' !!} A/C {!! $list->transaction_type !!}</td>
                        @else
                        <td style="text-align: right;">To {!! $list->Account->name ?? '' !!} A/C {!! $list->transaction_type !!}</td>
                        @endif

                        <td style="text-align: right; font-size: 14px;">
                        @if($list->transaction_type=='DEBIT')
                            {!! isset($list->amount) && abs($list->amount) > 0 ? convertDecimelPoint(abs($list->amount)) : 0 !!}<br>
                        @endif
                        </td>
                        <td style="text-align: right; font-size: 14px;">
                        @if($list->transaction_type=='CREDIT')
                        {!! isset($list->amount) && abs($list->amount) > 0 ? convertDecimelPoint(abs($list->amount)) : 0 !!}<br>
                        @endif
                        </td>

                   {{-- @foreach($list->DebitTransaction as $credit_key => $debit_value)
                        @if($credit_key != 0)
                            <tr>
                        @endif
                            <td style="text-align: left;">{!! $debit_value->Account->name ?? '' !!} A/C Debit</td>
                            <td style="text-align: right; font-size: 14px;">
                                {!! isset($debit_value->amount) && $debit_value->amount ? convertDecimelPoint(abs($debit_value->amount)) : 0 !!}
                            </td>
                            <td></td>
                        </tr>
                        @if($credit_key == 0)
                            </tr>
                        @endif
                    @endforeach
                    @foreach($list->CreditTransaction as $credit_key => $credit_value)
                        <tr>
                            <td style="text-align: right;">To {!! $credit_value->Account->name ?? '' !!} A/C</td>
                            <td></td>
                            <td style="text-align: right; font-size: 14px;">
                                {!! isset($credit_value->amount) && $credit_value->amount ? convertDecimelPoint($credit_value->amount) : 0 !!}
                            </td>
                        </tr>
                    @endforeach--}}
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="5">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $data->onEachSide(0)->render('accounting-types.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style="    top: 11px;
    left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>

