<form class="row g-3 auto-width" action="{{ route('accounting-groups.update', $subtype->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
    <div class="col-md-12">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required value="{{$subtype->name}}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="accounting_type_id" class="form-label">Accounting Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="accounting_type_id">
            @foreach($types as $list)
            <option value="{{ $list->id }}" {{$subtype->accounting_type_id == $list->id ? 'selected' : '' }}>{{ $list->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_chart_of_account_type_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="code" class="form-label">Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="code" name="code" aria-describedby="inputGroupPrepend" required value="{{$subtype->code}}">
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="prefix" class="form-label">Prefix <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="prefix" name="prefix" aria-describedby="inputGroupPrepend" required value="{{$subtype->prefix}}">
        <span class="text-danger error_prefix" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority </label>
        <input type="number" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend"
            required value="{{$subtype->priority}}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
</form>
