<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Serial No</th>
                <th>Voucher no</th>
                <th>Date</th>
                <th>Description</th>
                <th>Company</th>
                <th>Financial Year</th>
                <th class="thbutton">Print</th>
                <th class="thbutton">Approval</th>
                <th class="thbutton">Status</th>
                @if(in_array('journal-voucher-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('journal-voucher-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$key+1}}</td>
                        <td><a href="{{route('journal-voucher.show',$list->id)}}"><strong>{{$list->voucher_no}}</strong>
                        <td>{{ formatedDate(@$list->transaction_date) }}<br>{{ formatedTime($list->receipt_time) }}</td>
                        <td style="white-space: break-spaces;">{{$list->description}} <br> <strong>{{$list->reference}}</strong></td>
                        <td style="white-space: break-spaces;">{{$list->name}}</td>
                        <td>{{$list->financial_year_name}}</td>
                        <td align="center">
                            <a href="{{route('print-journal-voucher',$list->id)}}" class="btn btn-success" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Print">
                                <i class="bi bi-printer text-white"></i>
                            </a>
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('journal-voucher.change.approval.status')}}" data-id="{{$list->id}}" data-status="{{$list->voucher_approval_status=='0' ? '1' : '0'}}" {{ $list->voucher_approval_status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('journal-voucher.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->voucher_status=='0' ? '1' : '0'}}" {{ $list->voucher_status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('journal-voucher-edit', $authRolePermissions))
                        <td align="center">
                            @if($list->voucher_id=='')
                            <a href="{{route('journal-voucher.edit',$list->id)}}" class="btn btn-warning edit" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                            @endif
                        </td>
                        @endif
                        @if(in_array('journal-voucher-delete', $authRolePermissions))
                        <td align="center">
                            @if($list->voucher_id=='')
                            <a data-url="{{route('journal-voucher-delete')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                            @endif
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="9">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $data->onEachSide(0)->render('accounting-journals.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>

