@extends('layouts.app')
@section('title','Lab Billings')
@section('pages')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Lab Billings</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                
                <li class="breadcrumb-item active" aria-current="page">Add New Lab Billing</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-primary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="row g-3 auto-width">
                    <div class="col-md-12 cart_products">
                    </div>
                    <div class="col-md-3 mt-0">
                        <div class="card border shadow-none" style="margin-bottom:0.8rem;">
                           <div class="card-body py-2">
                            <div class="d-flex gap-3">
                              <div class="icon">
                              <div class="icon-box small_icon bg-light-primary border-0">
                                <i class="bi bi-person-hearts text-primary"></i>
                              </div>
                              <h6 class="text-center mt-1 mb-0"><small>Patient</small></h6>
                              </div>
                              <div class="info">
                                 <p class="mb-0">{!! $patients['name'] ?? '' !!}</p>
                                 <p class="mb-0">{!! isset($patients['phone_no']) && $patients['phone_no'] != '' ? ' ' . $patients['phone_no'] : '' !!}</p>
                                 <p class="mb-0">{!! isset($patients['gender']) && $patients['gender'] != '' ? ' ' . $patients['gender'] : '' !!}{!! isset($patients['date_of_birth']) && $patients['date_of_birth'] != '' ? ', ' . $patients['date_of_birth'] : '' !!}</p>
                              </div>
                           </div>
                           </div>
                         </div>
                    </div>
                    <div class="col-md-3 mt-0">
                        <div class="card border shadow-none" style="margin-bottom:0.8rem;">
                           <div class="card-body py-2">
                            <div class="d-flex gap-3">
                              <div class="icon">
                              <div class="icon-box small_icon bg-light-primary border-0">
                                <i class="bi bi-person text-primary"></i>
                              </div>
                              <h6 class="text-center mt-1 mb-0"><small>Doctor</small></h6>
                              </div>
                              <div class="info">
                                 <p class="mb-0">{!! $doctors['name'] ?? '' !!}</p>
                                  <p class="mb-0">{!! isset($doctors['phone_no']) && $doctors['phone_no'] != '' ? ' ' . $doctors['phone_no'] : '' !!}</p>
                                 <p class="mb-0">{!! isset($doctors['gender']) && $doctors['gender'] != '' ? ' ' . $doctors['gender'] : '' !!}{!! isset($doctors['date_of_birth']) && $doctors['date_of_birth'] != '' ? ', ' . $doctors['date_of_birth'] : '' !!}</p>
                              </div>
                           </div>
                           </div>
                         </div>
                    </div>
                    @if(!empty($refferal_lab))
                    <div class="col-md-3 mt-0">
                        <div class="card border shadow-none" style="margin-bottom:0.8rem;">
                           <div class="card-body py-2">
                            <div class="d-flex gap-3">
                              <div class="icon">
                              <div class="icon-box small_icon bg-light-primary border-0">
                                <i class="bi bi-hospital text-primary"></i>
                              </div>
                              <h6 class="text-center mt-1 mb-0"><small>Center</small></h6>
                              </div>
                              <div class="info">
                                 <p class="mb-0">{!! $refferal_lab['name'] ?? '' !!}</p>
                                 <p class="mb-0">{!! isset($refferal_lab['phone_no']) && $refferal_lab['phone_no'] != '' ? ' ' . $refferal_lab['phone_no'] : '' !!}</p>
                                 <p class="mb-0">{!! isset($refferal_lab['gender']) && $refferal_lab['gender'] != '' ? ' ' . $refferal_lab['gender'] : '' !!}</p>
                                 <p class="mb-0">{!! isset($refferal_lab['date_of_birth']) && $refferal_lab['date_of_birth'] != '' ? ' ' . $refferal_lab['date_of_birth'] : '' !!}</p>
                              </div>
                           </div>
                           </div>
                         </div>
                    </div>
                    @endif
                    @if(!empty($collection_agent))
                    <div class="col-md-3 mt-0">
                        <div class="card border shadow-none" style="margin-bottom:0.8rem;">
                           <div class="card-body py-2">
                            <div class="d-flex gap-3">
                              <div class="icon">
                              <div class="icon-box small_icon bg-light-primary border-0">
                                <i class="bi bi-person-badge text-primary"></i>
                              </div>
                              <h6 class="text-center mt-1 mb-0"><small>Agent</small></h6>
                              </div>
                              <div class="info">
                                 <p class="mb-0">{!! $collection_agent['name'] ?? '' !!}</p>
                                 <p class="mb-0">{!! isset($collection_agent['phone_no']) && $collection_agent['phone_no'] != '' ? ', ' . $collection_agent['phone_no'] : '' !!}</p>
                                 <p class="mb-0">{!! isset($collection_agent['gender']) && $collection_agent['gender'] != '' ? ', ' . $collection_agent['gender'] : '' !!}</p>
                                 <p class="mb-0">{!! isset($collection_agent['date_of_birth']) && $collection_agent['date_of_birth'] != '' ? ', ' . $collection_agent['date_of_birth'] : '' !!}</p>
                              </div>
                           </div>
                           </div>
                         </div>
                    </div>
                    @endif

                    <form class="row auto-width mt-0" action="{{ route('lab-billings.store')}}" method="post" enctype='multipart/form-data' style="padding: 0px 0px 0px 9px;">
                        <div class="col-md-6" style="padding: 0 0 0 9px;">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    @csrf
                                    <h5 class="mb-0">Billing Details</h5>
                                    <hr class="mb-2">
                                    <div class="col-md-6">
                                        <label for="invoice_date" class="form-label">Billing Date <span class="text-danger"><b>*</b></span></label>
                                        <input type="date" class="form-control datepicker" id="invoice_date" name="invoice_date" aria-describedby="inputGroupPrepend" required value="{!! $data['invoice_date'] !!}">
                                        <span class="text-danger error_invoice_date" style="display: none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="amount" class="form-label">Total Billing Amount <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" readonly value="{!! $data['amount'] !!}">
                                        <span class="text-danger error_valid_from" style="display: none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="payment_mode" class="form-label">Payment Mode <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="single-select form-control" name="payment_mode">
                                                @foreach($payment_types as $list)
                                                <option value="{{ $list->id }}" {!! isset($data['payment_mode']) && $data['payment_mode'] = $list->id ? 'selected' : ($list->is_default == 1 ? 'selected' : '') !!}>{{ $list->mode }}</option>
                                                @endforeach
                                            </select>
                                        </div> 
                                        <span class="text-danger error_payment_mode" style="display: none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="special_discount" class="form-label">Special Discount</label>

                                        <div class="input-group">
                                            <input type="text" class="form-control" id="special_discount" value="{!! $data['special_discount'] !!}" name="special_discount" >
                                            <select name="discount_type" id="discount_type" class="form-control">
                                                <option value="FLAT" {!! isset($data['discount_type']) && $data['discount_type'] == 'FLAT' ? 'selected' : '' !!}>FLAT</option>
                                                <option value="PERCENTAGE" {!! isset($data['discount_type']) && $data['discount_type'] == 'PERCENTAGE' ? 'selected' : '' !!}>%</option>
                                            </select>
                                        </div> 
                                        <span class="text-danger error_special_discount" style="display: none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="amount_recieved" class="form-label">Adv. / Amt. Received</label>
                                        <input type="text" class="form-control" value="{!! $data['amount_recieved'] !!}" id="amount_recieved" name="amount_recieved" >
                                        <span class="text-danger error_amount_recieved" style="display: none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="due_balance_amount" class="form-label">Due Balance Amount</label>
                                        <input type="text" class="form-control" id="due_balance_amount" name="due_balance_amount" value="{!! $data['due_balance_amount'] !!}" readonly >
                                        <span class="text-danger error_due_balance_amount" style="display: none;">This field is required.</span>
                                    </div>
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Submit to Create Final Invoice/Bill</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6" style="padding: 0 0 0 18px;">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional Options</h5>
                                    <hr class="mb-2">
                                    <div class="col-md-12">
                                        <label for="invoice_date" class="form-label">Special Case </label>
                                        <div class="input-group">
                                            @foreach($special_cases as $key => $value)
                                            <div class="form-check form-check-inline mb-1">
                                                <input class="form-check-input" type="radio" name="special_case" id="special_case_{!! $value->id !!}" value="{!! $value->id !!}" {!! isset($data['special_case']) && $data['special_case'] == $value->id ? 'checked' : '' !!}>
                                                <label class="form-check-label" for="special_case_{!! $value->id !!}">{!! $value->name !!}</label>
                                            </div>
                                            @endforeach
                                        </div> 
                                    </div>
                                    <div class="col-md-6">
                                        <label for="sample_barcode" class="form-label">Sample Barcode</label>
                                        <input type="text" class="form-control" name="sample_barcode" value="{!! $data['sample_barcode'] ?? '' !!}" placeholder="Sample Barcode">
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="payment_mode" class="form-label">Sample Receive Date </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="date" class="form-control datepicker" id="sample_receive_date" name="sample_receive_date" aria-describedby="inputGroupPrepend" value="{!! $data['sample_receive_date'] !!}">
                                        </div> 
                                    </div>
                                    <div class="col-md-6">
                                        <label for="special_discount" class="form-label">Sample Receive Time</label>

                                        <input type="time" class="form-control" name="sample_receive_time" value="{!! $data['sample_receive_time'] ?? '' !!}">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="invoice_type_id" class="form-label">Invoice Type</label>
                                        <select name="invoice_type_id" id="invoice_type_id" class="form-control">
                                            <option value="1" {!! isset($data['invoice_type_id']) && $data['invoice_type_id'] == '1' ? 'selected' : '' !!}>SELF (Walking Customer)</option>
                                            <option value="2" {!! isset($data['invoice_type_id']) && $data['invoice_type_id'] == '2' ? 'selected' : '' !!}>Refferal Lab</option>
                                            <option value="3" {!! isset($data['invoice_type_id']) && $data['invoice_type_id'] == '3' ? 'selected' : '' !!}>Own Collection Centre</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="due_balance_amount" class="form-label">Any Ref. No</label>
                                        <input id="reff_no" class="form-control" type="text" name="reff_no" autocomplete="off" placeholder="Ref. No" value="{!! $data['reff_no'] ?? '' !!}">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="sale_remarks" class="form-label">Billing Remarks</label>
                                        <textarea name="sale_remarks" id="sale_remarks" rows="1" class="form-control" autocomplete="off" placeholder="Billing Remarks">{!! $data['sale_remarks'] ?? '' !!}</textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="sale_remarks" class="form-label">Remarks for Technician</label>
                                        <textarea name="remarks_for_technician" id="remarks_for_technician" rows="1" class="form-control" autocomplete="off" placeholder="Technician Remarks">{!! $data['remarks_for_technician'] ?? '' !!}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end row-->

@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script>
    $(document).ready(function(){
        fetch_cart();
    });

    function fetch_cart(){
      $.ajax({
        url:"{!! route('billing-product-cart') !!}?page=billing",
        success:function(data){
            $('.cart_products').html('');
            $('.cart_products').html(data);
        }
      })
    }

    $(document).on('focusout', '[name="invoice_date"]', function(){
        $.ajax({
          url     : '{!! route("cart-product-update") !!}',
          method  : 'post',
          data    : {
                "_token": $('meta[name ="csrf-token"]').attr('content'),
                "type": 'billing',
                "invoice_date": $(this).val(),
            },
          headers:
          {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success : function(response){
              if(response.success){
                  fetch_cart();
              }
          },
          error: function (data) {
            console.log("error ",data);
          }
        });
    })

    $(document).on('focusout', '[name="payment_mode"]', function(){
        $.ajax({
          url     : '{!! route("cart-product-update") !!}',
          method  : 'post',
          data    : {
                "_token": $('meta[name ="csrf-token"]').attr('content'),
                "type": 'billing',
                "payment_mode": $(this).val(),
          },
          headers:
          {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success : function(response){
              if(response.success){
                  fetch_cart();
              }
          },
          error: function (data) {
            console.log("error ",data);
          }
        });
    })

    $(document).on('focusout', '.cart_products [name="product_price"]', function(){
        var product_id = $(this).data('product_id');  

        $.ajax({
          url     : '{!! route("cart-product-update") !!}',
          method  : 'post',
          data    : {
                "_token": $('meta[name ="csrf-token"]').attr('content'),
                "id": $(this).data('patient_id'),
                "product_price": $(this).val(),
          },
          headers:
          {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success : function(response){
              if(response.success){
                  fetch_cart();
              }
          },
          error: function (data) {
            console.log("error ",data);
          }
        });
    })

    $(document).on('focusout', '.cart_products [name="per_discount"]', function(){
        var product_id = $(this).data('product_id');  

        $.ajax({
          url     : '{!! route("cart-product-update") !!}',
          method  : 'post',
          data    : {
                "_token": $('meta[name ="csrf-token"]').attr('content'),
                "id": $(this).data('patient_id'),
                "per_discount": $(this).val(),
          },
          headers:
          {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success : function(response){
              if(response.success){
                  fetch_cart();
              }
          },
          error: function (data) {
            console.log("error ",data);
          }
        });
    })

    $(document).on('focusout', '.cart_products [name="flat_discount"]', function(){
        var product_id = $(this).data('product_id');  

        $.ajax({
          url     : '{!! route("cart-product-update") !!}',
          method  : 'post',
          data    : {
                "_token": $('meta[name ="csrf-token"]').attr('content'),
                "id": $(this).data('patient_id'),
                "flat_discount": $(this).val(),
          },
          headers:
          {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success : function(response){
              if(response.success){
                  fetch_cart();
              }
          },
          error: function (data) {
            console.log("error ",data);
          }
        });
    })

    $(document).on('focusout', '.cart_products [name="per_discount"]', function(){
        var product_id = $(this).data('product_id');  

        $.ajax({
          url     : '{!! route("cart-product-update") !!}',
          method  : 'post',
          data    : {
                "_token": $('meta[name ="csrf-token"]').attr('content'),
                "id": $(this).data('patient_id'),
                "per_discount": $(this).val(),
          },
          headers:
          {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success : function(response){
              if(response.success){
                  fetch_cart();
              }
          },
          error: function (data) {
            console.log("error ",data);
          }
        });
    })

    /*********delete data**********/
    $("body").on("click",'.deleteDataCustom', function(event){
          dataString   = {"id":$(this).data('id')};  
          var UrlValue = $(this).data('url');
          var btn      = $(this);

          Swal.fire({
              title: 'Are you sure you want to delete this?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              /* Read more about isConfirmed, isDenied below */
              if (result.isConfirmed) {
                  $.ajax({
                  url     : UrlValue,
                  method  : 'post',
                  data    : {
                        "_token": $('meta[name="csrf-token"]').attr('content'),
                        "id": $(this).data('patient_id')
                    },
                  headers:
                  {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  beforeSend: function( xhr ) {
                      // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                  },
                  success : function(response){
                      if(response.success){
                          var ErroMsg = $(this).printErrorMsg(response.message);

                          $(this).Toastshow('success',ErroMsg);
                          fetch_cart();
                      }else{
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error',ErroMsg);
                      }
                  },
                  error: function (data) {
                    console.log("error ",data);
                  }   
              });
              }
          });
    });
</script>
@endsection