<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Serial No</th>
                <th>Receipt Date</th>
                <th>Receipt No</th>
                <th>Received From</th>
                <th>Voucher Type</th>
                <th>Ref. Voucher No.</th>
                <th>Narration</th>
                <th style="text-align: right;">Amount</th>
                <th class="thbutton">Print</th>
                @if(in_array('receipt-voucher-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('receipt-voucher-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>
                            {{ formatedDate($list->receipt_date) }}<br>
                            {{ formatedTime($list->receipt_time) }}
                        </td>
                        <td><a href="{{route('receipt-voucher.show',$list->id)}}"><strong>{{$list->receipt_no}}</strong>
                            <br>
                            @if($list->advance_received=='Yes' && $list->settlement_status=='Yes')
                            <span class="badge bg-success"><b>
                                {{ 'Advance Adjusted' }}   
                                </b>
                            </span>
                            @elseif($list->advance_received=='Yes')
                                <span class="badge btn-secondary"><b>
                                {{ $list->advance_received=='Yes'?'Advance Receipt':'' }}   
                                </b>
                                </span>
                            @endif
                                 
                        </a>
                        </td>
                        <td>{{ $list->accountReceiptDetail->account->account_title->name ?? '' }} {{ $list->accountReceiptDetail->account->name ?? '' }}
                            <br>
                            @if(isset($list->user->prepared_by))
                            <div style="color:#aaa">By: {!! $list->user->prepared_by??'' !!}</div>
                            @endif
                        </td>
                        <td>{{ $list->accountReceiptDetail->voucherType->name ?? '' }}</td>
                        <td>
                        @if($list->module_code=="OPD_BOOKING")
                            @php $redirectUrl = "opd-bookings.slip";
                                 $id =$list->voucher_id;  @endphp
                        @elseif($list->module_code=="PATHOLOGY")
                            @php $redirectUrl = "pathology-invoice";$id =$list->voucher_id; @endphp
                        @elseif($list->module_code=="SALES")
                            @php $redirectUrl = "print-billing-report";$id =$list->voucher_id; @endphp
                        @elseif($list->module_code=="IPD_INVOICE")
                            @php $redirectUrl = "ipd-print-billing-report";$id =$list->voucher_id; @endphp
                        @else
                            @php $redirectUrl = "print-receipt-voucher";$id =$list->id; @endphp
                        @endif
                        <a href="{!! route($redirectUrl ,$id) !!}">
                            <b>
                            @if(isset($list->accountReceiptDetail->voucherType->name) && $list->accountReceiptDetail->voucherType->name=="OPD Booking")
                            {{ $list->opdBooking->booking_no ?? '' }}
                            @else
                                {!! $list->salesVoucher->voucher_type_invoice_no??'' !!}
                            @endif
                            </b>
                        </a>
                        </td>
                        <td style="white-space: break-spaces;">{{ $list->accountReceiptDetail->details_narration ?? '' }}</td>
                        <td style="text-align: right;">{{ isset($list->accountReceiptDetail->amount) ? convertDecimelPoint($list->accountReceiptDetail->amount) : '' }}</td>
                        <td style="text-align: center;">
                            <a href="{{route('print-receipt-voucher',$list->id)}}" class="btn btn-success" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Print">
                                <i class="bi bi-printer text-white"></i>
                            </a>
                        </td>
                        @if(in_array('receipt-voucher-edit', $authRolePermissions))
                        <td style="text-align: center;">
                            <a href="{{route('receipt-voucher.edit',$list->id)}}" class="btn btn-warning edit" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        @endif
                        @if(in_array('receipt-voucher-delete', $authRolePermissions))
                        <td style="text-align: center;"><a data-url="{{route('receipt-voucher-delete')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete"><i class="bi bi-trash text-white"></i></a></td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="9">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $data->onEachSide(0)->render('accounting-receipt-vouchers.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>

