<style type="text/css">
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
</style>
<form class="row g-3 auto-width create_collection_lab" id="create_collection_lab_form" enctype='multipart/form-data' action="{!! route('collection-agent-account-store') !!}">
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    <div class="col-md-12">
        <div>
            <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="account_title" name="account_title_id" style="width:70px;">
                <option value="">-Title-</option>
                @foreach($account_title as $list)
                <option value="{{ $list->id }}" {!! old('account_title_id') == $list->id ? 'selected' : '' !!}>{{ $list->name }} - {{ $list->gender->name ?? '' }}</option>
                @endforeach
            </select>
            <input type="text" name="name" class="form-control" value="{!! old('name') !!}">
        </div>
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12 mb-3">
        <label class="form-label">Address </label>
        <textarea name="address" class="form-control"></textarea>
    </div>
    <div class="col-md-6">
        <label class="form-label">Country</label>
        <select class="form-control" id="country" name="country_id" onchange="changecontry()" required>
            <option value=" "> Select Country</option>
            @foreach($country as $list)
            <option value="{{ $list->id}}" {!! matchSelected(old('country_id', $country_id), $list->id) !!}>{{$list->name}}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-6 phone_no_col">
        <div>
            <label class="form-label">Phone no<span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control w-100" placeholder="" id="phone_no" />
            <input type="hidden" name="phone_no">
        </div>
        <span class="text-danger error_phone" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6 whatsapp_no_col">
        <div>
            <label class="form-label">Whatsapp no </label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control" placeholder="" id="whatsapp_no" />
            <input type="hidden" name="whatsapp_no">
        </div>
    </div>
    <div class="col-md-6">
        <div>
            <label class="form-label">Email </label>
        </div>
        <div class="input-group">
            <input type="text" class="form-control" placeholder="" name="email" />
        </div>
    </div>
    <div class="col-md-4">
        <label class="form-label">State</label>
        <select class="form-control" name="state_id" id="states" onchange="getcity()">
        <option value=" ">--Select--</option>
        </select>
    </div>
    <div class="col-md-4">
        <label class="form-label">City</label>
        <select class="form-control" name="city_id" id="cities">
        <option value=" ">--Select--</option>
        </select>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">PIN/Postal code </label>
        </div>
        <div class="input-group">
            <input type="text" class="form-control" placeholder="" name="email" />
        </div>
    </div>
</form>

<script>

    $('.details-toggle').hide();
    var toggle = true;

    $("#phone_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#phone_no").val(onlyNumbers);
    });
    $("#whatsapp_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#whatsapp_no").val(onlyNumbers);
    });
    $("#alternative_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#alternative_no").val(onlyNumbers);
    });
    function allNumeric(inputtxt) {
        onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
        if (onlyNumbers.length > 16) {
            onlyNumbers = onlyNumbers.substring(0, 16);
        }
        return onlyNumbers;
    }

    function changecontry()
    {
        let country = $('#country').val();

        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getstate') }}", 
            data: {
                country:country
            },
            success: function (data) {
                $('#states').html(data);
            },
            error: function (data) {
                //console.log(data);
            }
        });

        // GET COUNTRY CODE OF SELECTED COUNTRY
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcountrycode') }}", 
            data: {
                country:country
            },
            success: function (countryCode) {
                // Call reinitializeTelInput and pass the received country code
                reinitializeTelInput(countryCode);
            }
        });
    }

    function getcity()
    {
        let states_id=$('#states').val();

        if (states_id != '' && states_id != null) {
            $.ajax({
                type: "POST",
                url: "{{ url('companies/getcity') }}",
                data: {states_id:states_id},
                success: function (data) {
                    $('#cities').html(data);
                },
            });
        }
    }
</script>
@if($country_id)
    <script>
        changecontry();
        getcity();
    </script>
@endif