<style>
    .ui-autocomplete {
        z-index: 1100;
    }
</style>
<form class="row g-3 auto-width create_task_teams" id="create_task_teams_form" enctype='multipart/form-data'
    action="{{route('task-teams-account-store') }}">
    @csrf
    @method('POST')

    <div class="col-md-6">
        <label for="task_id" class="form-label">Tasks </label>
        <select class="form-control" name="task_id" id="task_id">
            <option value="">Select Tasks</option>
            @foreach($tasks as $key => $list)
            <option value="{{ $list->id }}">{{ $list->title }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-6">
        <label for="user_id" class="form-label"> Users </label>
        <div class="input-group autocomplete">
            <input type="text" name="" id="user_id" class="user-select form-control" placeholder="Search User">
            <ul class="searchResult"></ul>
            <input type="hidden" name="user_id">
        </div>
    </div>

    <div class="col-md-6">
        <div>
            <label for="role" class="form-label"> Role</label>
            <input type="text" class="form-control" id="role" name="role" placeholder="Role">
        </div>
    </div>

    <div class="col-md-6">
        <div>
            <label for="responsibility" class="form-label"> Responsibility</label>
            <input type="text" class="form-control" id="responsibility" name="responsibility"
                placeholder="Responsibility">
        </div>
    </div>

</form>
<script type="text/javascript">
    
$('.user-select').autocomplete({
    autoFocus: true,
    minLength: 0,
    source: function(request, response) {
        if (request.term.length < 2) {
            $('[name="user_id"]').val('');
            return false;
        }

        $.ajax({
            url     : "{{ route('users-search-accounts') }}",
            type    : 'POST',
            dataType: 'json',
            data    : {
                search_text: request.term
            },
            success: function(json) {
                if (json.error) {
                    $('[name="user_id"]').val('');
                    return false;
                }
                response($.map(json.result, function(item) {
                    return {
                        id           : item.id,
                        name         : item.name,
                        code         : item.code,
                        gender       : item.gender,
                        phone_no     : item.phone_no,
                        date_of_birth: item.date_of_birth,
                    };
                }));
            }
        });
    },
    select: function(event, ui) {
        event.preventDefault();
        var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
        var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
        var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';
        var code = ui.item.code != null ? ', ' + ui.item.code : '';

        $(this).val(ui.item.name + code + gender + age + phone_no + "");
        $('[name="user_id"]').val(ui.item.id);
        return false;
    }
}).data("ui-autocomplete")._renderItem = function(ul, item) {
    var age      = item.date_of_birth != null ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
    var gender   = item.gender != null ? ', ' + item.gender : '';
    var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';
    var code = item.code != null ? ', ' + item.code : '';

    return $("<li>")
        .append("<a>" + item.name + code + gender + age + phone_no + "</a>")
        .appendTo(ul);
};

</script>