<form class="row g-3 auto-width create_vehicle" id="create_vehicle_form" enctype='multipart/form-data' action="{{route('vehicle-account-store') }}">
    @csrf
    @method('POST')
    <div class="col-md-6">
        <div>
            <label for="vehicle_no" class="form-label">Vehicle Number <span class="text-danger"><b>*</b></span></label>
                <input type="text" class="form-control" id="vehicle_no" name="vehicle_no" placeholder="Vehicle Number" required>
                <input type="hidden" class="form-control" id="vehicle_id" name="vehicle_id" value="{{$vehicle_id}}">
                <span class="text-danger error_vehicle_no" style="display: none;">This field is required.</span>
        </div>
    </div>

    <div class="col-md-6">
        <label for="ownership_type" class="form-label">Ownership Type <span class="text-danger"><b>*</b></span></label>
            <select class="form-control" name="ownership_type" id="ownership_type" required>
                <option value="">Select Ownership Type</option>
                @foreach(OwnershipTypes() as $key => $list)
                    <option value="{{ $key }}">{{ $list }}</option>
                @endforeach
            </select>
    </div>
   
    <div class="col-md-6">
        <label for="vehicle_type" class="form-label">Vehicle Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="vehicle_type" id="vehicle_type" required>
            <option value="">Select Vehicle Type</option>
            @foreach($vehicles_type as $list)
                <option value="{{ $list->vehicle_type_id }}">{{ $list->vehicle_type_name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_vehicle_type" style="display: none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="manufacture_year" class="form-label">Manufacture Year<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="manufacture_year" name="manufacture_year" placeholder="Manufacture Year">
    </div>

    <div class="col-md-6">
        <label for="vehicle_model" class="form-label">Model <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="vehicle_model" name="vehicle_model" placeholder="Model">
    </div>

    <div class="col-md-6">
        <label for="vehicle_capacity" class="form-label">Capacity</label>
        <input type="number" class="form-control" id="vehicle_capacity" name="vehicle_capacity" placeholder="Capacity">
    </div>

    <div class="col-md-6">
        <div>
            <label class="form-label"> Driver <span class="text-danger"></span></label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" id="driver_name" class="driver-select form-control" placeholder="Search Driver" >
               <input type="hidden" name="driver_ac_id" id="driver_ac_id" class="driver-select form-control" placeholder="" >
            <ul class="searchResult"></ul>
            <div class="input-group-append" style="margin: auto 10px auto 0;">
                <button class="btn btn-secondary add_btn" id="create_driver" type="button">+</button>
                <button style="height: 40px" class="btn btn-primary edit_btn" id="edit_driver" type="button" ><i class="bi bi-pencil-square"></i></button>
            </div>
            
        </div>
    </div>

    <div class="col-md-6">
        <div>
            <label class="form-label"> Vendor <span class="text-danger"></span></label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" id="vendor_ac_id" class="vendor-select form-control" placeholder="Search Vendor" value="">
               <input type="hidden" name="vendor_ac_id" class="vendor-select form-control" placeholder="" >
            <ul class="searchResult"></ul>
            <div class="input-group-append" style="margin: auto 10px auto 0;">
                <button class="btn btn-secondary add_btn" id="create_vendor" type="button">+</button>
                <button style="height: 40px" class="btn btn-primary edit_btn" id="edit_vendor" type="button"><i class="bi bi-pencil-square"></i></button>
            </div>
        </div>
    </div>

    <div class="col-md-12 mb-3">
        <label for="note">Note</label>
        <textarea class="form-control equal-textarea" name="note" id="note" rows="10" style="width: 100%; min-height: 110px;"></textarea>
    </div>


</form>



<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
<script src="{!! asset('admin/js/accounts.js') !!}"></script>


<script>
    $(document).ready(function(){

    //Driver select
    $('.driver-select').autocomplete({
        autoFocus: true,
        minLength: 0,
        source: function(request, response) {
            if (request.term.length < 2) {
                $('[name="driver_ac_id"]').val('');
                return false;
            }

            $.ajax({
                url: "{{ route('register-search-driver') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'get_drivers_for_billing',
                    search_text: request.term
                },
                success: function(json) {
                    if (json.error) {
                        $('[name="driver_ac_id"]').val('');
                        return false;
                    }
                    response($.map(json.result, function(item) {
                        return {
                            id: item.id,
                            name: item.name,
                            code: item.code,
                            phone_no: item.phone_no,
                            date_of_birth: item.date_of_birth,
                        };
                    }));
                }
            });
        },
        select: function(event, ui) {
            event.preventDefault();
            var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';

            $(this).val(ui.item.name + ' - (' + ui.item.code + ')' + phone_no + "");
            $('[name="driver_ac_id"]').val(ui.item.id);
            return false;
        }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';

            return $("<li>")
                .append("<a>" + item.name + ' - (' + item.code + ')' + phone_no + "</a>")
                .appendTo(ul);
    };

    //vendor select
    $('.vendor-select').autocomplete({
        autoFocus: true,
        minLength: 0,
        source: function(request, response) {
            if (request.term.length < 2) {
                $('[name="vendor_ac_id"]').val('');
                return false;
            }

            $.ajax({
                url: "{{ route('register-search-vendor') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'get_vendors_for_billing',
                    search_text: request.term
                },
                success: function(json) {
                    if (json.error) {
                        $('[name="vendor_ac_id"]').val('');
                        return false;
                    }
                    response($.map(json.result, function(item) {
                        return {
                            id: item.id,
                            name: item.name,
                            code: item.code,
                            phone_no: item.phone_no,
                        };
                    }));
                }
            });
        },
        select: function(event, ui) {
            event.preventDefault();
            var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';

            $(this).val(ui.item.name + ' - (' + ui.item.code + ')' + phone_no + "");
            $('[name="vendor_ac_id"]').val(ui.item.id);
            return false;
        }
    }).data("ui-autocomplete")._renderItem = function(ul, item) {
        var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';

        return $("<li>")
            .append("<a>" + item.name + ' - (' + item.code + ')'  + phone_no + "</a>")
            .appendTo(ul);
    };

    });
</script>