<style type="text/css">
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
    .intl-tel-input .country-list {
        z-index: 8;
    }
</style>
<form class="row g-3 auto-width create_vendor" id="create_vendor_form" enctype='multipart/form-data' action="{!! route('vendor-account-store') !!}">
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    
    <div class="col-md-12 mt-0">
        <div>
            <label for="name" class="form-label">Vendor Full Name <span class="text-danger"><b>*</b></span></label>
            <input type="text" name="name" class="form-control" value="" placeholder="Full Name">
        </div>
    </div>

    <div class="col-md-6 phone_no_col">
        <div>
            <label class="form-label">Phone no <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control w-100" placeholder="" id="phone_no" />
            <input type="hidden" name="phone_no">
        </div>
    </div>
    

    <div class="col-md-6 whatsapp_no_col">
        <div>
            <label class="form-label">Whatsapp no </label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control" placeholder="" id="whatsapp_no" />
            <input type="hidden" name="whatsapp_no">
        </div>
    </div>
    <div class="col-md-6">
        <div>
            <label class="form-label">Email </label>
        </div>
        <div class="input-group">
            <input type="text" class="form-control" placeholder="Email" name="email" />
        </div>
    </div>
    <div class="col-md-6">
        <label class="form-label">Country</label>
        <select class="form-control" id="country" name="country_id" onchange="changecontry()" required>
            <option value=" "> Select Country</option>
            @foreach($country as $list)
            <option value="{{ $list->id}}" {!! matchSelected(old('country_id', $country_id), $list->id) !!}>{{$list->name}}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-6">
        <label class="form-label">State</label>
        <input type="hidden" value="{!! $state_id !!}" id="stateid">
        <select class=" form-control" name="state_id" id="states">
        </select>
    </div>
    <div class="col-md-6">
        <label class="form-label">City</label>
        <div class="input-group">
            <input type="hidden" value="{!! $city_id !!}" name="cityid">
            <select class="form-control" name="city_id" id="cities">
            </select>
            <div class="input-group-append" style="margin: auto 10px auto 0;">
                <button class="btn btn-secondary add_btn" id="create_city" type="button">+</button>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <label class="form-label">Address </label>
        <textarea name="address" class="form-control"></textarea>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">PIN/Postal code </label>
        </div>
        <div class="input-group">
            <input type="text" class="form-control" placeholder="PIN/Postal code" name="postal_code" />
        </div>
    </div>
</form>

<script>

    $('.details-toggle').hide();
    var toggle = true;

    $("#phone_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#phone_no").val(onlyNumbers);
    });
    $("#whatsapp_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#whatsapp_no").val(onlyNumbers);
    });
    $("#alternative_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#alternative_no").val(onlyNumbers);
    });
    function allNumeric(inputtxt) {
        onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
        if (onlyNumbers.length > 16) {
            onlyNumbers = onlyNumbers.substring(0, 16);
        }
        return onlyNumbers;
    }

    function changecontry()
    {
        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        let country=$('#country').val();
        let stateid=$('#stateid').val();

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getstate') }}",
            data: {country:country,stateid:stateid},
            success: function (data) {
                $('#states').html(data);
                $('#states').trigger('change');
            },
            error: function (data) {
                console.log(data);
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcountrycode') }}",
            data: {
                country: country
            },
            success: function (countryCode) {
                var telInput = $('#phone_no, #whatsapp_no, #alternative_no');

                // Destroy the existing instances
                telInput.intlTelInput('destroy');

                // Reinitialize the input fields with the new country code
                telInput.intlTelInput({
                    utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js',
                    initialCountry: countryCode, // Set the received country code directly
                    separateDialCode: true
                });
            },
            error: function (data) {
                // Handle error
            }
        });
    }

    $(document).on('change', '#states', function () {
        let states_id=$('#states').val()?$('#states').val():"{{isset($state_id) ? $state_id : ''}}";
        let cityid=$('#cityid').val();

        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcity') }}",
            data: {states_id:states_id,cityid:cityid},
            success: function (data) {
                $('#cities').html(data);
            },
            error: function (data) {
                console.log(data);
            }
        });
    })

    $(document).on('change', '.abha-toggle', function () {

        if ($(this).prop('checked')==true) {
            $('.abha-div').show();
        } else {
            $('.abha-div').hide();
        }
    })
    $(document).ready(function(){
        $.switcher('.abha-toggle');
   
    })
</script>

@if($country_id)
    <script>
        changecontry();

        $('#states').trigger('change');
    </script>
  <script>

</script>
@endif
