<style type="text/css">
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
</style>
<form class="row g-3 auto-width update_doctor_details" id="update_doctor_form" enctype='multipart/form-data' action="{!! route('doctor-account-update',$doctor->id) !!}">
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    <div class="col-md-12">
        <div>
            <label for="name" class="form-label">Doctor Name <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="account_title" name="account_title_id" style="width:120px;">
                <option value="">-Title-</option>
                @foreach($account_title as $list)
                <option value="{{ $list->id }}" {!! matchSelected(@$doctor->account_title_id, $list->id) !!}>{{ $list->name }} - {{ $list->gender->name ?? '' }}</option>
                @endforeach
            </select>
            <input type="text" name="name" class="form-control" value="{!! $doctor->name !!}">
        </div>
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label class="form-label">Qualifications </label>
        <input type="text" class="form-control" placeholder="" name="qualifications" id="qualifications" value="{!! @$doctor->account_contact->qualifications !!}" />
    </div>
    <div class="col-md-12">
        <label class="form-label">Organization </label>
        <input type="text" class="form-control" placeholder="" name="organization" id="organization" value="{!! @$doctor->account_contact->organization !!}"  />
    </div>
    <div class="col-md-6">
        <label class="form-label">Country <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" id="country" onchange="changecontry()"  name="country_id" required>
            <option value=" "> Select Country</option>
            @foreach($country as $list)
            <option value="{{ $list->id}}" {!! matchSelected(@$doctor->account_contact->country_id, $list->id) !!}>{{$list->name}}</option>
            @endforeach
        </select>
        <span class="text-danger error_country_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label class="form-label">State</label>
        <input type="hidden" value="{!! $doctor->account_contact['state_id'] !!}" id="stateid">
        <select class=" form-control" name="state_id" id="states">
        </select>
        <span class="text-danger error_state_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label class="form-label">City</label>
        <input type="hidden" value="{!! $doctor->account_contact['city_id'] !!}" name="cityid">
        <select class="form-control" name="city_id" id="cities">
        </select>
        <span class="text-danger error_city_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6 phone_no_col">
        <div>
            <label class="form-label">Phone no</label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control w-100" placeholder="" id="phone_no" value="{!! @$doctor->account_contact->phone_no !!}" />
            <input type="hidden" name="phone_no" value="{!! @$doctor->account_contact->phone_no !!}">
        </div>
    </div>
</form>

<script>
    $("#phone_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#phone_no").val(onlyNumbers);
    });
    function allNumeric(inputtxt) {
        onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
        if (onlyNumbers.length > 16) {
            onlyNumbers = onlyNumbers.substring(0, 16);
        }
        return onlyNumbers;
    }

    function changecontry()
    {
        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        let country=$('#country').val();
        let stateid=$('#stateid').val();

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getstate') }}",
            data: {country:country,stateid:stateid},
            success: function (data) {
                $('#states').html(data);
                $('#states').trigger('change');
            },
            error: function (data) {
                console.log(data);
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcountrycode') }}",
            data: {
                country: country
            },
            success: function (countryCode) {
                var telInput = $('#phone_no, #whatsapp_no, #alternative_no');

                // Destroy the existing instances
                telInput.intlTelInput('destroy');

                // Reinitialize the input fields with the new country code
                telInput.intlTelInput({
                    utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js',
                    initialCountry: countryCode, // Set the received country code directly
                    separateDialCode: true
                });
            },
            error: function (data) {
                // Handle error
            }
        });
    }

    $(document).on('change', '#states', function () {
        let states_id=$('#states').val()?$('#states').val():"{{isset($state_id) ? $state_id : ''}}";
        let cityid=$('#cityid').val();

        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcity') }}",
            data: {states_id:states_id,cityid:cityid},
            success: function (data) {
                $('#cities').html(data);
            },
            error: function (data) {
                console.log(data);
            }
        });
    })
</script>
@if($country_id)
    <script>
          changecontry();

        $('#states').trigger('change');
    </script>
@endif
