<style type="text/css">
    .account_title {
        width: 50px;
        border: 1px solid #ced4da;
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
</style>
<form class="row g-3 auto-width update_referral" id="update_referral_form" enctype='multipart/form-data' action="{!! route('referral-agent-account-update',$referralAgent->id) !!}">
    <!-- For validation comment on -->
    <!-- <form class="row g-3 was-validated"> -->
    @csrf
    <div class="col-md-12">
        <label class="form-label">Refferal Lab Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" placeholder="" name="organization" id="organization" value="{!! @$referralAgent->account_contact->organization !!}" />
        <span class="text-danger error_organization" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label for="name" class="form-label">Lab Owner Name <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="account_title form-control" name="account_title_id" style="width:70px;">
                <option value=""></option>
                @foreach($account_title as $list)
                <option value="{{ $list->id }}" {!! @$referralAgent->account_title_id == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                @endforeach
            </select>
            <input type="text" name="name" class="form-control" value="{!! $referralAgent->name !!}">
        </div>
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label class="form-label">Country</label>
        <select class="form-control" id="country" name="country_id" onchange="changecontry()" required>
            <option value=""> Select Country</option>
            @foreach($country as $list)
            <option value="{{ $list->id}}" {!! matchSelected(@$referralAgent->account_contact->country_id, $list->id) !!}>{{$list->name}}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-6">
        <div>
            <label class="form-label">Email </label>
        </div>
        <div class="input-group">
            <input type="text" class="form-control" placeholder="" name="email" value="{!! @$referralAgent->account_contact->email !!}" />
        </div>
        @if ($errors->has('email'))
        <span class="text-danger">{{ $errors->first('email') }}</span>
        @endif
    </div>
    <div class="col-md-6 phone_no_col">
        <div>
            <label class="form-label">Phone no<span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control w-100" placeholder="" id="phone_no" value="{!! @$referralAgent->account_contact->phone_no !!}" />
            <input type="hidden" name="phone_no" value="{!! @$referralAgent->account_contact->phone_no !!}">
        </div>
        @if ($errors->has('phone_no'))
        <span class="text-danger">{{ $errors->first('phone_no') }}</span>
        @endif
        <span class="text-danger error_phone" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6 whatsapp_no_col">
        <div>
            <label class="form-label">Whatsapp no </label>
        </div>
        <div class="input-group">
            <input type="tel" class="form-control" placeholder="" id="whatsapp_no" value="{!! @$referralAgent->account_contact->whatsapp_no !!}" />
            <input type="hidden" name="whatsapp_no" value="{!! @$referralAgent->account_contact->whatsapp_no !!}">
        </div>
        @if ($errors->has('whatsapp_no'))
        <span class="text-danger">{{ $errors->first('whatsapp_no') }}</span>
        @endif
    </div>
    <div class="col-md-4">
        <label class="form-label">State</label>
        <input type="hidden" value="{!! $referralAgent->account_contact->state_id !!}" id="stateid">
        <select class="form-control" name="state_id" id="states">
        <option value="">--Select--</option>
        </select>
    </div>
    <div class="col-md-4">
        <label class="form-label">City</label>
        <input type="hidden" value="{!! $referralAgent->account_contact->city_id !!}" name="cityid">
        <select class="form-control" name="city_id" id="cities">
        <option value="">--Select--</option>
        </select>
    </div>
    <div class="col-md-4">
        <div>
            <label class="form-label">PIN/Postal code </label>
        </div>
        <div class="input-group">
            <input type="text" class="form-control" placeholder="" name="postal_code" value="{!! $referralAgent->first_account_address->post_code !!}" />
        </div>
        @if ($errors->has('postal_code'))
        <span class="text-danger">{{ $errors->first('postal_code') }}</span>
        @endif
    </div>
    <div class="col-md-12">
        <label class="form-label">Address </label>
        <textarea name="address" class="form-control">{!! $referralAgent->first_account_address->address_line1 !!}</textarea>
        @if ($errors->has('address'))
        <span class="text-danger">{{ $errors->first('address') }}</span>
        @endif
    </div>
</form>

<script>

$('.details-toggle').hide();
    var toggle = true;

    $("#phone_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#phone_no").val(onlyNumbers);
    });
    $("#whatsapp_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#whatsapp_no").val(onlyNumbers);
    });
    $("#alternative_no").on('input', function() {
        const onlyNumbers = allNumeric($(this).val());
        $("#alternative_no").val(onlyNumbers);
    });
    function allNumeric(inputtxt) {
        onlyNumbers = inputtxt.replace(/[^0-9]/g, '');
        if (onlyNumbers.length > 16) {
            onlyNumbers = onlyNumbers.substring(0, 16);
        }
        return onlyNumbers;
    }
    $("[name='year']").on('input', function() {
        var onlyNumbers = allNumeric($(this).val());

        if (onlyNumbers.length > 4) {
            onlyNumbers = onlyNumbers.substring(0, 4);
        }

        $("[name='year']").val(onlyNumbers);
    });

    $("[name='month']").on('input', function() {
        var month = allNumeric($(this).val());

        if (month > 12) {
            month = 12;
        }

        $("[name='month']").val(month);
    });

    $("[name='day']").on('input', function() {
        var day = parseInt($(this).val());
        if (isNaN(day) || day < 1) {
            day = 1;
        }

        if (day > 31) {
            day = 31;
        }

        $("[name='day']").val(day);
    });
    function changecontry()
    {
        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        let country=$('#country').val();
        let stateid=$('#stateid').val();

        $.ajax({
            type: "POST",
            url: "{{ url('companies/getstate') }}",
            data: {country:country,stateid:stateid},
            success: function (data) {
                $('#states').html(data);
                $('#states').trigger('change');
            },
            error: function (data) {
                console.log(data);
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcountrycode') }}",
            data: {
                country: country
            },
            success: function (countryCode) {
                var telInput = $('#phone_no, #whatsapp_no, #alternative_no');

                // Destroy the existing instances
                telInput.intlTelInput('destroy');

                // Reinitialize the input fields with the new country code
                telInput.intlTelInput({
                    utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js',
                    initialCountry: countryCode, // Set the received country code directly
                    separateDialCode: true
                });
            },
            error: function (data) {
                // Handle error
            }
        });
    }

    $(document).on('change', '#states', function () {
        let states_id=$('#states').val()?$('#states').val():"{{isset($state_id) ? $state_id : ''}}";
        let cityid=$('#cityid').val();

        $.ajaxSetup({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: "POST",
            url: "{{ url('companies/getcity') }}",
            data: {states_id:states_id,cityid:cityid},
            success: function (data) {
                $('#cities').html(data);
            },
            error: function (data) {
                console.log(data);
            }
        });
    })

</script>

@if($country_id)
    <script>
        changecontry();

        $('#states').trigger('change');
    </script>
@endif