@extends('layouts.app')
@section('title','Accounts')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> Accounts
      </div>
      <div class="col-md-6">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb justify-content-md-end mb-0">
            <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="38" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
            <li class="breadcrumb-item active" aria-current="page">Accounts</li>
          </ol>
        </nav>
      </div>
    </div>
    <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
      <div class="card-header py-3">
        @include('layouts.partials.nav-menu')
        <div class="row gx-2">

        <div class="col-lg-2 col-md-2 col-4 dataTables_length">
         <i class="bi bi-funnel"></i>
          <select class="form-select status" name="status" id="status">
            <option value="1">Active</option>
            <option value="0">Deactivate</option>
            
          </select>
        </div>

        <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
          <i class="bi bi-funnel"></i>
          <select class="form-select" id="" name="search_type" aria-controls="example">
              <option value="name">Name</option>
              <option value="code">Code</option>
              <option value="address">Address</option>
              <option value="city">City</option>
              <option value="state">State</option>
              <option value="country">Country</option>
              <option value="phone">Phone</option>
              <option value="abha">UHID/ABHA NO</option>
              <option value="abha_address">ABHA Address</option>
          </select>
        </div>

          <div class="col-lg-2 col-md-2 col-8">
              <div class="position-relative">
                  <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                  <input class="form-control ps-5" type="search" id="search" placeholder="Search">
              </div>
          </div>


          <div class="col-lg-2 col-md-2 col-3 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select account_type" id="account_type" name="example_length" aria-controls="example">
                  <option value="">-Select Account Type-</option>
                  @foreach($account_type as $value)
                      <option value="{!! $value->id !!}">{!! $value->type_name !!}</option>
                  @endforeach
            </select>
          </div>

          <div class="col-lg-2 col-md-2 col-3 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select accounting_groups" id="accounting_groups" name="example_length" aria-controls="example">
                  <option value="">-Select Accountint Group-</option>
                  @foreach($accounting_groups as $value)
                      <option value="{!! $value->id !!}">{!! $value->name !!}</option>
                  @endforeach
            </select>
          </div>

          <div class="col-lg-2 col-md-2">
            <div class="ms-auto float-md-end">

              <!-- <div class="btn-group">
                  <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
              </div> -->

              <div class="btn-group">
                @if(in_array('accounts-create', $authRolePermissions))
                  <a href="{{ route('accounts.create') }}" class="btn btn-primary"><i class="bx bx-plus-circle"></i> Add New</a>
                @endif
              </div>

            </div>
          </div>
        </div>
      </div>

    <div class="card-body" id="tables">

      @include('accounts.table')

      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>
<script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }

  $(document).ready(function(){
    function clear_icon(){
      $('#id_icon').html('');
      $('#post_title_icon').html('');
    }
    function fetch_data(page, sort_type, sort_by, query, account_type, accounting_groups){
      var search_type = $('[name="search_type"]').val();
      var status      = $('[name="status"]').val();

      $.ajax({
        url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&accounting_groups="+accounting_groups+"&account_type="+account_type+"&search_type="+search_type+"&status="+status,
        success:function(data){
          $('#tables').html('');
          $('#tables').html(data);
          $(document).ready(function(){$.switcher();});
        }
      })
    }
   /******** searching ********/
   $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();

        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
        var account_type      = $('#account_type').val();
        var accounting_groups = $('#accounting_groups').val();

        fetch_data(page, sort_type, column_name, query,account_type,accounting_groups);
    }, 700));

    $('body').on('change', '.sorting', function(){

      var column_name = $(this).val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      fetch_data(page, reverse_order, column_name, query,account_type,accounting_groups);
    });

    $('body').on('change', '.status', function(){

      var column_name = $(this).val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      fetch_data(page, reverse_order, column_name, query,account_type,accounting_groups);
      });

    $('body').on('change', '.accounting_groups', function(){

      var column_name = $('.sorting').val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      fetch_data(page, reverse_order, column_name, query,account_type,accounting_groups);
    });

    $('body').on('change', '.account_type', function(){

      var column_name = $('.sorting').val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      fetch_data(page, reverse_order, column_name, query,account_type,accounting_groups);
    });

    $('body').on('click', '.pager a', function(event){
      event.preventDefault();
      console.log('url', $(this).attr('href'));
      var page = $(this).attr('href').split('page=')[1];
      $('#hidden_page').val(page);
      var column_name       = $('.sorting').val()?$('.sorting').val():'';
      var sort_type         = $('#hidden_sort_type').val();
      var query             = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      $('li').removeClass('active');
      $(this).parent().addClass('active');
      fetch_data(page, sort_type, column_name, query,account_type,accounting_groups);
    });

    /*********delete data**********/
    $("body").on("click",'.deleteDataCustom', function(event){
        dataString    = {"id":$(this).data('id')};
        var UrlValue  = $(this).data('url');
        var btn = $(this);

        Swal.fire({
            title: 'Are you sure you want to delete this?',
            icon: 'warning',
            showDenyButton: true,
            showCancelButton: false,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
        }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) {
                $.ajax({
                url     : UrlValue,
                method  : 'post',
                data    :{
                        "_token": $('meta[name="csrf-token"]').attr('content'),
                        "id": $(this).data('id')
                },
                headers:
                {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                beforeSend: function( xhr ) {
                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                },
                success : function(response){
                    if(response.success){
                        var ErroMsg = $(this).printErrorMsg(response.message);

                        $(this).Toastshow('success',ErroMsg);

                        var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                        var column_name = $('.sorting').val()?$('.sorting').val():'';
                        var sort_type   = $('#hidden_sort_type').val();
                        var query       = $('#search').val()?$('#search').val():'';

                        var account_type      = $('#account_type').val();
                        var accounting_groups = $('#accounting_groups').val();
                        fetch_data(page, sort_type, column_name, query,account_type,accounting_groups);
                    }else{
                        var ErroMsg = $(this).printErrorMsg(response.message);
                        $(this).Toastshow('error',ErroMsg);
                    }
                },
                error: function (data) {
                  console.log("error ",data);
                }
            });
            }
        });
    });

    $(document).on('click', '#export_accounts', function(){
        $('#commonModalLabel').text('Export Accounts');
        $('.save_button_span').text('Export Accounts');
        $.ajax({
          url:"{!! route('export-accounts-form') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            $.switcher('[name="primary_accounts"]');
          }
        })
    })
    $(document).on('click', '.save_button', function(){
      $('#commonModal').find('form').submit();
      setTimeout(function() {
      $('#commonModal').modal('hide');
      $('#commonModal').find('.modal-body').html('');

      }, 2000);
    })
  });
</script>
@endsection
