<style>
    .disabled-button {
        pointer-events: none; /* Disable mouse events */
        opacity: 0.5; /* Add a visual indication of disabled state */
    }
</style>
<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Account Name</th>
                <th>Phone No</th>
                <th>Account Type</th>
                <th>Address,City</th>
                <th>State/Province,Country</th>
               
               
                <th>Accounting Group</th>
                <th>Active</th>
                @if(in_array('accounts-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('accounts-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        {{-- <td><a href="{{route('accounts.show',$list->id)}}"><strong>{{ucfirst($list->name)}}</strong></a>
                            @if($list->primary_account == 1)   <br>{{$list->code}}  @endif
                        </td> --}}
                        <td>
                            <a href="{{ route('accounts.show', $list->id) }}">
                                
                                <strong>{!! ucfirst($list->account_title_name) !!} {{ ucfirst($list->name) }}</strong></a>
                            @if($list->primary_account == 1)
                                <div style="display: none;">{{ $list->code }}</div>
                            @else
                                <br>{{ $list->unique_register_no??$list->code }}
                            @endif
                        </td>
                        <td><a href="tel:{{$list->phone_no}}">{{$list->phone_no}}@if(isset($list->whatsapp_no) && $list->whatsapp_no!=''), {!! $list->whatsapp_no !!}@endif</a><br>
                            {{$list->email}}
                        </td>
                        <td>{{ucfirst($list->account_type_name)}}</td>
                        <td style="white-space: break-spaces;">{{$list->address}}@if(isset($list->city)), {{$list->city}}@endif</td>
                        <td>{{$list->state}}@if(isset($list->country)), {{$list->country}}@endif</td>
                        
                        
                        <td>{{ucfirst($list->group_name)}} <br>
                            <div style="color:#aaa">By: {!! $list->prepared_by !!}</div>
                        </td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatus" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('accounts.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('accounts-edit', $authRolePermissions))
                            <td class="text-center">
                                <a href="{{route('accounts.edit',$list->id)}}" class="btn btn-outline-secondary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                            </td>
                        @endif
                        @if(in_array('accounts-delete', $authRolePermissions))
                            <td class="text-center">
                                <a data-url="{{ route('accounts.destroy') }}" data-id="{{ $list->id }}" class="btn btn-danger deleteDataCustom @if($list->primary_account == 1) disabled-button @endif" href="#" class="text-danger"
                                    data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                    <i class="bi bi-trash text-white"></i>
                                </a>
                            </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="10">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="row mt-2">
    <div class="col-md-7 col-sm-12">
        {!! $data->onEachSide(0)->render('accounts.pagination') !!}
    </div>

    
    <div class="col-lg-2 col-md-2 col-sm-6 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>

    <div  class="col-md-3 col-sm-6" style="display: flex; justify-content: space-evenly;">
        @if(in_array('accounts-import', $authRolePermissions))
            <a class="btn btn-outline-primary" href="{!! route('accounts-import.index') !!}"><i class="bi bi-upload"></i> Bulk Import</a>
        @endif

        @if(in_array('accounts-import', $authRolePermissions))
            <button class="btn btn-outline-primary mx-2" id="export_accounts" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-download"></i> Export Accounts</button>
        @endif
    </div>
</nav>
</div>
 