<form class="row g-3 auto-width" action="{{ route('master-settings.store')}}" method="post" enctype='multipart/form-data'>
    @csrf
</form>
@extends('layouts.app')
@section('title','Advance Settings')
@section('pages')
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Advance Settings</div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    {{ \Request::get('redirect_back') }}
                    <form class="row g-3 auto-width" action="{{ route('advance-settings.store')}}" method="post" enctype='multipart/form-data' id="account_form">
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        @csrf
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Settings</h5>
                                    <hr class="mb-0">

                                    @foreach($master_settings as $field)
                                        @if($field->type != 'hidden')
                                        <div class="col-md-12">
                                            <label for="{!! $field->id !!}" class="form-label"><strong>{!! $field->field !!}</strong></label>
                                        @endif
                                        @php
                                            $default_value = $existingField[$field->id] ?? $field->default_value;
                                        @endphp
                                            
                                            @if($field->type == 'text')
                                                <input type="text" class="form-control" maxlength="{!! $field->length != '' ? $field->length : '' !!}" name="details[{!! $field->id !!}]" id="{{ $field->field }}" value="{!! $default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}/>
                                            @elseif($field->type == 'textarea')
                                                <textarea class="form-control" name="details[{!! $field->id !!}]" id="{{ $field->field }}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} maxlength="{!! $field->length != '' ? $field->length : '' !!}" {!! $field->is_menditory == 1 ? 'required' : '' !!}>{!! $default_value !!}</textarea>
                                            @elseif($field->type == 'radio')
                                                <br>
                                                @php
                                                    $options = [];
                                                    $options = explode(',', $field->select_options);
                                                @endphp
                                                @foreach($options as $option)
                                                    <input type="radio" id="{!! $field->id !!}_{{ $option }}" name="details[{!! $field->id !!}]" value="{{ $option }}" {!! $default_value == $option ? 'selected checked' : '' !!} {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
                                                    <label for="{!! $field->id !!}_{{ $option }}">{{ $option }}</label>
                                                    <br>
                                                @endforeach
                                            @elseif($field->type == 'checkbox')
                                                <input type="checkbox" class="checkbox_input" id="{{ $field->id }}" {!! $default_value == true || $default_value == 1 || $default_value == 'on' ? 'checked' : '' !!} {!! $field->is_readonly == 1 ? 'readonly' : '' !!}/>
                                                <input type="hidden" name="details[{!! $field->id !!}]" class="checkbox_value" value="{!! $default_value == true || $default_value == 1 || $default_value == 'on' ? '1' : '0' !!}">
                                            @elseif($field->type == 'select')
                                                @php
                                                    $options = [];
                                                    $options = explode(',', $field->select_options);
                                                @endphp
                                                <select class="form-control" name="details[{!! $field->id !!}]" id="{{ $field->field }}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
                                                    <option value="">Select</option>
                                                    @foreach($options as $option)
                                                        <option value="{{ $option }}" {!! $default_value == $option ? 'selected' : '' !!}>{{ $option }}</option>
                                                    @endforeach
                                                </select>
                                            @elseif($field->type == 'hidden')
                                                <input type="hidden" name="details[{!! $field->id !!}]" value="{!! $default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!}>
                                            @elseif($field->type == 'date')
                                                <input type="date" class="form-control" name="details[{!! $field->id !!}]" id="{{ $field->field }}" value="{!! $default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
                                            @endif

                                        @if($field->type != 'hidden')
                                        </div>
                                        @endif
                                    @endforeach
                                </div>
                                <div class="card-body g-3 row additional_fields">
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Save Account Details</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
<!--end row-->
@endsection

@section('js')
@endsection