@extends('layouts.app')
@section('title','Advance Settings')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Advance Settings
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="50" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Settings</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Advance Settings</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    <div class="row gx-2">
      <div class="col-lg-3 col-md-3">
          <h5>{!! $master->name ?? '' !!} | {!! $type->name ?? '' !!}</h5>
      </div>
      <div class="col-lg-2 col-md-2">
          <input type="text" name="settings-search" class="form-control" placeholder="Search">
      </div>
      <div class="col-lg-7 col-md-7">
        <div class="ms-auto float-md-end">
          
          <div class="btn-group">
             <button class="btn btn-primary" id="create_voucher_master" type="button" data-bs-toggle="modal" data-bs-target="#commonModal">+ Add New </button>
          </div>
                 

          <div class="btn-group text-center">
              <a href="{!! route('voucher-master-types', $id) !!}" class="btn btn-outline-secondary me-1 "><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

  <div class="card-header py-3">
    <form class="row g-3 auto-width m-2" action="{{ route('voucher-master-settings', ['id' => $id, 'type_id' => $type_id])}}" method="post" enctype='multipart/form-data' id="account_form">
      @csrf

      <div class="col-md-12 col-12">
        <div class="form-group">
          <label class="form-label text-info"><strong>Note: After changing please click the submit button to update settings.</strong></label>
        </div>
      </div>
      @foreach($master_settings as $field)
        @if($field->type != 'hidden')
            <div class="col-md-4 col-8 settings">
                <div class="form-group" style="border: solid 1px #e8e8e8; padding: 10px; border-radius: 5px">
                    <label for="{!! $field->id !!}" class="form-label"><strong>{!! $field->field !!}</strong></label>
        @endif

        @php
            $default_value = $existingField[$field->id] ?? $field->default_value;
        @endphp

        @if($field->type == 'text')
            <input type="text" class="form-control" maxlength="{!! $field->length != '' ? $field->length : '' !!}" name="{!! $field->id !!}" id="{{ $field->field }}" value="{!! $default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}/>
        @elseif($field->type == 'textarea')
            <textarea class="form-control" name="{!! $field->id !!}" id="{{ $field->field }}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} maxlength="{!! $field->length != '' ? $field->length : '' !!}" {!! $field->is_menditory == 1 ? 'required' : '' !!}>{!! $default_value !!}</textarea>
        @elseif($field->type == 'radio')
            <br>
            @php
                $options = explode(',', $field->select_options);
            @endphp
            <div class="d-flex">
            @foreach($options as $index => $option)
                <div class="{!! $index > 0 ? 'mx-5' : '' !!}">
                    <input type="radio" id="{!! $field->id !!}_{{ $option }}" name="{!! $field->id !!}" value="{{ $option }}" {!! $default_value == $option ? 'selected checked' : '' !!} {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
                    <label for="{!! $field->id !!}_{{ $option }}">{{ ucfirst($option) }}</label>
                    <br>
                </div>
            @endforeach
            </div>
        @elseif($field->type == 'checkbox')
            <input type="checkbox" class="checkbox_input" id="{{ $field->id }}" {!! $default_value == true || $default_value == 1 || $default_value == 'on' ? 'checked' : '' !!} {!! $field->is_readonly == 1 ? 'readonly' : '' !!}/>
            <input type="hidden" name="{!! $field->id !!}" class="checkbox_value" value="{!! $default_value == true || $default_value == 1 || $default_value == 'on' ? '1' : '0' !!}">
        @elseif($field->type == 'select')
            @php
                $options = explode(',', $field->select_options);
            @endphp
            <select class="form-control" name="{!! $field->id !!}" id="{{ $field->field }}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
                <option value="">Select</option>
                @foreach($options as $option)
                    <option value="{{ $option }}" {!! $default_value == $option ? 'selected' : '' !!}>{{ ucfirst($option) }}</option>
                @endforeach
            </select>
        @elseif($field->type == 'hidden')
            <input type="hidden" name="{!! $field->id !!}" value="{!! $default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!}>
        @elseif($field->type == 'date')
            <input type="date" class="form-control" name="{!! $field->id !!}" id="{{ $field->field }}" value="{!! $default_value !!}" {!! $field->is_readonly == 1 ? 'readonly' : '' !!} {!! $field->is_menditory == 1 ? 'required' : '' !!}>
        @endif

        {!! $field->remarks != '' ? 'Hint: '. $field->remarks : '' !!}
        @if($field->type != 'hidden')
            </div>
        </div>
        @endif
      @endforeach


      <div class="col-md-12 col-12 text-center">
        <div class="form-group">
          <button class="btn btn-primary btn-lg"  type="submit"><i class="bx bx-save"></i> Save Master Settings</button>
        </div>
      </div>
    </form>
  </div>
@endsection
@section('js')
<script type="text/javascript">
  $(document).on('change, keyup','[name="settings-search"]', function() {
    var filter = $(this).val();

    $('.settings').each(function() {
        var title = $(this).find('.form-group').find('.form-label').text();
        if (title.indexOf(filter) >= 0) {
          $(this).show();
        } else {
          $(this).hide();
        }

      });
  })



  // Create Voucher Master Setting Modal
$(document).on('click', '#create_voucher_master', function() {
    $('#commonModalLabel').text('New Voucher Master Setting');
    $('.save_button_span').text('Save Voucher Master');
    $.ajax({
        url: "{{ route('voucher-master-settings-create' , ['id' => $id, 'type_id' => $type_id]) }}",
        success: function(data) {
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
        }
    })
});


//Save Voucher Master Setting
$(document).on('click','.save_button', function(e) {
  e.preventDefault();

  var error = 0;

  if ($('#commonModal').find('form').hasClass('create_voucher_master_settings')) {
      if (error == 0) {
          let formdata = new FormData($('#create_voucher_master_settings_form')[0]);
          $.ajax({
              url: $('#create_voucher_master_settings_form').attr('action'),
              data: formdata,
              processData: false,
              contentType: false,
              type: 'POST',
              success: function (response) {
                  if (response.success === true) {
                      toastr.success(response.message, 'Success.');
                      window.location.reload();
                      // append new category to selection

                      // hide modal
                      $('#commonModal').modal('hide');
                      $('#commonModal').find('.modal-body').html('');

                      } else {
                          // Handle failure case
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error', ErroMsg);
                      }
              }
          })
          .fail(function(jqXHR, textStatus, errorThrown) {
              console.log('AJAX request failed:', textStatus, errorThrown);
              toastr.error('An error occurred during the request.', 'Error!');
          });
      }
  }

})
</script>
@endsection
