@extends('layouts.app')
@section('title', 'Doctor Fees')
@section('pages')
    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }
    </style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> Dr Fees Of {{ ucfirst($doctorName) }} For
        <span class="badge bg-info">{{ucfirst($shift_name->name ?? '')}} Shift</span>
        </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="32"
                            data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                    <li class="breadcrumb-item" aria-current="page">Doctor Fees</li>
                    <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Doctor Fees</li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <div class="card style_table shadow-none radius-5 min-height">
        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">
                <div class="col-lg-3 col-md-3 col-8">
                    <div class="position-relative">
                        <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i
                                class="bi bi-search"></i></div>
                        <input class="form-control ps-5" type="search" id="search" placeholder="Search" autofocus>
                    </div>
                </div>

             

                <div class="col-lg-9 col-md-9">
                    <div class="ms-auto float-md-end">

                        
                        <div class="btn-group">
                            {{-- @if (auth()->user()->can('enquiry-types-create')) --}}
                            <button type="button" class="btn btn-primary" id="create" data-bs-toggle="modal"data-bs-target="#commonModal"><i class="bi bi-plus-circle"></i> Add New</button>
                            {{-- @endif --}}
                        </div>
                        <div class="btn-group">
                            <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i
                                    class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        </div>


                    </div>
                </div>
            </div>
        </div>

        <div class="card-body" id="tables">

            @include('appointment-doctor-fees.table')

            <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
            <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
            <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
        </div>

        <script>
            $(document).ready(function() {
                function clear_icon() {
                    $('#id_icon').html('');
                    $('#post_title_icon').html('');
                }

                function fetch_data(page, sort_type, sort_by, query) {
                    $.ajax({
                        url: "?page=" + page + "&sortby=" + sort_by + "&sorttype=" + sort_type + "&query=" +
                            query,
                        success: function(data) {
                            $('#tables').html('');
                            $('#tables').html(data);
                            $(document).ready(function() {
                                $.switcher();
                            });
                        }
                    })
                }

                //autocomplete
                $(document).on('click', '#create', function() {
                    $('#commonModalLabel').text('Add New Doctor Fees');
                    $('.save_button_span').text('Save Doctor Fees');
                    $.ajax
                    ({
                        url: "{!! route('appointment-doctor-fees.create') !!}",
                        success: function(data) {
                            $('#commonModal').find('.modal-body').html('');
                            $('#commonModal').find('.modal-body').html(data);
                            $('.product-select').autocomplete({
                                autoFocus: true,
                                minLength: 0,
                                source: function(request, response) {
                                    if (request.term.length < 2) {
                                        $('[name="product_id"]').val('');
                                        return false;
                                    }

                                    $.ajax({
                                        url: '{{ route('doctor-fee-search-products') }}',
                                        type: 'POST',
                                        dataType: 'json',
                                        data: {
                                            search_text: request.term
                                        },
                                        success: function(json) {
                                            if (json.error) {
                                                $('[name="product_id"]')
                                                    .val('');
                                                return false;
                                            }
                                            response($.map(json.result,
                                                function(item) {
                                                    return {
                                                        id: item.id,
                                                        name: item.name,
                                                        mrp: item.mrp,
                                                    };
                                                }));
                                        }
                                    });
                                },
                                select: function(event, ui) {
                                    event.preventDefault();
                                    $(this).val(ui.item.name);
                                    $('.product-select').val(ui.item.name);
                                    $('[name="product_id"]').val(ui.item.id);
                                    return false;
                                }
                            }).data("ui-autocomplete")._renderItem = function(ul, item) {
                                
                                return $("<li>").append("<a>" + item.name +"- (" + item.mrp +")"+"</a>").appendTo(ul);
                                
                            };
                        }
                    })

                })
                const productSelect = document.querySelector(".product-select");
                    document.addEventListener("click", (event) => {
                        if (event.target !== productSelect) {
                            $(".searchResult").empty();
                        }
                    });

                $(document).on('click', '.edit', function() {
                    $('#commonModalLabel').text('Edit Doctor Fees');
                    $('.save_button_span').text('Update Doctor Fees');
                    var id = $(this).data('id');
                    var url = `{!! route('appointment-doctor-fees-edit', ':id') !!}`.replace(':id', id);
                    console.log(id);
                    console.log(url);
                    $.ajax({
                        url: url,
                        success: function(data) {
                            $('#commonModal').find('.modal-body').html('');
                            $('#commonModal').find('.modal-body').html(data);
                            $('.product-select').autocomplete({
                                autoFocus: true,
                                minLength: 0,
                                source: function(request, response) {
                                    if (request.term.length < 2) {
                                        $('[name="product_id"]').val('');
                                        return false;
                                    }

                                    $.ajax({
                                        url: '{{ route('doctor-fee-search-products') }}',
                                        type: 'POST',
                                        dataType: 'json',
                                        data: {
                                            search_text: request.term
                                        },
                                        success: function(json) {
                                            if (json.error) {
                                                $('[name="product_id"]')
                                                    .val('');
                                                return false;
                                            }
                                            response($.map(json.result,
                                                function(item) {
                                                    return {
                                                        id: item.id,
                                                        name: item.name,
                                                    };
                                                }));
                                        }
                                    });
                                },
                                select: function(event, ui) {
                                    event.preventDefault();
                                    $(this).val(ui.item.name);
                                    $('[name="product_id"]').val(ui.item.id);
                                    return false;
                                }
                            }).data("ui-autocomplete")._renderItem = function(ul, item) {
                                return $("<li>").append("<a>" + item.name + "</a>").appendTo(ul);
                            };
                        }
                    })
                })

                $(document).on('click', '.save_button', function(event) {
                    event.preventDefault();
                    $('.error_product_id').hide();
                    var error = 0;

                    if ($('#commonModal').find('form').find('input[name="product_id"]').val() == '') {
                        $('.error_product_id').show();
                        error = 1;
                    }

                    if (error == 0) {

                        let formdata = new FormData($('#commonModal').find('form')[0]);

                        var doctor_id =  '{!! $doctor_id !!}';
                        var shift_id =  '{!! $shift_id !!}';
                        formdata.append('doctor_id', doctor_id);
                        formdata.append('shift_id', shift_id);

                        // var url =
                        //     '{{ route('appointment-doctor-fees.create', ['doctor_id' => ':doctor_id', 'shift_id' => ':shift_id']) }}';
                        // url = url.replace(':doctor_id', doctor_id);
                        // url = url.replace(':shift_id', shift_id);
                        $.ajax({
                                url: $('#commonModal').find('form').attr('action'),
                                data: formdata,
                                processData: false,
                                contentType: false,
                                type: 'POST',
                                success: function(response) {
                                    if (response.success === true) {
                                        toastr.success(response.message, 'Success.');

                                        var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                                        var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                                        var sort_type = $('#hidden_sort_type').val();
                                        var query = $('#search').val() ? $('#search').val() : '';

                                        fetch_data(page, sort_type, column_name, query);

                                        // hide modal
                                        $('#commonModal').modal('hide');
                                        $('#commonModal').find('.modal-body').html('');
                                    } else {
                                        toastr.error(response.message, 'Error!');
                                    }
                                }
                            })
                            .fail(function(jqXHR, textStatus, errorThrown) {
                                console.log('AJAX request failed:', textStatus, errorThrown);
                                toastr.error('An error occurred during the request.', 'Error!');

                                // hide modal
                                $('#commonModal').modal('hide');
                                $('#commonModal').find('.modal-body').html('');
                                $('#commonModal').removeClass('category');
                            });
                    }
                    error = 1;
                })

                $('body').on('keyup change input', '#search', function() {
                    var query = $('#search').val();
                    var column_name = $('.sorting').val();
                    var sort_type = $('#hidden_sort_type').val();
                    var page = 1 ? 1 : (this).attr('href').split('page=')[1];
                    fetch_data(page, sort_type, column_name, query);
                });

                $('body').on('change', '.sorting', function() {
                    var column_name = $(this).val();
                    var order_type = $(this).data('sorting_type');
                    var reverse_order = '';
                    var page = 1 ? 1 : (this).attr('href').split('page=')[1];
                    var query = $('#search').val() ? $('#search').val() : '';
                    fetch_data(page, reverse_order, column_name, query);
                });

                $('body').on('click', '.pager a', function(event) {
                    event.preventDefault();
                    $('#hidden_page').val(page);
                    var page = $(this).attr('href').split('page=')[1];
                    var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                    var sort_type = $('#hidden_sort_type').val();
                    var query = $('#search').val() ? $('#search').val() : '';
                    $('li').removeClass('active');
                    $(this).parent().addClass('active');
                    fetch_data(page, sort_type, column_name, query);
                });

                /*********delete data**********/
                $("body").on("click", '.deleteDataCustom', function(event) {
                    dataString = {
                        "id": $(this).data('id')
                    };
                    var UrlValue = $(this).data('url');
                    var btn = $(this);

                    Swal.fire({
                        title: 'Are you sure you want to delete this?',
                        icon: 'warning',
                        showDenyButton: true,
                        showCancelButton: false,
                        confirmButtonText: 'Yes',
                        denyButtonText: 'No',
                    }).then((result) => {
                        /* Read more about isConfirmed, isDenied below */
                        if (result.isConfirmed) {
                            $.ajax({
                                url: UrlValue,
                                method: 'post',
                                data: {
                                    "_token": $('meta[name="csrf-token"]').attr('content'),
                                    "id": $(this).data('id')
                                },
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                beforeSend: function(xhr) {
                                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                                },
                                success: function(response) {
                                    if (response.success) {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);

                                        $(this).Toastshow('success', ErroMsg);

                                        var page = $('.pager').find('.active a').attr(
                                            'href') == undefined ? 1 : $('.pager').find(
                                            '.active a').attr('href').split('page=')[1];
                                        var column_name = $('.sorting').val() ? $(
                                            '.sorting').val() : '';
                                        var sort_type = $('#hidden_sort_type').val();
                                        var query = $('#search').val() ? $('#search')
                                        .val() : '';

                                        fetch_data(page, sort_type, column_name, query);
                                    } else {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        $(this).Toastshow('error', ErroMsg);
                                    }
                                },
                                error: function(data) {
                                    console.log("error ", data);
                                }
                            });
                        }
                    });
                });

                /*********change status**********/
                $("body").on("click", '.changeStatusCustom', function(event) {
                    dataString = {
                        "id": $(this).data('id'),
                        "status": $(this).data('status')
                    };
                    var UrlValue = $(this).data('url');
                    var status = $(this).data('status');
                    var changeStatus = $(this);
                    var btn = $(this);

                    Swal.fire({
                        title: 'Are you sure you want to change status?',
                        icon: 'warning',
                        showDenyButton: true,
                        showCancelButton: false,
                        confirmButtonText: 'Yes',
                        denyButtonText: 'No',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: UrlValue,
                                method: 'post',
                                data: dataString,
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                beforeSend: function(xhr) {
                                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                                },
                                success: function(response) {
                                    if (response.success) {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        $(this).Toastshow('success', ErroMsg);

                                        var page = $('.pager').find('.active a').attr(
                                            'href') == undefined ? 1 : $('.pager').find(
                                            '.active a').attr('href').split('page=')[1];
                                        var column_name = $('.sorting').val() ? $(
                                            '.sorting').val() : '';
                                        var sort_type = $('#hidden_sort_type').val();
                                        var query = $('#search').val() ? $('#search')
                                        .val() : '';

                                        fetch_data(page, sort_type, column_name, query);
                                    } else {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        if (ErroMsg === '') {
                                            ErroMsg = "Something went wrong!";
                                        }
                                        $(this).Toastshow('error', ErroMsg);

                                        if (status == 1) {
                                            changeStatus.parent().find('.ui-switcher').attr(
                                                'aria-checked', false);
                                        } else {
                                            changeStatus.parent().find('.ui-switcher').attr(
                                                'aria-checked', true);
                                        }
                                    }
                                },
                                error: function(data) {
                                    console.log("error ", data);

                                    if (status == 1) {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', false);
                                    } else {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', true);
                                    }
                                }
                            });
                        } else if (result.isDenied) {
                            var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $(
                                '.pager').find('.active a').attr('href').split('page=')[1];
                            var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                            var sort_type = $('#hidden_sort_type').val();
                            var query = $('#search').val() ? $('#search').val() : '';

                            fetch_data(page, sort_type, column_name, query);
                        }
                        //return false;
                    });
                    //return false;
                });
            });
        </script>
    @endsection
