@extends('layouts.app')
@section('title', 'Appointment Doctor schedule')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
        border-right: none;
    }
    </style>
    @php
        if (isset($doctor_id))
        {

    @endphp

    <style type="text/css">
   #doctor_schedule_id {
        display: none;
    }
    </style>
    @php
        }
    @endphp

<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Appointment Doctor schedule
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="88" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Appointment Schedule</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Appointment Doctor schedule</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->
<div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
        @include('layouts.partials.nav-menu')
        <div class="row gx-2">
          <div class="col-lg-3 col-md-3 col-8">
              <div class="position-relative">
                  <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                  <input class="form-control ps-5" type="search" id="search" placeholder="Search">
              </div>
          </div>

          <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
            <i class="bi bi-funnel"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
          </div>

          <div class="col-lg-7 col-md-7">
            <div class="ms-auto float-md-end">

              <div class="btn-group">
                  <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
              </div>

              <div class="btn-group">
                @if(in_array('appointment-doctor-schedule-create', $authRolePermissions))
                  <button type="button" class="btn btn-primary" id="create" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
                @endif
              </div>
            </div>
          </div>
        </div>
    </div>
    <div class="card-body" id="tables">
        @include('appointment-doctor-schedule.table')

        <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>
@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
        $(document).ready(function() {
            function clear_icon() {
                $('#id_icon').html('');
                $('#post_title_icon').html('');
            }

            function fetch_data(page, sort_type, sort_by, query) {
                $.ajax({
                    url: "?page=" + page + "&sortby=" + sort_by + "&sorttype=" + sort_type + "&query=" +
                        query,
                    success: function(data) {
                        $('#tables').html('');
                        $('#tables').html(data);
                        $(document).ready(function() {
                            $.switcher();
                        });
                    }
                })
            }

            $(document).on('click', '#create', function() {
                $('#commonModalLabel').text('Add New Appointment Doctor schedule');
                $('.save_button_span').text('Save Appointment Doctor schedule');
                $.ajax

                ({
                    url: "{!! route('appointment-doctor-schedule.create') !!}",
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data);

                        $('.doctor-select').autocomplete({
                            autoFocus: true,
                            minLength: 0,
                            source: function(request, response) {
                                if (request.term.length < 2) {
                                    $('[name="doctor_id"]').val('');
                                    return false;
                                }

                                $.ajax({
                                    url: '{{ route('appointment-doctor-schedule-search-doctors') }}',
                                    type: 'POST',
                                    dataType: 'json',
                                    data: {
                                        search_text: request.term
                                    },
                                    success: function(json) {
                                        if (json.error) {
                                            $('[name="doctor_id"]')
                                                .val('');
                                            return false;
                                        }
                                        response($.map(json.result,
                                            function(item) {
                                                return {
                                                    id: item.id,
                                                    name: item.name,
                                                };
                                            }));
                                    }
                                });
                            },
                            select: function(event, ui) {
                                event.preventDefault();
                                $(this).val(ui.item.name);
                                $('[name="doctor_id"]').val(ui.item.id);
                                return false;
                            }
                        }).data("ui-autocomplete")._renderItem = function(ul, item) {
                            return $("<li>").append("<a>" + item.name + "</a>").appendTo(ul);
                        };
                    }
                })

            })

            $(document).on('click', '.edit', function() {
                $('#commonModalLabel').text('Edit Appointment Doctor schedule');
                $('.save_button_span').text('Update Appointment Doctor schedule');
                var id = $(this).data('id');
                var url = `{!! route('appointment-doctor-schedule.edit', ':id') !!}`.replace(':id', id);

                $.ajax({
                    url: url,
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data);
                    }
                })
            })
            $(document).on('click', '.days', function(){
                var doctor_id = $(this).data('doctor_id');
                var shift_id = $(this).data('shift_id');

                $('#commonModalLabel').text('Add New Add Days');
                $('.save_button_span').text('Save Days');
                $.ajax({
                url:"{!! route('add-days') !!}",
                data:{
                    'doctor_id' : doctor_id,
                    'shift_id' : shift_id,
                },
                success:function(data){
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').find('.modal-body').html(data);
                    $('.save_button').addClass('save_days');
                }
                })

                //days
                $(document).on('click', '.save_days', function(event){
                    event.preventDefault();
                    $('.error_day').hide();
                    var error = 0;

                    var selectedValues = $('select[name="day[]"]').val();
                    if (!selectedValues || selectedValues.length === 0) {
                        $('.error_day').show();
                        return;
                    }

                    if (error == 0) {
                        var inputElement = $("<input type='text' id='myInput' name='doctor_id'>");
                        $("#scheduleDays").append(inputElement);
                        var inputElement = $("<input type='text' id='myInput' name='shift_id'>");
                        $("#scheduleDays").append(inputElement);
                        $('input[name="doctor_id"]').val(doctor_id);
                        $('input[name="shift_id"]').val(shift_id);
                        $('#commonModal').find('form').submit();
                    }
                    error = 1;
                })
            })
            //main
            $(document).on('click', '.save_button', function(event) {
                event.preventDefault();
                $('.error_doctor_id').hide();
                $('.error_day').hide();
                $('.error_shift_id').hide();
                var error = 0;

                @if(!isset($doctor_id))
                    if($('#commonModal').find('form').find('input[name="doctor_id"]').val() == '') {
                        $('.error_doctor_id').show();
                        error = 1;
                    }
                @else
                    $('#commonModal').find('form').find('input[name="doctor_id"]').val("{{$doctor_id}}");
                @endif

                // var selectedValues = $('select[name="day[]"]').val();
                // if (!selectedValues || selectedValues.length === 0) {
                //     $('.error_day').show();
                //     return;
                // }

                if ($('#commonModal').find('form').find('select[name="shift_id"]') == '' || $('#commonModal').find('form').find('select[name="shift_id"]').val() == null)
                {
                    $('.error_shift_id').show();
                    error = 1;
                }
                if (error == 0) {
                    $('#commonModal').find('form').submit();
                    $.ajax({
                            url: $('#create_doctor_form').attr('action'),
                            data: formdata,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            success: function(response) {
                                if (response.success === true) {
                                    toastr.success(response.message, 'Success.');
                                    // append new category to selection
                                    $('[name="doctor_id"]').val(response.data.id);
                                    $('.doctor-select').val(response.data.name);

                                    // hide modal
                                    $('#commonModal').modal('hide');
                                    $('#commonModal').find('.modal-body').html('');
                                } else {
                                    toastr.error(response.message, 'Error!');
                                }
                            }
                        })
                        .fail(function(jqXHR, textStatus, errorThrown) {
                            console.log('AJAX request failed:', textStatus, errorThrown);
                            toastr.error('An error occurred during the request.', 'Error!');
                        });
                    }
                error = 1;
            })
            $(document).ready(function() {
                const doctorSelect = document.querySelector(".doctor-select");
                document.addEventListener("click", (event) => {
                    if (event.target !== doctorSelect) {
                        $(".searchResult").empty();
                    }
                });
                $('body').on('keyup change input', '#search', function() {
                    var query = $('#search').val();
                    var column_name = $('.sorting').val();
                    var sort_type = $('#hidden_sort_type').val();
                    var page = 1 ? 1 : (this).attr('href').split('page=')[1];
                    fetch_data(page, sort_type, column_name, query);
                });
                $('body').on('change', '.sorting', function() {
                    var column_name = $(this).val();
                    var order_type = $(this).data('sorting_type');
                    var reverse_order = '';
                    var page = 1 ? 1 : (this).attr('href').split('page=')[1];
                    var query = $('#search').val() ? $('#search').val() : '';
                    fetch_data(page, reverse_order, column_name, query);
                });
                $('body').on('click', '.pager a', function(event) {
                    event.preventDefault();
                    $('#hidden_page').val(page);
                    var page = $(this).attr('href').split('page=')[1];
                    var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                    var sort_type = $('#hidden_sort_type').val();
                    var query = $('#search').val() ? $('#search').val() : '';
                    $('li').removeClass('active');
                    $(this).parent().addClass('active');
                    fetch_data(page, sort_type, column_name, query);
                });
                 /*********change status**********/
                $("body").on("click", '.changeStatusCustom', function(event) {
                    dataString = {
                        "id": $(this).data('id'),
                        "status": $(this).data('status')
                    };
                    var UrlValue = $(this).data('url');
                    var status = $(this).data('status');
                    var changeStatus = $(this);
                    var btn = $(this);

                    Swal.fire({
                        title: 'Are you sure you want to change status?',
                        icon: 'warning',
                        showDenyButton: true,
                        showCancelButton: false,
                        confirmButtonText: 'Yes',
                        denyButtonText: 'No',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: UrlValue,
                                method: 'post',
                                data: dataString,
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                beforeSend: function(xhr) {
                                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                                },
                                success: function(response) {
                                    if (response.success) {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        $(this).Toastshow('success', ErroMsg);

                                        $('#search').trigger('change');
                                    } else {
                                        var ErroMsg = $(this).printErrorMsg(response
                                            .message);
                                        if (ErroMsg === '') {
                                            ErroMsg = "Something went wrong!";
                                        }
                                        $(this).Toastshow('error', ErroMsg);

                                        if (status == 1) {
                                            changeStatus.parent().find('.ui-switcher').attr(
                                                'aria-checked', false);
                                        } else {
                                            changeStatus.parent().find('.ui-switcher').attr(
                                                'aria-checked', true);
                                        }
                                    }
                                },
                                error: function(data) {
                                    console.log("error ", data);

                                    if (status == 1) {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', false);
                                    } else {
                                        changeStatus.parent().find('.ui-switcher').attr(
                                            'aria-checked', true);
                                    }
                                }
                            });
                        } else if (result.isDenied) {
                            $('#search').trigger('change');
                        }
                        //return false;
                    });
                    //return false;
                });
                // delete custom
                $("body").on("click", '.deleteDataCustom', function(event) {
                    dataString = {
                        "id": $(this).data('id')
                    };
                    var UrlValue = $(this).data('url');
                    var btn = $(this);
                    Swal.fire({
                        title: 'Are you sure you want to delete this?',
                        icon: 'warning',
                        showDenyButton: true,
                        showCancelButton: false,
                        confirmButtonText: 'Yes',
                        denyButtonText: 'No',
                    }).then((result) => {
                        /* Read more about isConfirmed, isDenied below */
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('appointment-doctor-schedule.destroy') }}",
                                method: 'post',
                                data: {
                                    "_token": $('meta[name="csrf-token"]').attr(
                                        'content'),
                                    "id": $(this).data('id')
                                },
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                                        .attr('content')
                                },
                                beforeSend: function(xhr) {
                                },
                                success: function(response) {
                                    if (response.success) {
                                        var ErroMsg = $(this).printErrorMsg(
                                            response
                                            .message);
                                        $(this).Toastshow('success', ErroMsg);

                                        var page = $('.pager').find('.active a').attr(
                                            'href') == undefined ? 1 : $('.pager').find(
                                            '.active a').attr('href').split('page=')[1];
                                        var column_name = $('.sorting').val() ? $(
                                            '.sorting').val() : '';
                                        var sort_type = $('#hidden_sort_type').val();
                                        var query = $('#search').val() ? $('#search')
                                        .val() : '';

                                        fetch_data(page, sort_type, column_name, query);
                                    } else {
                                        var ErroMsg = $(this).printErrorMsg(
                                            response
                                            .message);
                                        $(this).Toastshow('error', ErroMsg);
                                    }
                                },
                                error: function(data) {
                                    console.log("error ", data);
                                }
                            });
                        }
                    });
                     /*********change status**********/
                    $("body").on("click", '.changeStatusCustom', function(event) {
                        dataString = {
                            "id": $(this).data('id'),
                            "status": $(this).data('status')
                        };
                        var UrlValue = $(this).data('url');
                        var status = $(this).data('status');
                        var changeStatus = $(this);
                        var btn = $(this);

                        Swal.fire({
                            title: 'Are you sure you want to change status?',
                            icon: 'warning',
                            showDenyButton: true,
                            showCancelButton: false,
                            confirmButtonText: 'Yes',
                            denyButtonText: 'No',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: UrlValue,
                                    method: 'post',
                                    data: dataString,
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                                            .attr('content')
                                    },
                                    beforeSend: function(xhr) {
                                        // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                                    },
                                    success: function(response) {
                                        if (response.success) {
                                            var ErroMsg = $(this).printErrorMsg(
                                                response.message);
                                            $(this).Toastshow('success', ErroMsg);

                                            $('#search').trigger('change');
                                        } else {
                                            var ErroMsg = $(this).printErrorMsg(
                                                response.message);
                                            if (ErroMsg === '') {
                                                ErroMsg = "Something went wrong!";
                                            }
                                            $(this).Toastshow('error', ErroMsg);

                                            if (status == 1) {
                                                changeStatus.parent().find(
                                                    '.ui-switcher').attr(
                                                    'aria-checked', false);
                                            } else {
                                                changeStatus.parent().find(
                                                    '.ui-switcher').attr(
                                                    'aria-checked', true);
                                            }
                                        }
                                    },
                                    error: function(data) {
                                        console.log("error ", data);

                                        if (status == 1) {
                                            changeStatus.parent().find(
                                                '.ui-switcher').attr(
                                                'aria-checked', false);
                                        } else {
                                            changeStatus.parent().find(
                                                '.ui-switcher').attr(
                                                'aria-checked', true);
                                        }
                                    }
                                });
                            } else if (result.isDenied) {
                                $('#search').trigger('change');
                            }
                            //return false;
                        });
                        //return false;
                    });
                });

            });
        });
    </script>
@endsection
