@extends('layouts.app')
@section('title', 'Doctor Shift Days')
@section('pages')
    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }
    </style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> Days of Dr {{ucfirst($doctor_days->getDoctor->getAccount->name ?? '') }}
        For <span class="badge bg-info">{{ucfirst($shift_name->name)}} Shift</span>
        </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="84" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <!-- main -->
    <div class="card style_table shadow-none radius-5 min-height">

        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-5" style="margin-left:0px">

                <div class="parent-checkbox col-md-12 px-3 mt-3 d-sm-flex">
                <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                    <div class="col-lg-11 col-md-11">
                        <div class="ms-auto float-md-end">
                            <div class="btn-group">
                            <h5 class="pe-2">Allow All Shifts</h5>
                    <hr>
                    <input type="checkbox" class='header-checkbox' class="form-control" id="check-all">

                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body" id="tables">
            @include('appointment-doctor-shift-days.table')

            <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
            <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
            <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
        </div>
        <!-- end main -->

    @endsection
    @section('js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
        <script>
            $(document).ready(function() {
                // permission to all 
                $(document).on('change', '#check-all', function() {
                     var parent = $('#tables');
                     if ($(this).is(':checked')) {
                         parent.find('input[type="checkbox"]').prop('checked', true);
                         parent.find('.ui-switcher').attr('aria-checked', true);
                         // parent.find('input[type="checkbox"]').trigger('change');
                        } else {
                        console.log('test1');
                        parent.find('input[type="checkbox"]').prop('checked', false);
                        parent.find('.ui-switcher').attr('aria-checked', false);
                        // parent.find('input[type="checkbox"]').trigger('change');
                    }
                    
                    var doctorId = {!! $doctor_id !!};
                    var shiftId = {!! $shift_id !!};

                    var formData = new FormData();
                    formData.append("shift_id", shiftId);
                    formData.append("doctor_id", doctorId);
                    formData.append("day_id", 'all');

                    if ($(this).is(':checked')) {
                        formData.append("status", '1');
                    } else {
                        formData.append("status", '0');
                    }

                    $.ajax({
                        url: "{!! route('appointment-doctor-shift-days.status-active') !!}",
                        data: formData,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        success: function(response) {
                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');

                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');
                    });
                });
                // permission allows one by one
                $(document).on('change', '.days_click', function() {
                    console.log('test3');
                    var dayId = $(this).data('day_id');
                    var doctorId = {!! $doctor_id !!};
                    var shiftId = {!! $shift_id !!};

                    var formData = new FormData();
                    formData.append("doctor_id", doctorId);
                    formData.append("shift_id", shiftId);
                    formData.append("day_id", dayId);

                    if ($(this).is(':checked')) {
                        formData.append("status", '1');
                    } else {
                        formData.append("status", '0');
                    }

                    $.ajax({
                        url: "{!! route('appointment-doctor-shift-days.status-active') !!}",
                        data: formData,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        success: function(response) {
                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');

                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');
                    });
                });

                //hide or show buttons
                
                $(document).on('change', '.body-checkbox', function() {
                    var a = $('.body-checkbox');
                    if (a.length == a.filter(":checked").length) {
                        $('.header-checkbox').prop('checked', true);
                        $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', true);
                    } else {
                        $('.header-checkbox').prop('checked', false);
                        $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', false);
                    }
                });

                var a = $('.body-checkbox');
                if (a.length == a.filter(":checked").length) {
                    $('.header-checkbox').prop('checked', true);
                    $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', true);
                } else {
                    $('.header-checkbox').prop('checked', false);
                    $('.parent-checkbox').find('.ui-switcher').attr('aria-checked', false);
                }
            });
        </script>
    @endsection
