<form class="row g-3 auto-width" action="{{ route('assignments.update', $data->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('PUT')
    <input type="hidden" name="course_id" class="course_id" value="">
    <div class="col-md-12">
        <label for="validationCustomTitle" class="form-label">Title <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="validationCustomTitle" name="title" aria-describedby="inputGroupPrepend" value="{!! $data->title !!}" required>
        @if ($errors->has('title'))
        <span class="text-danger">{{ $errors->first('title') }}</span>
        @endif
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="validationTextarea" class="form-label">Deadline (m/d/Y)</label>
        <input type="date" value="{!! date('Y-m-d', strtotime($data->deadline)) !!}" class="form-control" name="deadline">
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="validationCustomMetaTitle" class="form-label">Total Marks <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" value="{!! $data->total_marks !!}" id="validationCustomMetaTitle" name="total_marks" aria-describedby="inputGroupPrepend" required>
        @if ($errors->has('total_marks'))
        <span class="text-danger">{{ $errors->first('total_marks') }}</span>
        @endif
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="validationCustomMetaTitle" class="form-label">Passing Marks <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" value="{!! $data->passing_marks !!}" id="validationCustomMetaTitle" name="passing_marks" aria-describedby="inputGroupPrepend" required>
        @if ($errors->has('passing_marks'))
        <span class="text-danger">{{ $errors->first('passing_marks') }}</span>
        @endif
        <span class="text-danger error_name" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label for="tags" class="form-label">Description <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group"  style="display: flex; flex-direction: column; flex-wrap: nowrap;">
            <textarea id="description" name="description" required>{!! $data->description !!}</textarea>
        </div>
        @if ($errors->has('description'))
            <span class="text-danger">{{ $errors->first('description') }}</span>
        @endif
        <span class="text-danger" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="validationTextarea" class="form-label">File (350x150)</label>
        <input type="file" class="form-control" name="attachment_file" aria-label="file example">
        <div class="invalid-feedback">Example invalid form file </div>
    </div>
</form>
