<!doctype html>
<html lang="en" class="minimal-theme">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap CSS -->
  <link href="{{asset('admin/css/bootstrap.min.css')}}" type="text/css" rel="stylesheet" />
  <link href="{{asset('admin/css/bootstrap-extended.css')}}" type="text/css" rel="stylesheet" />
  <link href="{{asset('admin/css/style.css')}}" type="text/css" rel="stylesheet" />
  <link href="{{asset('admin/css/icons.css')}}" type="text/css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
  <!-- loader-->
	<link href="{{asset('admin/css/pace.min.css')}}" rel="stylesheet" />
  <!-- Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
  <!-- Favicon.io -->
  <link rel="icon" href="asset/iadmin/mages/favicon.ico" type="image/png" />
  <!-- Meta Taggs -->
  <title>SignIn &#8212; @if(isset($companyData->name)){{$companyData->name}}@else{{'website_title_here'}}@endif</title>
  <meta name="author" content="SignIn &#8212; #website_title_here">
  <meta name="description" content="#website_meta_description_here">
  <meta name="keywords" content="#website_meta_keywords_here">
  
</head>

<body>

  <!--start wrapper-->
  <div class="wrapper">
    
       <!--start content-->
       <main class="authentication-content">
        <div class="container-fluid">
          <div class="authentication-card">
            <div class="card bg-transparent shadow-none rounded-0 overflow-hidden">
              <div class="row align-items-center justify-content-center g-0">
                <!-- <div class="col-lg-7 d-flex align-items-center justify-content-center">
                  <img src="asset/iadmin/mages/login-img.svg" loading="lazy" class="img-fluid" alt="login image">
                </div> -->
                <div class="col-lg-8">
                  <div class="card-body bg-white rounded singin_card">
                    <!-- <h5 class="card-title">Sign In</h5>
                    <p class="card-text mb-3">See your growth and get consulting support!</p> -->
                    <img class="img-fluid d-block w-100 mx-auto" src="@if(isset($companyData->getCompanyImage->image_url) && $companyData->getCompanyImage->image_url != '')
                        {{ getTempUrl($companyData->getCompanyImage->image_url) }}
                    @else{{ 'https://metaminthealth.s3.ap-south-1.amazonaws.com/metamintassets/images/meta_mint_blue_small_logo.png' }}
                    @endif" loading="lazy" style="height:70px" alt="logo">
                    @include('flash-message')
                    <form class="form-body" class="user" action="{{ route('forget.password.post') }}" method="POST">
                        @csrf
                      <div class="login-separater text-center mb-4"> <span>@if(isset($companyData->name)){{ $companyData->name }}@else{{'COMPANY NAME PUT HERE'}}@endif</span>
                        <hr>
                      </div>
                        <div class="row g-3">
                          <div class="col-12">
                            <label for="inputEmailAddress" class="form-label">Email Address</label>
                            <div class="ms-auto position-relative">
                              <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-envelope-fill"></i></div>
                              <input type="email" id="email_address" name="email" class="form-control ps-5" id="inputEmailAddress" placeholder="Email Address" required>
                            </div>
                          </div>
                          <div class="col-12">
                            &nbsp;
                            <!-- <label for="inputChoosePassword" class="form-label">Enter Password</label> -->
                            <!-- <div class="ms-auto position-relative">
                              <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-lock-fill"></i></div>
                              <input type="password" name="password" class="form-control ps-5" id="inputChoosePassword" placeholder="Enter Password" required>
                            </div> -->
                          </div>
                          <div class="col-6">
                            &nbsp;
                            <!-- <div class="form-check form-switch">
                              <input class="form-check-input" type="checkbox" id="flexSwitchCheckChecked">
                              <label class="form-check-label" for="flexSwitchCheckChecked">Remember Me</label>
                            </div> -->
                          </div>
                          <div class="col-6 text-end">	<a href="{{ route('login') }}">Back To Sign In</a>
                          </div>
                          <div class="col-12">
                            <div class="d-grid">
                              <button type="submit" class="btn btn-primary radius-30">Send Password Reset Link<i class="bx bx-log-in-circle"></i></button>
                            </div>
                          </div>
                          <!-- <div class="col-12">
                            <p class="mb-0">Don't have an account yet? <a href="authentication-signup.html">Sign up here</a></p>
                          </div> -->
                        </div>
                    </form>
                 </div>
                </div>
              </div>
            </div>
          </div>
        </div>
       </main>
       <!--end page main-->

      <footer class="copyright_signup pb-3 px-3 text-center">
        <p class="mb-0">Copyright © 2023 @if(isset($companyData->name)){{ $companyData->name }}@else{{'COMPANY NAME PUT HERE'}}@endif. All right reserved.</p>
      </footer>

  </div>
  <!--end wrapper-->


  <!--plugins-->
  <script type="text/javascript" src="{{ asset('admin/js/jquery.min.js')}}"></script>
  <script type="text/javascript" src="{{ asset('admin/js/pace.min.js')}}"></script>


</body>

</html>