<!doctype html>
<html lang="en" class="minimal-theme">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <!-- Bootstrap CSS -->
  <link href="{{asset('admin/css/bootstrap.min.css')}}" type="text/css" rel="stylesheet" />
  <link href="{{asset('admin/css/bootstrap-extended.css')}}" type="text/css" rel="stylesheet" />
  <link href="{{asset('admin/css/style.css')}}" type="text/css" rel="stylesheet" />
  <link href="{{asset('admin/css/icons.css')}}" type="text/css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
  <!-- loader-->
	<link href="{{asset('admin/css/pace.min.css')}}" rel="stylesheet" />
  <!-- Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
  <!-- Favicon.io -->
  <link rel="icon" href="asset/admin/mages/favicon.ico" type="image/png" />
  <!-- Meta Taggs -->
  <title>Login &#8212; @if(isset($companyData->name)){{$companyData->name}}@else{{'website_title_here'}}@endif</title>
  <meta name="author" content="SignIn &#8212; #website_title_here">
  <meta name="description" content="#website_meta_description_here">
  <meta name="keywords" content="#website_meta_keywords_here">

   <link href="{{ asset('admin/css/toastr.min.css')}}" rel="stylesheet" type="text/css">
   <link href="{{ asset('admin/css/sweetalert2.min.css')}}" rel="stylesheet" type="text/css">
   <script type="text/javascript" src="{{ asset('admin/js/jquery3.3.1.min.js')}}"></script>


   <script type="text/javascript" src="{{ asset('admin/js/parsley.min.js')}}"></script>
   <script type="text/javascript" src="{{ asset('admin/js/toastr.min.js')}}"></script>
   <script type="text/javascript" src="{{ asset('admin/js/sweetalert2.all.min.js')}}"></script>
   <style type="text/css">
    .social-icons {
        display: flex;
        justify-content: space-around;
    }
    .social-icon .bi {
          font-size: 19px;
          color: black;
          /* font: -webkit-control; */
      }
   </style>
</head>

<body>
  <!--start wrapper-->
  <div class="wrapper">
       <!--start content-->
       <main class="authentication-content">
        <div class="container-fluid">
          <div class="authentication-card">
            <div class="card bg-transparent shadow-none rounded-0 overflow-hidden">
              <div class="row align-items-center justify-content-center g-0">
                <!-- <div class="col-lg-7 d-flex align-items-center justify-content-center">
                  <img src="asset/iadmin/mages/login-img.svg" loading="lazy" class="img-fluid" alt="login image">
                </div> -->

                <div class="col-lg-6">
                  <div class="card-body bg-white rounded singin_card">
                    <!-- <h5 class="card-title">Sign In</h5>
                    <p class="card-text mb-3">See your growth and get consulting support!</p> -->
                    <img class="img-fluid d-block w-75 mx-auto"
                    src="@if(isset($companyData->getCompanyImage->image_url) && $companyData->getCompanyImage->image_url != '')
                        {{ getTempUrl($companyData->getCompanyImage->image_url) }}
                    @else{{ 'https://metaminthealth.s3.ap-south-1.amazonaws.com/metamintassets/images/meta_mint_blue_small_logo.png' }}
                    @endif"
                    loading="lazy" style="height:auto" alt="logo">

                    @include('auth.flash-message')
                    <form class="form-body" class="user" action="{{ url('login') }}" method="POST">
                      @csrf
                      <div class="login-separater text-center mb-4"> <span> @if(isset($companyData->name)){{ $companyData->name }}@else{{'COMPANY NAME PUT HERE'}}@endif</span>
                        <hr>
                      </div>
                        <div class="row g-3">
                          <div class="col-12">
                            <label for="inputEmailAddress" class="form-label">Email Address</label>
                            <div class="ms-auto position-relative">
                              <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-envelope-fill"></i></div>
                              <input type="email" name="email" class="form-control ps-5" id="inputEmailAddress" placeholder="Email Address" required>
                            </div>
                          </div>
                          <div class="col-12">
                            <label for="inputChoosePassword" class="form-label">Enter Password</label>
                            <div class="ms-auto position-relative">
                              <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-lock-fill"></i></div>
                              <input type="password" name="password" class="form-control ps-5" id="inputChoosePassword" placeholder="Enter Password" required>
                            </div>
                          </div>


                          <div class="col-12">
                            <div class="d-grid">
                              <button type="button" class="btn btn-primary radius-30 submit_button" id="submit_button">SIGN IN<i class="bx bx-log-in-circle"></i></button>
                            </div>
                          </div>
                          <div class="col-6">
                            {{-- <div class="form-check form-switch ps-0">
                              <input class="form-check-input me-2" type="checkbox" id="flexSwitchCheckChecked">
                              <label class="form-check-label" for="flexSwitchCheckChecked">Remember Me</label>
                            </div> --}}
                          </div>
                          <div class="col-6 text-end">  <a href="{{ route('forget.password.get') }}">Forgot Password?</a>
                          </div>
                          <div class="col-12 social-icons">
                            <div style="display: block;text-align:center;font-weight:500;font-size:12px;">
        Design &amp; Hosted By: <a style="color:#473bf0;" href="https://metamintindia.com/" target="_blank">Meta Mint Private Limited</a><br>
      </div>
                          </div>
                          <div class="col-2"></div>
                          <div class="col-8" style="text-align: center">
                            <div class="social-icons">
                              <a href="https://m.facebook.com/metamint.in/" target="_blank" class="social-icon" title="Facebook"><i class="bi bi-facebook"></i></a>
                              <a href="https://www.twitter.com" target="_blank" class="social-icon" title="Twitter"><i class="bi bi-twitter"></i></a>
                              <a href="https://www.instagram.com" target="_blank" class="social-icon" title="Instagram"><i class="bi bi-instagram"></i></a>
                              <a href="https://wa.me/919366744376" target="_blank" class="social-icon" title="Whatsapp"><i class="bi bi-whatsapp"></i></a>
                              <a href="https://www.youtube.com/@metamintindia" target="_blank" class="social-icon" title="Youtube"><i class="bi bi-youtube"></i></a>
                              <a href="https://in.linkedin.com/company/metamintindia" target="_blank" class="social-icon" title="Linkedin"><i class="bi bi-linkedin"></i></a>
                            </div>
                            {{-- <p>Don't have an account? <a href="{{route('client-register')}}"> Sign up</a></p> --}}
                          </div>
                          <div class="col-2"></div>
                          <!-- <div class="col-12">
                            <p class="mb-0">Don't have an account yet? <a href="authentication-signup.html">Sign up here</a></p>
                          </div> -->
                        </div>
                    </form>
                 </div>
                </div>
              </div>
            </div>
          </div>
        </div>
       </main>
       <!--end page main-->

      <footer class="copyright_signup pb-3 px-3 text-center">
        <p class="mb-0">Copyright © {!! date('Y') !!}  @if(isset($companyData->name)){{ $companyData->name }}@else{{'COMPANY NAME PUT HERE'}}@endif. All right reserved.</p>
      </footer>

  </div>
  <!--end wrapper-->


  <!--plugins-->
  <script type="text/javascript" src="{{ asset('admin/js/jquery.min.js')}}"></script>
  <script type="text/javascript" src="{{ asset('admin/js/pace.min.js')}}"></script>
  <script type="text/javascript">
    $(document).on('click', '.submit_button', function(e) {
        e.preventDefault();
        $('#submit_button').removeClass('submit_button');
        let formdata = new FormData($('.user')[0]);
        formdata.append('email', $('[name="email"]').val());
        formdata.append('password', $('[name="password"]').val());

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: "{{ url('login') }}",
            data: formdata,
            processData: false,
            contentType: false,
            type: 'POST',
            success: function (response) {
                if (response.success === true) {
                        toastr.success(response.message, 'Success.');
                        setTimeout(window.location.href = "{!! route('admin.dashboard') !!}", 3000);
                } else {
                    $('#submit_button').addClass('submit_button');
                    toastr.error(response.message, 'Error!');
                }

            }
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            $('#submit_button').addClass('submit_button');
            console.log('AJAX request failed:', textStatus, errorThrown);
            toastr.error('An error occurred during the request.', 'Error!');
        });
    });

    var email = document.getElementById("inputEmailAddress");
    var pass = document.getElementById("inputChoosePassword");

    email.addEventListener("keypress", function(event) {
      if (event.key === "Enter") {
        event.preventDefault();
        document.getElementById("submit_button").click();
      }
    });

    pass.addEventListener("keypress", function(event) {
      if (event.key === "Enter") {
        event.preventDefault();
        document.getElementById("submit_button").click();
      }
    });
  </script>

</body>

</html>
