<style>
    .add_btn {
        height: 30px;
        width: 30px;
    }
</style>
<form class="row g-3 auto-width" action="{{ route('beds.store') }}" method="post" enctype='multipart/form-data'
    id="source_form">
    @csrf
    <div class="col-md-6">
        <label for="name" class="form-label">Bed Number <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" placeholder="Example- F101,VIP102" required autocomplete="off">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    {{-- Room Number --}}
    <div class="col-md-6">
        <div>
            <label for="room" class="form-label">Building <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="building_id">
                @foreach ($buildings as $list)
                    <option value="{{ $list->id }}" {!! $list->default==1?'selected':'' !!}>{{ $list->name }} </option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_building" style="display: none;">This field is required.</span>
    </div>
   
    <div class="col-md-6">
        <div>
            <label for="floor" class="form-label">Floor <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="floor_id">
                <option value="">Select Floor</option>
                @foreach ($floors as $list)
                    <option value="{{ $list->id }}">{{ $list->name }} </option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_floor" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <div>
            <label for="room" class="form-label">Room Number & Name<span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="room_id">
                <option value="">Select Room Number</option>
            </select>

            @if (in_array('room-create', $authRolePermissions))
                <div class="input-group-append" style="margin: auto 10px;">
                    <button class="btn btn-success add_btn" id="create_room" type="button"> + </button>
                </div>
            @endif
        </div>
        <span class="text-danger error_room" style="display: none;">This field is required.</span>
    </div>
   
     {{-- Bed Group --}}
     <div class="col-md-12">
        <div>
            <label for="bed_group_id" class="form-label">Bed Group <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="bed_group_id">
                @foreach ($bed_group as $list)
                    <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>

 
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_bed_group" type="button"> + </button>
            </div>
        
        </div>
        <span class="text-danger error_bed_group_id" style="display: none;">This field is required.</span>
    </div>
    {{-- Bed Type --}}
    <div class="col-md-6">
        <div>
            <label for="bed_type_id" class="form-label">Bed Type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="bed_type_id">
                @foreach ($bed_type as $list)
                    <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
        
            <div class="input-group-append" style="margin: auto 10px;">
                <button class="btn btn-success add_btn" id="create_bed_type" type="button"> + </button>
            </div>
           
        </div>
        <span class="text-danger error_bed_type_id" style="display: none;">This field is required.</span>
    </div>


     {{-- <div class="col-md-6">
        <label for="name" class="form-label">Room Name & Number </label>
        <input type="text" class="form-control" id="room" name="room" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_room" style="display:none;">This field is required.</span>
    </div> --}}
    {{-- Priority --}}
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority </label>
        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    {{-- Note --}}
    <div class="col-md-12">
        <label for="note" class="form-label">Note</label>
        <input type="text" class="form-control" name="note" aria-describedby="inputGroupPrepend">
    </div>
</form>
<script>
    $('select[name="floor_id"]').on('change', function() {
        var floor_id = $(this).val();
        var building_id = $('select[name="building_id"]').val();
        if (floor_id) {
            $.ajax({
                url: '{{ route("getRoom") }}',
                type: "GET",
                data: {
                    floor_id: floor_id,
                    building_id:building_id
                },
                dataType: "json",
                success: function(data) {
                    $('select[name="room_id"]').empty();
                    $('select[name="room_id"]').append('<option value=" ">Select Room Number</option>');
                    $.each(data, function(key, value) {
                        $('select[name="room_id"]').append('<option value="' + value.id + '">Room No: '+ value.room_number +' - ('+ value.name +')</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            // If no transaction mode is selected, clear payment mode dropdown
            $('select[name="room_id"]').empty();
        }
    });
</script>
