<form class="row g-3 auto-width" action="{{ route('beds.update', $bed->id)}}" method="post" enctype='multipart/form-data' id="source_form">
    @csrf
    @method("PATCH")
    {{-- Room Number --}}
    <div class="col-md-6">
        <div>
            <label for="room" class="form-label">Building <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="building_id">
                @foreach ($buildings as $list)
                    <option value="{{ $list->id }}" {!! $list->id==$bed->building_id?'selected':'' !!}>{{ $list->name }} </option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_building" style="display: none;">This field is required.</span>
    </div>
        {{-- Bed Number --}}
    <div class="col-md-6">
        <label for="name" class="form-label">Bed Number <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend" required value="{{$bed->name}}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <div>
            <label for="floor" class="form-label">Floor <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="floor_id">
                <option value="">Select Floor</option>
                @foreach ($floors as $list)
                    <option value="{{ $list->id }}" {!! $list->id==$bed->floor_id?'selected':'' !!}>{{ $list->name }} </option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_floor" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-6">
      <label for="validationCustom01" class="form-label">Room Number & Name  <span class="text-danger"><b>*</b></span></label>
      <select class="form-control" name="room_id">
          @foreach ($room as $list)
              <option value="{{ $list->id }}" {{ $list->id == $bed->room_id ? 'selected':'' }}>Room No:{{ $list->room_number }} - ({{ $list->room_name }}) </option>
          @endforeach
      </select>
      <span class="text-danger error_room_id" style="display:none;">This field is required.</span>
  </div>
     

    {{-- Bed Group --}}
    <div class="col-md-12">
        <div>
            <label for="bed_group_id" class="form-label">Bed Group <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="bed_group_id">
                @foreach ($bed_group as $list)
                    <option value="{{ $list->id }}" {{ $list->id == $bed->bed_group_id ? 'selected' : '' }}>
                        {{ $list->name }}
                @endforeach
            </select>
        </div>
        <span class="text-danger error_bed_group_id" style="display: none;">This field is required.</span>
    </div>
       {{-- Bed Type --}}
       <div class="col-md-6">
        <div>
            <label for="bed_type_id" class="form-label">Bed Type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="bed_type_id">
                @foreach ($bed_type as $list)
                <option value="{{ $list->id }}" {{ $list->id == $bed->bed_type_id ? 'selected' : '' }}>
                    {{ $list->name }}
                @endforeach
            </select>
        </div>
        <span class="text-danger error_bed_type_id" style="display: none;">This field is required.</span>
    </div>

     {{-- Account --}}
     {{-- <div class="col-md-6">
        <div>
            <label class="form-label">Waiting Patient <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="patient_id" class="patient-select form-control" placeholder="Search Patient" value="{!! $patient->full_name ?? '' !!}">
            <ul class="searchResult"></ul> --}}
            {{-- <div class="input-group-append" style="margin: auto 10px auto 0;">
                <button class="btn btn-secondary add_btn" id="create_patient" type="button" data-bs-toggle="modal" data-bs-target="#commonModal">+</button>
                <button class="btn btn-primary" style="height: 40px;" id="edit_patient" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-pencil-square"></i></button>
            </div> --}}
            {{-- <input type="hidden" name="patient_id" value="{!! $patient->id ?? '' !!}">
        </div>
        <span class="text-danger error_patient_id" style="display:none;">This field is required.</span>
    </div> --}}

    {{-- Priority --}}
    <div class="col-md-6">
        <label for="priority" class="form-label">Priority </label>
        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $bed->priority !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>
    {{-- Note --}}
    <div class="col-md-12">
        <label for="note" class="form-label">Note</label>
        <input type="text" class="form-control" name="note" value="{{ $bed->note }}" aria-describedby="inputGroupPrepend">
    </div>
</form>
<script>
    $('select[name="floor_id"]').on('change', function() {
        var floor_id = $(this).val();
        var building_id = $('select[name="building_id"]').val();
        if (floor_id) {
            $.ajax({
                url: '{{ route("getRoom") }}',
                type: "GET",
                data: {
                    floor_id: floor_id,
                    building_id:building_id
                },
                dataType: "json",
                success: function(data) {
                    $('select[name="room_id"]').empty();
                    $('select[name="room_id"]').append('<option value=" ">Select Room Number</option>');
                    $.each(data, function(key, value) {
                        $('select[name="room_id"]').append('<option value="' + value.id + '">Room No: '+ value.room_number +' - ('+ value.name +')</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            // If no transaction mode is selected, clear payment mode dropdown
            $('select[name="room_id"]').empty();
        }
    });
</script>
