<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-2" style="width: 20%">
                <p>Date: {!! formatedDate(date('Y-m-d')) !!}</p>
            </div>
            <div class="col-7" style="text-align: center;">
                <p style="color:#0b5ed7;font-size:18px;margin-bottom: -4px !important"><b>{!! $company->name ?? '' !!}</b></p>
                <p style="font-size: 14px;"><b>Bed History STATEMENT</b></p>
                <p style="padding-bottom: 5px;font-size: 11px;"><b><span style="color: #698aff;">Statement</span> List</b>
                    <b>From <span style="color:#698aff;" id="">{{ $fromDate ? formatedDate($fromDate) : formatedDate(date('Y-m-d H:i:s')) }}</span> TO <span style="color:#698aff;" id="">{{ $toDate ? formatedDate($toDate) : formatedDate(date('Y-m-d H:i:s')) }}</span>
                    </b></p>
            </div>
            <div class="col-2" style="text-align: right; width:20%">
                <p>Time: {!! formatedTime(date('H:i:s')) !!}</p>
            </div>
        </div>

        <div>
            <table class="table table-borderless report-container">
                <tbody class="report-content">
                    <tr>
                        <td class="report-content-cell">
                            <div class="row">
                                <div class="col-12">
                                    <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                        <thead>
                                            <tr class="text-uppercase">
                                                <th class="thbutton">Sl No</th>
                                                <th style="text-align: center;">Bed No</th>
                                                <th style="text-align: center;">Check-In Date</th>
                                                <th style="text-align: center;">Bed Group</th>
                                                <th style="text-align: center;">Bed Type</th>
                                                <th style="text-align: center;">Revert Reason</th>
                                                <th style="text-align: center;">Check-out Date</th>
                                                <th style="text-align: center;">Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                    @php $i = 1; @endphp
                    @foreach($bedsinfo as $list)
                        <tr>
                            <td class="text-center">{{ $i }}</td>
                            <td style="text-align: center;">{{ $list->bed_name != 0 ? $list->bed_name : '' }}</td>
                            <td style="text-align: center;">{{ $list->check_in_date_time != 0 ? $list->check_in_date_time : '-' }}</td>  
                            <td style="text-align: center;">{{ $list->bed_group_name != 0 ? $list->bed_group_name : '' }}</td> 
                            <td style="text-align: center;">{{ $list->bed_type != 0 ? $list->bed_type : '' }}</td> 
                            <td style="text-align: center;">{{ $list->revert_reason != 0 ? $list->revert_reason : 'N/A' }}</td> 
                            <td style="text-align: center;">{{ $list->check_out_date_time != 0 ? $list->check_out_date_time : '-' }}</td> 
                            @if($list->bed_status == 1)
                            <td style="text-align: center;"> Available
                            </td>
                            @else
                            <td style="text-align: center;">  Booked
                            @endif
                        </tr>
 
                        
                        @php $i++; @endphp
                    @endforeach
                    @if(count($bedsinfo) === 0)
                        <tr>
                            <td colspan="17" class="text-center">No Data Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

@if(count($bedsinfo) > 0)
    <div class="row mt-3">
        <div class="col-md-12" style="text-align: center;">
            <button id="btn_print" type="button" class="btn btn-primary btn-lg mx-1"><i class="bi bi-printer text-white"></i> Print Statement </button>
            <button class="btn btn-outline-primary export-statement mx-1" id="export-statement"><i class="bi bi-download"></i> Export</button>
        </div>
    </div>
@endif
