@extends('layouts.app')
@section('title', 'Bed History Statement')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
        border-right: none;
    }

    .thbutton {
        width: 7% !important;
    }
</style>

@php
$pageTitle = "Bed History Statement";
@endphp

<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link href="{{ asset('admin/css/print.css') }}" rel="stylesheet" />

<!-- Breadcrumb -->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Bed History Statement</div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{ route('ipd-admissions.index') }}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!-- End Breadcrumb -->

<div class="card shadow-none radius-5 min-height">
    <div class="card-header py-3">
        @include('layouts.partials.nav-menu')
        <div class="row gx-2 custom_grid align-items-end gx-0">
            <div class="col-lg-3 col-md-3 col-3 mb-3">
                <div class="input-group">
                    <label class="form-label">From Date <span class="text-danger"><b></b></span></label>
                    <input class="form-control" type="text" id="from_date" name="from_date" placeholder="dd/mm/YY" value="">
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-3 mb-3">
                <div class="input-group">
                    <label class="form-label">To Date <span class="text-danger"><b></b></span></label>
                    <input class="form-control" type="text" id="to_date" name="to_date" placeholder="dd/mm/YY" value="">
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-3 mb-3">
                <div class="input-group references">
                    <label class="form-label">Search Bed <span class="text-danger"><b></b></span></label>
                    <input type="text" name="search_bed" id="search_bed" class="form-control" placeholder="Search Bed">
                </div>
            </div>

            <div class="col-lg-3 col-md-3 col-3 mb-3" id="example_length"> 
                <div class="input-group references">
                   <label class="form-label">Search Bed Status<span class="text-danger"><b></b></span></label>
                    <select class="form-select" id="search_bed_status" name="search_bed_status" aria-controls="example">
                      <option value="">Bed Status</option>
                      <option value="booked">Booked</option>
                      <option value="available">Available</option>
                    </select>
                </div>
            </div>


            <div class="col-lg-3 col-md-3 col-3 mb-3" id="example_length"> 
                <div class="input-group references">
                   <label class="form-label">Search Bed Groups<span class="text-danger"><b></b></span></label>
                    <select class="form-select" id="search_bed_group" name="search_bed_group" aria-controls="example">
                      <option value="">Bed Groups</option>
                      @foreach($bed_groups as $bed_group)
                      <option value="{{$bed_group->id}}">{{$bed_group->name}}</option>
                      @endforeach
                    </select>
                </div>
            </div>



            <div class="col-lg-3 col-md-3 col-3 mb-3" id="example_length"> 
                <div class="input-group references">
                   <label class="form-label">Search Bed Types<span class="text-danger"><b></b></span></label>
                    <select class="form-select" id="search_bed_type" name="search_bed_type" aria-controls="example">
                      <option value="">Bed Types</option>
                      @foreach($bed_types as $bed_type)
                      <option value="{{$bed_type->id}}">{{$bed_type->name}}</option>
                      @endforeach
                    </select>
                </div>
            </div>
            

        </div>
        <div class="row mt-2">
            <div class="col-lg-12 col-md-12 col-12 text-center">
                <button class="btn btn-primary" id="submit" type="button" style="height: 40px; width: 25% !important;"><i class="bi bi-search"></i> Search</button>
            </div>
        </div>
        <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
        <hr>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12" id="tables"></div>
            </div>
        </div>
    </div>
    <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
    <script>
        $('[name="from_date"]').datepicker({
            format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
            autoclose: true,
        }).datepicker("setDate", new Date());

        $('[name="to_date"]').datepicker({
            format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
            autoclose: true,
        }).datepicker("setDate", new Date());

        $(document).ready(function() {
            function clear_icon() {
                $('#id_icon').html('');
                $('#post_title_icon').html('');
            }

            function fetch_data(from_date, to_date, search_bed , search_bed_status , search_bed_group , search_bed_type) {
                $.ajax({
                    url: "?from_date=" + from_date + "&to_date=" + to_date + "&search_bed=" + search_bed + "&search_bed_status=" + search_bed_status + "&search_bed_group=" + search_bed_group + "&search_bed_type=" + search_bed_type,
                    success: function(data) {
                        $('#tables').html(data);
                        $('#example').dataTable({
                            paging: false,
                            searching: false,
                            info: false
                        });
                    }
                });
            }

            $("body").on("click", '#submit', function(event) {
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                var search_bed = $('#search_bed').val();
                var search_bed_status = $('#search_bed_status').val();
                var search_bed_group = $('#search_bed_group').val();
                var search_bed_type = $('#search_bed_type').val();
                fetch_data(from_date, to_date, search_bed ,search_bed_status , search_bed_group , search_bed_type);
            });

            $("body").on("click", '.export-statement', function(event) {
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                var search_bed = $('#search_bed').val();
                var search_bed_status = $('#search_bed_status').val();
                var search_bed_group = $('#search_bed_group').val();
                var search_bed_type = $('#search_bed_type').val();

                var url = "?from_date=" + from_date + "&to_date=" + to_date + "&search_bed=" + search_bed  + "&search_bed_status=" + search_bed_status
                 + "&search_bed_group=" + search_bed_group  + "&search_bed_type=" + search_bed_type;
                window.location.href = "{!! route('beds-history-reports-export') !!}?" + url;
            });
        });
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
    <script>
        $(document).ready(function() {
            $("title").html($('#page_title').val());
            $(document).on('click', '#btn_print', function(event) {
                event.preventDefault();
                $('#btn_back').hide();
                printInvoice();
                $(this).hide();
                var printContents = document.getElementById('print_div').innerHTML;
                var originalContents = document.body.innerHTML;

                document.body.innerHTML = printContents;
                window.print();
                document.body.innerHTML = originalContents;

                $(this).show();
                $('#btn_back').show();
            });

            $(document).on('click', '#btn_pdf', function(e) {
                html2canvas($('#print_div'), {
                    background: "#ffffff",
                    onrendered: function(canvas) {
                        var myImage = canvas.toDataURL("image/png", 1.0);
                        var imgWidth = (canvas.width * 43) / 250;
                        var imgHeight = (canvas.height * 48) / 250;
                        var pdf = new jsPDF('p', 'mm', 'a4');
                        pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight);
                        pdf.save($('#page_title').val() + '.pdf');
                    }
                });
            });
        });

        function printInvoice() {
            let printDiv = $('#print_div').html();
            let content = window.open('', '', 'height=750px,width=960px');
            let doc = content.document;
            let head = doc.head;
            let body = doc.body;

            $(head).append('<title>{{ $pageTitle }}</title>');
            $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
            $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
            $(head).append('<style>@page { size: auto; }</style>');
            $(body).append(printDiv);

            setTimeout(function() {
                content.print();
            }, 500);
        }
    </script>
@endsection
