<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Bed Number</th>
                <th class="thbutton">Status</th>
                <th>Room No, Ward Name  </th>
                <th class="text-center">Building</th>
                <th class="thbutton">Bed Status</th>
                <th class="thbutton">IPD No</th>
                <th>Bed Group & Type</th>
                <th>Note</th>
                <th class="thbutton">Waiting IPD</th>
                
                @if(in_array('beds-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('beds-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                <tr>
                    <td class="text-center">{{$data->firstItem() + $key}}</td>
                    <td style="font-size: 20px;"><b>{{ strtoupper($list->name) }}</b> </td>
                    <td>
                        {!!($list->bed_available == 1) ? '<span class="badge badge-pill bg-success text-white">Available</span>' : '<span class="badge badge-pill bg-danger text-white">Booked</span>'!!}
                    </td>
                    <td> <b>{{$list->getRoom->room_number ?? ''}}</b> - ({{ $list->getRoom->room_name ?? ''}})<br>
                        <span class="text-end">{{$list->getFloor->name ?? ''}}</span>
                    </td>
                    <td class="text-center">{{$list->getBuilding->name ?? ''}} </td>
              
                    <!-- <td class="thbutton">{{($list->bed_available == 1) ? 'Yes' : 'No'}}</td> -->
                   
                    <td>
                        {{ $list->getIpdAdmission->ipd_admission_no ?? 'N/A' }}
                    </td>
                    <td>{{$list->getBedGroup->name ?? ''}} @if(isset($list->getBedType->name))<br> - {{$list->getBedType->name}} ({{@$list->getBedType->getProductPrice->sale_price}}) @endif</td>
                    <td class="thbutton">{{$list->note ?? 'N/A'}}</td>
                    <td>
                        @if ($list->waiting_ipd_admission_id == 0)
                        @else
                            {{ $list->waiting_ipd_admission_id }}
                        @endif
                    </td>
                        {{-- <div class="form-check form-check-inline{{ $i }}">
                            <input class="form-check-input{{ $i }} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{ $i }}" data-url="{{ route('waiting-patient.status') }}" data-id="{{ $list->id }}" data-status="{{ $list->waiting_ipd_admission_id == '0' ? '1' : '0' }}" {{ $list->waiting_ipd_admission_id == '1' ? 'checked' : '' }}>
                        </div> --}}
                    </td>
                    <td class="text-center">
                        <div class="form-check form-check-inline{{ $i }}">
                            <input class="form-check-input{{ $i }} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{ $i }}" data-url="{{ route('beds.changestatus') }}" data-id="{{ $list->id }}" data-status="{{ $list->status == '0' ? '1' : '0' }}" {{ $list->status == '1' ? 'checked' : '' }}>
                        </div>
                    </td>
                    @if(in_array('beds-edit', $authRolePermissions))
                    <td class="text-center">
                        <button data-id="{{ $list->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                            <i class="bi bi-pencil-square"></i>
                        </button>
                    </td>
                    @endif
                    @if(in_array('beds-delete', $authRolePermissions))
                    <td class="text-center">
                        <a data-url="{{route('beds.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                            <i class="bi bi-trash text-white"></i>
                        </a>
                    </td>
                    @endif
                </tr>
                @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="7">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="row mt-2">
    <div class="col-lg-8 col-md-8 col-8 float-start">
            {!! $data->onEachSide(0)->render('beds.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
    <div class="col-lg-2 col-md-2 col-2" style="text-align: right;">
        <div class="btn-group mb-0">
            <a class="btn btn-outline-primary" style="margin-right: 16px;" href="{!! route('beds-import.view') !!}"><i style="margin-right: 5px;" class="bi bi-cloud-download"></i>Bulk Import</a>
        </div>
    </div>
</nav>


</div>
