<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-2" style="width: 20%">
                <p>Date: {!! formatedDate(date('Y-m-d')) !!}</p>
            </div>
            <div class="col-7" style="text-align: center;">
                <p style="color:#0b5ed7;font-size:18px;margin-bottom: -4px !important"><b>{!! $company->name ?? '' !!}</b></p>
                <p style="font-size: 14px;"><b>BIRTH REGISTER STATEMENT</b></p>
                <p style="padding-bottom: 5px;font-size: 11px;"><b><span style="color: #698aff;">Billing</span> List</b>
                    <b>From <span style="color:#698aff;" id="">{{ $fromDate ? formatedDate($fromDate) : formatedDate(date('Y-m-d H:i:s')) }}</span> TO <span style="color:#698aff;" id="">{{ $toDate ? formatedDate($toDate) : formatedDate(date('Y-m-d H:i:s')) }}</span>
                    </b></p>
            </div>
            <div class="col-2" style="text-align: right; width:20%">
                <p>Time: {{ formatedTime(date('H:i:s')) }}</p>
            </div>
        </div>

        <div>
            <table class="table table-borderless report-container">
                <tbody class="report-content">
                    <tr>
                        <td class="report-content-cell">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                        <thead>
                                            <tr class="text-uppercase">
                                                <th class="thbutton">Sl No</th>
                                                <th style="text-align: left;">Case id</th>
                                                <th style="text-align: left;">Child Name</th>
                                                <th style="text-align: left;">gender</th>
                                                <th style="text-align: left;">Birth Date</th>
                                                <th style="text-align: left;">Mother Name</th>
                                                <th style="text-align: left;">Father Name</th>
                                                <th style="text-align: left;">Report</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                    @php $i = 1; @endphp
                    @foreach($birth_registers as $list)
                        <tr>
                            <td class="text-center">{{ $i }}</td>
                            <td style="text-align: left;">{{ $list->case_id ? $list->case_id : 'N/A' }}</td> 
                            <td style="text-align: left;">{{ $list->child_name ? $list->child_name : 'N/A' }}</td> 
                            <td style="text-align: left;">{{ $list->gender_name ? $list->gender_name : 'N/A' }}</td> 
                            <td style="text-align: left;">{{ formatedDate($list->birth_date) }}</td>
                            <td style="text-align: left;">{{ $list->mother_name ? $list->mother_name : 'N/A' }}</td> 
                            <td style="text-align: left;">{{ $list->father_name ? $list->father_name : 'N/A' }}</td> 
                            <td style="text-align: left;">{{ $list->birth_report ? $list->birth_report : 'N/A' }}</td> 
                        </tr>
                        @php $i++; @endphp
                    @endforeach
                    @if(count($birth_registers) === 0)
                        <tr>
                            <td colspan="17" class="text-center">No Data Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

@if(count($birth_registers) > 0)
    <div class="row">
        <div class="col-md-12" style="text-align: center;">
            <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Statement </button>
            <button class="btn btn-outline-primary export-statement" id="export-statement"><i class="bi bi-download"></i> Export</button>
        </div>
    </div>
@endif
