<form class="row g-3 auto-width" action="{{ route('item-update', $item->id)}}" method="post" enctype='multipart/form-data'>
        @csrf
        <input type="hidden" name="tax_paid_by" value="{{$item->quantity}}">
        <div class="col-md-6">
            <label for="item_qty" class="form-label">Item Quantity</label>
            <input type="text" class="form-control" id="item_qty" name="item_qty" aria-describedby="inputGroupPrepend" required value="{{$item->quantity}}">
            <span class="text-danger error_code" style="display:none;">This field is required.</span>
        </div>
        <div class="col-md-6">
             <label for="rate_calculation_types" class="form-label">Rate Calculation Type<span class="text-danger"><b>*</b></span></label>
                <div class="input-group">
                    <select name="rate_calculation_types" id="rate_calculation_types" class="form-control">
                        @foreach($rate_calculations as $calculation)
                        <option value="{{$calculation->id}}" {{ $item->rate_calculation_on == $calculation->id ? 'selected' : '' }}>{{$calculation->name}}</option>
                        @endforeach
                  </select>
                </div>
        </div>
        <div class="col-md-6">
            <label for="actual_weight" class="form-label">Actual Weight </label>
                    <div class="input-group">
                        <input type="number" name="actual_weight" id="actual_weight"  class="form-control br-0"  placeholder="Actual Weight " value="{{$item->actual_weight}}">
                    </div>
        </div>
        <div class="col-md-6">
            <label for="gross_weight" class="form-label">Gross Weight<span class="text-danger"><b>*</b></span></label>
                    <div class="input-group">
                        <input type="number" name="gross_weight" id="gross_weight"  class="form-control br-0"  placeholder="Gross Weight" value="{{$item->gross_weight}}">
                    </div>
        </div>
        <div class="col-md-6">
            <label for="weight_type" class="form-label">Weight type<span class="text-danger"><b>*</b></span></label>
                    <div class="input-group">
                        <select name="weight_type" id="weight_type" class="form-control">
                            @foreach($weights as $list)
                            <option value="{{$list->id}}"  {{ $item->weight_type_id == $list->id ? 'selected' : '' }}>{{$list->name}}</option>
                            @endforeach
                        </select>
                    </div>
        </div>
        <div class="col-md-6">
      <label for="product_price" class="form-label">Freight/Rate<span class="text-danger"><b>*</b></span></label>
                <div class="input-group">
                   <input type="number" name="product_price" id="product_price" class="form-control br-0"  placeholder=" Product Price" value="{{$item->rate}}">
                </div>
        </div>
         <div class="col-md-6 distance_columns"  style="display:none;">
                <label for="product_price" class="form-label">Distance<span class="text-danger"><b>*</b></span></label>
                <div class="input-group">
                   <input type="number" name="distance" id="distance" class="form-control br-0"  placeholder=" Enter Distance in Kilometer"  value="{{$item->distance}}"> 
                </div>
            </div> 
            <div class="col-md-6 hour_columns"style="display:none;">
                <label for="product_price" class="form-label">Hour<span class="text-danger"><b>*</b></span></label>
                <div class="input-group">
                   <input type="number" name="hours" id="hours" class="form-control br-0"  placeholder=" Enter Time in hours"  value="{{$item->hours}}">  
                </div>
            </div> 
            <div class="col-md-12 volumetric_columns"  style="display:none;">
                <label for="product_price" class="form-label">Volumetric Weight<span class="text-danger"><b>*</b></span></label>
                <div class="input-group input-group-sm">
                    <div class="">
                        <span class="input-group-text " style="height: 100%;">L</span>
                    </div>
                    <input type="text" class="form-control form-control-sm volumetric_calculation"  value="{{$item->length}}" placeholder="Length" name="length" id="length">
                    <div class="input-group-prepend">
                        <span class="input-group-text border-left-0 " style="height: 100%;">B</span>
                    </div>
                    <input type="text" class="form-control form-control-sm volumetric_calculation"   value="{{$item->breadth}}" placeholder="Breadth" name="breadth" id="breadth">
                    <div class="input-group-prepend">
                        <span class="input-group-text border-left-0" style="height: 100%;">H</span>
                    </div>
                    <input type="text" class="form-control form-control-sm volumetric_calculation"   value="{{$item->height}}"placeholder="Height" name="height" id="height">
                </div>
            </div> 
            <div class="col-md-6 vehicle_columns" style="display:none;">
                <label for="vehicle_type" class="form-label">Vehicle Type<span class="text-danger"><b>*</b></span></label>
               <div class="input-group">
                    <select name="vehicle_type" id="vehicle_type" class="form-control">
                        <option value="">--Select--</option>
                        @foreach($vehicles as $vehicle)
                        <option value="{{$vehicle->name}}" >{{$vehicle->name}}</option>
                        @endforeach
                  </select>
                </div>
            </div>
</form>
<script type="text/javascript">
    $( document ).ready(function() {
         rate_calculation_type();
      $("#priority").on('input', function() {
          const onlyNumbers = $(this).val().replace(/[^0-9]/g, '');
          $("#priority").val(onlyNumbers);
      });

      function rate_calculation_type() {
          var selectedOption = $('#rate_calculation_types').find('option:selected');
            // if (selectedOption.text() === 'Option 2') {

        if (selectedOption.text() === 'Distance') {
        $('.distance_columns').show();
        $('.hour_columns').hide() ;
        $('.volumetric_columns').hide() ;
        $('.vehicle_columns').hide() ;
        }else if(selectedOption.text() === 'Hours'){
            $('.distance_columns').hide();
            $('.hour_columns').show() ;
            $('.volumetric_columns').hide() ;
            $('.vehicle_columns').hide() ;
        }else if(selectedOption.text() === 'Volumetric Weight'){
            $('.distance_columns').hide();
            $('.hour_columns').hide() ;
            $('.volumetric_columns').show() ;
            $('.vehicle_columns').hide() ;
        }else if (selectedOption.text() === 'Vehicle Type'){
            $('.distance_columns').hide();
            $('.hour_columns').hide() ;
            $('.volumetric_columns').hide() ;
            $('.vehicle_columns').show() ;
        }
        else{
            $('.distance_columns').hide();
            $('.hour_columns').hide() ;
            $('.volumetric_columns').hide() ;
            $('.vehicle_columns').hide() ;
        }
      }

      $(document).on('input', '#rate_calculation_types', function(event){
         rate_calculation_type();
     })
});
    
</script>
