@extends('layouts.app')
@section('title', 'Billing')
@section('pages')

<div class="container-fluid">
    <div class="container">
            <div class="row ">
                <div class="col-12 ">
                    <table class="table table-bordered bg-white  ">
                        @php $company = $accountReceipt->company; @endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;" colspan="7">

                                                <x-CompanyLetterHead :company="$company" />
                                            </th>
                                        </tr>
                                    </thead>
                        <tbody>
                            @foreach($data as $list)
                            <tr>
                                <td colspan="7">
                                    <div class="text-center">
                                        <span style="font-size: 16px; color: #026494;">
                                            <strong>CONSIGNMENT NOTE</strong>
                                        </span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-center">
                                    <strong>BOOKING NUMBER</strong>
                                </td>
                                <td class="text-center">
                                    <strong>DATE</strong>
                                </td>
                                <td class="text-center">
                                    <strong>DELIVERY TYPE</strong>
                                </td>
                                <td class="text-center">
                                    <strong>ORIGIN</strong>
                                </td>
                                <td class="text-center">
                                    <strong>DESTINATION</strong>
                                </td>
                                <td class="text-center">
                                    <strong>PAYMENT</strong>
                                </td>
                                <td class="text-center">
                                    <strong>COPY FOR</strong>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-center" style="width: 14.66%;">
                                    <strong>{{$list->main_booking_no}}</strong>
                                </td>
                                <td class="text-center" style="width: 14.66%;">
                                    <strong>{{date('d-m-Y', strtotime($list->booking_date))}}</strong>
                                </td>
                                <td class="text-center" style="width: 14.66%;">
                                    <strong>{{$list->delivery_type}} ({{$list->transportation_mode}})</strong>
                                </td>
                                <td class="text-center" style="width: 14.66%;">
                                    <strong>{{$list->from_location}}</strong>
                                </td>
                                <td class="text-center" style="width: 14.66%;">
                                    <strong>{{$list->to_location}}</strong>
                                </td>
                                <td class="text-center" style="width: 14.66%;">
                                    <strong>{{$list->payment_term}}</strong>
                                </td>
                                <td class="text-center" style="width: 14.66%;">
                                    <span id="print_for"><strong>CONSIGNOR</strong></span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="font-size: 12px; width: 50%;" valign="top">
                                    <div class="ps-2">
                                        <strong>CONSIGNOR:</strong> <span style="font-size: 14px;"><strong>{{ $list->consignor }}</strong></span><br>
                                        <span style="font-size: 14px; text-transform: uppercase;">{{ $list-> billing_address}} </span>
                                    </div>
                                </td>
                                <td colspan="3" style="font-size: 12px; width: 20%;" valign="top">
                                    <div class="ps-2">
                                        <strong>CONSIGNEE:</strong> <span style="font-size: 14px;"><strong>{{ $list->consignee }}</strong></span><br>
                                        <span style="font-size: 14px; text-transform: uppercase;">{{ $list->pickup_address }}</span>
                                    </div>
                                </td>
                                <td colspan="2" style="font-size: 12px; width: 20%;" valign="top">
                                    <div class="ps-2" style="line-height: 13px;">
                                        <strong>SHIPPING ADDRESS:</strong><br>
                                        <span style="font-size: 12px; text-transform: uppercase;">{{ $list->consignee }}, {{$list->to_location}}, {{$list->shipping_address}},</span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5" style="font-size: 14px; padding-left: 5px;" valign="top">
                                    <table class="table table-bordered" style="font-size: 14px;">
                                        <thead>
                                            <tr class="border-bottom">
                                                <th style="width: 35%;"><strong>ITEM</strong></th>
                                                <!-- <th><strong>PKG TYPE</strong></th> -->
                                                <th><strong>QTY</strong></th>
                                                <th><strong>N.WT</strong></th>
                                                <th><strong>G.WT</strong></th>
                                                <th><strong>RATE</strong></th>
                                                <th><strong>TYPE</strong></th>
                                                <th class="text-end"><strong>AMOUNT</strong></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                         <?php   $totalquanity = 0; ?>
                                         <?php   $totalamount = 0; ?>
                                            @foreach($products as $product)
                                            <tr class="border-bottom">
                                                <td>{{$product->item_details}}</td>
                                                <td>{{$product->quantity}}</td>
                                                <td>{{$product->gross_weight}}{{$product->weight_calculation_on}}</td>
                                                <td>{{$product->gross_weight}}{{$product->weight_calculation_on}}</td>
                                                <!-- <td>{{$product->rate}}</td> -->
                                                <td><strong>{{$product->rate}}</strong></td>
                                                <td>{{$product->rate_calc_on}}</td>
                                                <td class="text-end">{{$product->total_amount}}</td>
                                            </tr>
                                             <?php $totalquanity += $product->quantity  ?>
                                             <?php $totalamount += $product->total_amount  ?>
                                            @endforeach
                                            <tr>
                                                <td class="fw-bold">Total</td>
                                                <!-- <td></td> -->
                                                <td>{{ $totalquanity }}</td>
                                                <td></td>
                                                <td> </td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-end">{{ $totalamount }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                                <td colspan="2" style="width: 10%;" valign="top">
                                    <table id="booking_charge" class="table table-bordered bg-white w-100" style="font-size: 14px; border-top-style: hidden; border-left-style: hidden; border-right-style: hidden;">
                                        <tbody>
                                            <tr>
                                                <th style="width: 55%; padding-left: 5px;">OTHER CHARGES</th>
                                                <th style="width: 45%;" class="text-end">AMOUNT</th>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5">
                                    <span style="font-size: 12px;">
                                        <strong>INVOICE NO: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; DATE: 31-08-2024
                                            &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;VALUE: Rs.0.00/-
                                        </strong>
                                    </span>
                                </td>
                                <td class="text-end">
                                    <strong>SUB TOTAL</strong>
                                </td>
                                <td class="text-end">
                                    <strong>{{$list->payment_term}}</strong>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5">
                                    <span style="font-size: 12px;">
                                        E-WAY BILL NO: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; DATE: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                                    </span>
                                </td>
                                <td class="text-end border-bottom-0">IGST 18%</td>
                                <td class="text-end border-bottom-0">0.00</td>
                            </tr>
                            <tr>
                                <td colspan="3">
                                    <p><strong>PRIVATE MARK:</strong></p>
                                </td>
                                <td colspan="2" class="text-center">
                                    <strong>TAX PAID BY  :{{$list->tax_paid_by}}</strong>
                                </td>
                                <td class="text-end">
                                    <span class="fw-bold" style="font-size: 14px;">
                                        CGST 9.0%<br>SGST 9.0%
                                    </span>
                                </td>
                                <td class="text-end">
                                    0.00<br>0.00
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3">
                                    <strong>
                                        <span class="pb-0">REMARKS</span><br>
                                    </strong>
                                    <span style="font-size: 14px;"></span>
                                    <strong>
                                        <p style="font-size: 14px;">CLAIM AMOUNT: </p>
                                    </strong>
                                </td>
                                <td colspan="2">
                                    <span class="text-end" style="font-size: 12px;">
                                        @php
                                        $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                                        @endphp     
                                        <strong>Amount in Word :</strong>{{ $f->format($totalamount)}}
                                    </span>
                                </td>
                                <td class="text-end" valign="top">
                                    <span style="font-size: 16px;">Insurance&nbsp;</span> <br>
                                    <strong>GRAND TOTAL<br></strong>
                                </td>
                                <td class="text-end" valign="top">
                                    <strong><span class="fw-bold" style="font-size: 18px;"><span class="fw-normal" style="font-size: 16px;">0.00</span> <br>TO BE BILLED</span></strong>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5">
                                    <div style="font-size: 12px; line-height: 1.2;">
                                        <span class="text-decoration-underline"><strong>CONSIGNMENT CAUTION:</strong></span><br>
                                        This consignment covered by set of lorry receipt from shall be stored at the destination under the control of the transport operator and shall be delivered to or to the order of the consignee whose name is mentioned in the lorry receipt. It will under no circumstance be delivered to consignee or its order, endorsed on the consignee copy or on a separate letter or authority.
                                    </div>
                                </td>
                                <td colspan="2" class="text-center" valign="top" style="font-size: 14px;">
                                    <strong>META MINT PRIVATE LIMITED</strong>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="7">
                                    <div style="font-size: 14px;">
                                        BANK A/C NAME:
                                        <strong>Ignite Software Technologies</strong>,
                                        ACCOUNT NO:
                                        <strong>20115457854</strong>, BANK: State Bank of India,
                                        IFSC: <strong>2011</strong>, BRANCH:
                                        <strong>Chittyaranjan Branch</strong>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        @endforeach
        <div class="row mt-2">
            <div class="col-12 text-center">
                <button class="btn btn-primary btn-md" id="btn_print" style="margin: 0 20px;"><i class="fa fa-print"></i> PRINT INVOICE</button>
            </div>
        </div>
        <br>
    </div>
</div>
@endsection
