@extends('layouts.app')
@section('title','Books')
@section('pages')

<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    .dataTables_filter{
        margin-bottom: 6px;
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> Books
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="42" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">Books</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i>  Book Details </li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->
  <div class="card style_table shadow-none radius-5 min-height my-auto">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">
        <div class="col-lg-12 col-md-12">
          <div class="ms-auto float-md-end">

            <div class="btn-group">
                <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            </div>

            <div class="btn-group">
              @if(in_array('books-edit', $authRolePermissions))
                <a href="{{route('books.edit',$data->id)}}" class="btn btn-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                    <i class="bi bi-pencil-square text-white"></i>
                </a>
              @endif
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row auto">
      <div class="col-xl-12 mx-auto">
          <div class="shadow-none radius-5 min-height">
              <div class="row">
                  <div class="col-md-9">
                      <div class="card">
                          <div class="card-body g-3">
                              <div class="table-responsive">
                                  <div class="d-flex justify-content-between">
                                      <h5 class="mb-0">Book Details</h5>
                                  </div>
                                  <hr class="mb-2">
                                  <table class="table table-bordered align-middle">
                                    <tr>
                                        <td style="text-align:left;">Book Title </td>
                                        <td>{!! $data->short_name !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">ISBN No </td>
                                        <td>{!! $data->shortcode !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Category/Genres</td>
                                        <td>{!! $data->genre !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Author</td>
                                        <td>{!! $data->book_details->author !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Publisher</td>
                                        <td>{!! $data->book_details->publisher !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Language</td>
                                        <td>{!! $data->book_details->laguage !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Stream</td>
                                        <td>{!! $data->book_details->stream_id !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">No Of Pages</td>
                                        <td>{!! $data->book_details->no_of_pages !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Book Class</td>
                                        <td>{!! $data->book_details->book_class !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Tag</td>
                                        <td>{!! $data->book_details->book_tag !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Dimensions</td>
                                        <td>{!! $data->book_details->dimension !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Translator</td>
                                        <td>{!! $data->book_details->translator !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">Url</td>
                                        <td>{!! $data->book_details->book_url !!}</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:left;">About Book</td>
                                        <td>{!! $data->descriptionl !!}</td>
                                    </tr>
                                  </table>
                              </div>
                          </div>
                      </div>
                  </div>
                  <div class="col-md-3">
                      <div class="card">
                          <div class="card-body g-3 row">
                              <div class="table-responsive text-center" style="margin-bottom: 18px;min-height: 300px;">
                                  @if($data->image != '')
                                      <img src="{!! getTempUrl($data->image) !!}" height="auto" id="createImage" data-bs-toggle="modal" data-bs-target="#commonModal" style="cursor: pointer;max-width: 120px;width: 120px;">
                                  @else
                                      <img src="{!! asset('admin/images/avtaar.png') !!}" width="100%" height="auto" id="createImage" data-bs-toggle="modal" data-bs-target="#commonModal" style="cursor: pointer;max-width: 120px;width: 120px;">
                                  @endif
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
      <div class="col-xl-12 mx-auto">
          <div class="shadow-none radius-5 min-height">
              <div class="row">
                  <div class="col-md-12">
                      <div class="card">
                          <div class="card-body g-3" id="book_images">
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
      </div>
  </div>

    <!--end row-->
@endsection
@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script type="text/javascript">
    $(document).on('click', '.save_button', function(event){
        event.preventDefault();
        var error = 0;

        if ($('#commonModal').find('form').hasClass('relatives')) {
            $('.error_name').hide();
            $('.error_code').hide();
            $('.error_priority').hide();

            if (error == 0) {
                let formdata = new FormData($('#commonModal').find('form')[0]);

                $.ajax({
                    url: $('#commonModal').find('form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        if (response.success === true) {
                            fetch_images();
                            toastr.success(response.message, 'Success.');

                            // hide modal
                            $('#commonModal').modal('hide');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');

                    // hide modal
                    $('#commonModal').modal('hide');
                    $('#commonModal').find('.modal-body').html('');
                });
              }
        }
        error = 1;
    })
    $( function() {
        $('.datepicker').datepicker({
            "dateFormat" : "dd-mm-yy",
            "maxDate": '0',
            "changeMonth": true,
            "changeYear": true
        }).datepicker("setDate",'now')
        .on('changeDate', function (ev) {
             $(this).datepicker('hide');
        })

    });
    function clickBTN() {
      $('#createLicenses').trigger('click');
    }
    $(document).ready(function(){
        // fetch_banks();
        // fetch_address();
        fetch_images();
        // fetch_licenses();
        // fetch_payments();
        // fetch_attachments();
    });

    function fetch_images(){
      $.ajax({
        url:"{!! route('books.images', $data->id) !!}",
        success:function(data){
            $('#book_images').html('');
            $('#book_images').html(data);
            $.switcher('#book_images .changeAccountStatus');
        }
      })
    }

    /*$(document).on('click', '#createImage', function(){
        $('#commonModalLabel').text('Upload New Image');
        $('.save_button_span').text('Upload Image');
        $.ajax({
          url:"{!! route('account-images.create_images', $data->id) !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
          }
        })
    })*/

    $(document).on('click', '#createRelative', function(){
        $('#commonModalLabel').text('Add New Image');
        $('.save_button_span').text('Save Image');
        $.ajax({
          url:"{!! route('book.image.create', $data->id) !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            changecontry();
          }
        })
    });

    $(document).on('click', '.editRelative', function(){
        $('#commonModalLabel').text('Edit Image');
        $('.save_button_span').text('Update Image');
        var id = $(this).data('id');
        var url = `{!! route('book.image.edit', ':id') !!}`.replace(':id', id);

        $.ajax({
          url:url,
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            $('#states').trigger('change');
          }
        })
    });

    $("body").on("click",'.deleteAccountData', function(event){
        dataString    = {"id":$(this).data('id')};
        var UrlValue  = $(this).data('url');
        var btn = $(this);
        //alert(dataValue);
        console.log($('meta[name="csrf-token"]').attr('content'));
        console.log(dataString);

        Swal.fire({
            title: 'Are you sure you want to delete this?',
            icon: 'warning',
            showDenyButton: true,
            showCancelButton: false,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
        }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) {
                $.ajax({
                url     : UrlValue,
                method  : 'post',
                data    :{
                    "_token": $('meta[name="csrf-token"]').attr('content'),
                    "id": $(this).data('id')
                },
                headers:
                {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                beforeSend: function( xhr ) {
                    // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                },
                success : function(response){
                    console.log(response.data);
                    if(response.success){
                        var ErroMsg = $(this).printErrorMsg(response.message);

                        $(this).Toastshow('success',ErroMsg);

                        if(btn.hasClass('address')){
                            // fetch_address();
                            fetch_images();
                        }
                    }else{
                        var ErroMsg = $(this).printErrorMsg(response.message);
                        $(this).Toastshow('error',ErroMsg);
                    }
                },
                error: function (data) {
                  console.log("error ",data);
                }
            });
            }
        });
    });

    /*********change status**********/
    $("body").on("click",'.changeAccountStatus', function(event){
        dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};
        var UrlValue     = $(this).data('url');
        var status       = $(this).data('status');
        var changeStatus = $(this);

        Swal.fire({
            title: 'Are you sure you want to change status?',
            icon: 'warning',
            showDenyButton: true,
            showCancelButton: false,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
        }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) {
                $.ajax({
                    url     : UrlValue,
                    method  : 'post',
                    data    :dataString,
                    headers:
                    {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    beforeSend: function( xhr ) {
                        // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                    },
                    success : function(response){
                        if(response.success){
                            var ErroMsg = $(this).printErrorMsg(response.message);
                            $(this).Toastshow('success',ErroMsg);

                            if($(this).hasClass('address')){
                                // fetch_address();
                                fetch_images();
                            }

                        } else {
                            var ErroMsg = $(this).printErrorMsg(response.message);
                            if (ErroMsg === '') {
                                ErroMsg = "Something went wrong!";
                            }
                            $(this).Toastshow('error',ErroMsg);

                            if (status == 1) {
                                changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                            } else {
                                changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                            }
                        }
                    },
                    error: function (data) {
                        console.log("error ",data);

                        if (status == 1) {
                            changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                        } else {
                            changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                        }
                    }
                });
            }
            else if (result.isDenied) {
                if (status == 1) {
                    changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                } else {
                    changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                }

                if($(this).hasClass('address')){
                    // fetch_address();
                    fetch_images();
                }
            }
            //return false;
        });
    //return false;
    });
</script>
@endsection
