 <div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Book Title</th>
                <th>ISBN No</th>
                <th>Publisher</th>
                <th>Language</th>
                <th>Pages</th>
                <th class="thbutton">Status</th>
                @if(in_array('books-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('books-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td><a href="{{route('books.show',$list->id)}}"><strong>@php echo  wordwrap($list->short_name,50,"<br>\n") @endphp</strong></a></td>
                        <td>{!! $list->shortcode !!}</td>
                        <td>{!! $list->book_details->publisher??'' !!}</td>
                        <td>{!! $list->book_details->laguage??'' !!}</td>
                        <td>{!! $list->book_details->no_of_pages??'' !!}</td>
                        <td>
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('books.changeStatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('books-edit', $authRolePermissions))
                        <td>
                            <a href="{{route('books.edit',$list->id)}}" class="btn btn-outline-secondary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </a>
                        </td>
                        @endif
                        @if(in_array('books-delete', $authRolePermissions))
                        <td>
                            <a data-url="{{route('books.destroy',$list->id)}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="10">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="row align-items-center mt-3">
    <div class="col-md-6">
        {!! $data->onEachSide(0)->render('books.pagination') !!}
    </div>
    @if(in_array('books-create', $authRolePermissions))
    <div class="col-md-6" style="text-align: right;">
        <div class="btn-group mb-0">
            <button type="button" class="btn btn-outline-primary" id="import" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-upload"></i> Upload from Excel</button>
        </div>
        <div class="btn-group mb-0">
            <a href="{{ route('books-opening-stock.add') }}" class="btn btn-outline-primary" ><i class="bi bi-upload"></i> Book Opening Stock Excel</a>
        </div>
    </div>
    @endif
</nav>
</div>
