@extends('layouts.app')
@section('title','Bucket')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
  <div class="breadcrumb-title pe-3">Settings</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        
        <li class="breadcrumb-item active" aria-current="page">Edit Bucket</li>
    </ol>
</nav>
</div>
<div class="ms-auto">
    <div class="btn-group">
      <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
  </div>
</div>
</div>
<!--end breadcrumb-->


<div class="row auto">
   <div class="col-xl-12 mx-auto">
      <div class="shadow-none radius-5 min-height">
         <div class="">
            <div class="">
                <form class="row g-3 auto-width" action="{{ route('buckets.update',$bucketData->id)}}" method="post" enctype='multipart/form-data'>
                    <!-- For validation comment on -->
                    <!-- <form class="row g-3 was-validated"> -->
                       <div class="card col-md-6 col-sm-12">
                        <div class="card-body g-3 row">
                            <h5 class="mb-0">Bucket</h5>
                            <hr class="mb-0">
                            @csrf
                            @method('PUT')
                            <div class="col-md-6">
                                <label for="validatinCustom01" class="form-label">Company Name <span class="text-danger"><b>*</b></span></label>
                                <select class="single-select" name="user_id" required>
                                    <option value="">--Select--</option>
                                    @foreach($companyData as $list)
                                    @if(isset($bucketData->user_id) && $bucketData->user_id==$list->id)
                                    <option value="{{$list->id}}" selected>{{$list->name}}</option>
                                    @else
                                    <option value="{{$list->id}}">{{$list->name}}</option>
                                    @endif
                                    @endforeach
                                </select>
                                @if ($errors->has('user_id'))
                                <span class="text-danger">{{ $errors->first('user_id') }}</span>
                                @endif
                            </div>
                            <div class="col-md-6">
                             <label for="validationCustom01" class="form-label">Bucket Name</label>
                             <input type="text" name="bucket_name" class="form-control" value="{{$bucketData->bucket_name}}">
                             @if ($errors->has('bucket_name'))
                             <span class="text-danger">{{ $errors->first('bucket_name') }}</span>
                             @endif
                         </div>							
                         <div class="col-md-6">
                             <label for="validationCustomUsername" class="form-label">Root Folder</label>
                             <input type="text" class="form-control" id="validationCustomUsername" name="root_folder" value="{{$bucketData->root_folder}}" aria-describedby="inputGroupPrepend" required>
                             @if ($errors->has('root_folder'))
                             <span class="text-danger">{{ $errors->first('root_folder') }}</span>
                             @endif
                         </div>
                         <div class="col-md-6">
                            <label for="validationTextarea" class="form-label">Access Key</label>
                            <input type="text" class="form-control" id="validationCustomUsername" name="access_key" value="{{$bucketData->access_key}}" aria-describedby="inputGroupPrepend" required>
                            @if ($errors->has('access_key'))
                            <span class="text-danger">{{ $errors->first('access_key') }}</span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Secret Key</label>
                            <input type="text" class="form-control" placeholder="" name="secret_key" value="{{$bucketData->secret_key}}" />
                            @if ($errors->has('secret_key'))
                            <span class="text-danger">{{ $errors->first('secret_key') }}</span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <label for="validationTextarea" class="form-label">Region</label>
                            <input type="text" class="form-control" name="region" aria-label="file example" value="{{$bucketData->region}}">
                            <div class="invalid-feedback">Example invalid form file </div>
                        </div>
                        <div class="col-md-6">
                            <label for="validationTextarea" class="form-label">ACL</label>
                            <input type="text" class="form-control" name="acl" aria-label="file example" value="{{$bucketData->acl}}">
                            <div class="invalid-feedback">Example invalid form file </div>
                        </div>
                        <div class="col-12" align="center">
                            <div class="d-grid gap-2 with-50">
                              <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Update Bucket</button>
                          </div>
                      </div>
                  </div>
              </div>
          </form>
      </div>
  </div>
</div>

</div>
</div>
<!--end row-->
@endsection